/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.context.java;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jpt.common.core.internal.utility.TypeTools;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.collection.CollectionTools;
import org.eclipse.jpt.common.utility.internal.collection.HashBag;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyListIterable;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterable.SingleElementIterable;
import org.eclipse.jpt.common.utility.iterable.ListIterable;
import org.eclipse.jpt.common.utility.transformer.Transformer;
import org.eclipse.jpt.jaxb.core.JaxbNode;
import org.eclipse.jpt.jaxb.core.context.JaxbAttributeMapping;
import org.eclipse.jpt.jaxb.core.context.JaxbAttributesContainer;
import org.eclipse.jpt.jaxb.core.context.JaxbClassMapping;
import org.eclipse.jpt.jaxb.core.context.JaxbPackage;
import org.eclipse.jpt.jaxb.core.context.JaxbPackageInfo;
import org.eclipse.jpt.jaxb.core.context.JaxbPersistentAttribute;
import org.eclipse.jpt.jaxb.core.context.XmlAccessOrder;
import org.eclipse.jpt.jaxb.core.context.XmlAccessType;
import org.eclipse.jpt.jaxb.core.context.XmlNamedNodeMapping;
import org.eclipse.jpt.jaxb.core.context.java.JavaClass;
import org.eclipse.jpt.jaxb.core.context.java.JavaClassMapping;
import org.eclipse.jpt.jaxb.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.jaxb.core.context.java.JavaType;
import org.eclipse.jpt.jaxb.core.internal.AbstractJaxbNode;
import org.eclipse.jpt.jaxb.core.internal.context.java.AbstractJavaTypeMapping;
import org.eclipse.jpt.jaxb.core.internal.context.java.GenericJavaAttributesContainer;
import org.eclipse.jpt.jaxb.core.resource.java.XmlAccessorOrderAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlAccessorTypeAnnotation;
import org.eclipse.jpt.jaxb.core.validation.JptJaxbCoreValidationMessages;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJavaClassMapping
extends AbstractJavaTypeMapping
implements JavaClassMapping {
    protected String specifiedFactoryClass;
    protected String factoryMethod;
    protected final PropOrderContainer propOrderContainer;
    protected String superclassName;
    protected static final String SUPERCLASSNAME_PROPERTY = "superclassName";
    protected JaxbClassMapping superclass;
    protected XmlAccessType accessType;
    protected XmlAccessType defaultAccessType;
    protected XmlAccessType specifiedAccessType;
    protected XmlAccessOrder defaultAccessOrder;
    protected XmlAccessOrder specifiedAccessOrder;
    protected boolean hasRootElementInHierarchy_loaded = false;
    protected boolean hasRootElementInHierarchy = false;
    protected final JaxbAttributesContainer attributesContainer;
    protected final Map<JaxbClassMapping, JaxbAttributesContainer> includedAttributesContainers = new Hashtable<JaxbClassMapping, JaxbAttributesContainer>();

    public GenericJavaClassMapping(JavaClass parent) {
        super(parent);
        this.propOrderContainer = new PropOrderContainer();
        this.initFactoryClass();
        this.initFactoryMethod();
        this.initPropOrder();
        this.initAccessType();
        this.initSpecifiedAccessOrder();
        this.initDefaultAccessOrder();
        this.initSuperclassName();
        this.attributesContainer = new GenericJavaAttributesContainer(this, this.buildAttributesContainerOwner(), this.getJavaResourceType());
    }

    public JavaResourceType getJavaResourceType() {
        return (JavaResourceType)super.getJavaResourceType();
    }

    @Override
    public JavaClass getJavaType() {
        return (JavaClass)super.getJavaType();
    }

    public JaxbPackageInfo getPackageInfo() {
        JaxbPackage jaxbPackage = this.getJaxbPackage();
        return jaxbPackage == null ? null : jaxbPackage.getPackageInfo();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.syncFactoryClass();
        this.syncFactoryMethod();
        this.syncPropOrder();
        this.syncAccessType();
        this.syncSpecifiedAccessOrder();
        this.syncSuperclassName();
        this.attributesContainer.synchronizeWithResourceModel();
        this.syncIncludedAttributes();
    }

    @Override
    public void update() {
        super.update();
        this.updateSuperclass();
        this.updateAccessType();
        this.updateDefaultAccessOrder();
        this.hasRootElementInHierarchy_loaded = false;
        this.attributesContainer.update();
        this.updateIncludedAttributes();
    }

    @Override
    public String getFactoryClass() {
        return this.specifiedFactoryClass != null ? this.specifiedFactoryClass : "javax.xml.bind.annotation.XmlType.DEFAULT";
    }

    @Override
    public String getSpecifiedFactoryClass() {
        return this.specifiedFactoryClass;
    }

    @Override
    public void setSpecifiedFactoryClass(String factoryClass) {
        this.getXmlTypeAnnotation().setFactoryClass(factoryClass);
        this.setSpecifiedFactoryClass_(factoryClass);
    }

    protected void setSpecifiedFactoryClass_(String factoryClass) {
        String old = this.specifiedFactoryClass;
        this.specifiedFactoryClass = factoryClass;
        this.firePropertyChanged("specifiedFactoryClass", old, factoryClass);
    }

    protected String getResourceFactoryClass() {
        return this.getXmlTypeAnnotation().getFactoryClass();
    }

    protected void initFactoryClass() {
        this.specifiedFactoryClass = this.getResourceFactoryClass();
    }

    protected void syncFactoryClass() {
        this.setSpecifiedFactoryClass_(this.getResourceFactoryClass());
    }

    @Override
    public String getFactoryMethod() {
        return this.factoryMethod;
    }

    @Override
    public void setFactoryMethod(String factoryMethod) {
        this.getXmlTypeAnnotation().setFactoryMethod(factoryMethod);
        this.setFactoryMethod_(factoryMethod);
    }

    protected void setFactoryMethod_(String factoryMethod) {
        String old = this.factoryMethod;
        this.factoryMethod = factoryMethod;
        this.firePropertyChanged("factoryMethod", old, factoryMethod);
    }

    protected String getResourceFactoryMethod() {
        return this.getXmlTypeAnnotation().getFactoryMethod();
    }

    protected void initFactoryMethod() {
        this.factoryMethod = this.getResourceFactoryMethod();
    }

    protected void syncFactoryMethod() {
        this.setFactoryMethod_(this.getResourceFactoryMethod());
    }

    @Override
    public ListIterable<String> getPropOrder() {
        return this.propOrderContainer.getContextElements();
    }

    @Override
    public String getProp(int index) {
        return (String)this.propOrderContainer.getContextElement(index);
    }

    @Override
    public int getPropOrderSize() {
        return this.propOrderContainer.getContextElementsSize();
    }

    @Override
    public void addProp(int index, String prop) {
        this.getXmlTypeAnnotation().addProp(index, prop);
        this.propOrderContainer.addContextElement(index, prop);
    }

    @Override
    public void removeProp(String prop) {
        this.removeProp(this.propOrderContainer.indexOfContextElement(prop));
    }

    @Override
    public void removeProp(int index) {
        this.getXmlTypeAnnotation().removeProp(index);
        this.propOrderContainer.removeContextElement(index);
    }

    @Override
    public void moveProp(int targetIndex, int sourceIndex) {
        this.getXmlTypeAnnotation().moveProp(targetIndex, sourceIndex);
        this.propOrderContainer.moveContextElement(targetIndex, sourceIndex);
    }

    protected void initPropOrder() {
        this.propOrderContainer.initialize();
    }

    protected void syncPropOrder() {
        this.propOrderContainer.synchronizeWithResourceModel();
    }

    protected ListIterable<String> getResourcePropOrder() {
        ListIterable<String> result = this.getXmlTypeAnnotation().getPropOrder();
        if (IterableTools.size(result) == 1 && "".equals(IterableTools.get(result, (int)0))) {
            return EmptyListIterable.instance();
        }
        return result;
    }

    @Override
    public XmlAccessType getAccessType() {
        return this.accessType;
    }

    protected void setAccessType_(XmlAccessType accessType) {
        XmlAccessType old = this.accessType;
        this.accessType = accessType;
        this.firePropertyChanged("accessType", old, accessType);
    }

    @Override
    public XmlAccessType getDefaultAccessType() {
        return this.defaultAccessType;
    }

    protected void setDefaultAccessType_(XmlAccessType access) {
        XmlAccessType old = this.defaultAccessType;
        this.defaultAccessType = access;
        this.firePropertyChanged("defaultAccessType", old, access);
    }

    @Override
    public XmlAccessType getSpecifiedAccessType() {
        return this.specifiedAccessType;
    }

    @Override
    public void setSpecifiedAccessType(XmlAccessType access) {
        this.getXmlAccessorTypeAnnotation().setValue(XmlAccessType.toJavaResourceModel(access));
        this.setSpecifiedAccessType_(access);
    }

    protected void setSpecifiedAccessType_(XmlAccessType access) {
        XmlAccessType old = this.specifiedAccessType;
        this.specifiedAccessType = access;
        this.firePropertyChanged("specifiedAccessType", old, access);
    }

    protected void initAccessType() {
        this.specifiedAccessType = this.getResourceAccessType();
    }

    protected void syncAccessType() {
        this.setSpecifiedAccessType(this.getResourceAccessType());
    }

    protected void updateAccessType() {
        this.setDefaultAccessType_(this.buildDefaultAccessType());
        XmlAccessType actual = this.specifiedAccessType != null ? this.specifiedAccessType : this.defaultAccessType;
        this.setAccessType_(actual);
    }

    protected XmlAccessType buildDefaultAccessType() {
        XmlAccessType accessType = this.getSuperclassAccessType();
        if (accessType != null) {
            return accessType;
        }
        accessType = this.getPackageAccessType();
        if (accessType != null) {
            return accessType;
        }
        return XmlAccessType.PUBLIC_MEMBER;
    }

    protected XmlAccessType getSuperclassAccessType() {
        JaxbClassMapping superclass = this.superclass;
        while (superclass != null) {
            XmlAccessType accessType = superclass.getSpecifiedAccessType();
            if (accessType != null) {
                return accessType;
            }
            superclass = superclass.getSuperclass();
        }
        return null;
    }

    protected XmlAccessType getPackageAccessType() {
        JaxbPackageInfo packageInfo = this.getPackageInfo();
        return packageInfo == null ? null : packageInfo.getAccessType();
    }

    protected XmlAccessorTypeAnnotation getXmlAccessorTypeAnnotation() {
        return (XmlAccessorTypeAnnotation)this.getJavaResourceType().getNonNullAnnotation("javax.xml.bind.annotation.XmlAccessorType");
    }

    protected XmlAccessType getResourceAccessType() {
        return XmlAccessType.fromJavaResourceModel(this.getXmlAccessorTypeAnnotation().getValue());
    }

    @Override
    public XmlAccessOrder getAccessOrder() {
        return this.specifiedAccessOrder != null ? this.specifiedAccessOrder : this.defaultAccessOrder;
    }

    @Override
    public XmlAccessOrder getDefaultAccessOrder() {
        return this.defaultAccessOrder;
    }

    protected void setDefaultAccessOrder_(XmlAccessOrder accessOrder) {
        XmlAccessOrder old = this.defaultAccessOrder;
        this.defaultAccessOrder = accessOrder;
        this.firePropertyChanged("defaultAccessOrder", old, accessOrder);
    }

    @Override
    public XmlAccessOrder getSpecifiedAccessOrder() {
        return this.specifiedAccessOrder;
    }

    @Override
    public void setSpecifiedAccessOrder(XmlAccessOrder accessOrder) {
        this.getXmlAccessorOrderAnnotation().setValue(XmlAccessOrder.toJavaResourceModel(accessOrder));
        this.setSpecifiedAccessOrder_(accessOrder);
    }

    protected void setSpecifiedAccessOrder_(XmlAccessOrder accessOrder) {
        XmlAccessOrder old = this.specifiedAccessOrder;
        this.specifiedAccessOrder = accessOrder;
        this.firePropertyChanged("specifiedAccessOrder", old, accessOrder);
    }

    protected void initDefaultAccessOrder() {
        this.defaultAccessOrder = this.buildDefaultAccessOrder();
    }

    protected void updateDefaultAccessOrder() {
        this.setDefaultAccessOrder_(this.buildDefaultAccessOrder());
    }

    protected XmlAccessOrder buildDefaultAccessOrder() {
        XmlAccessOrder accessOrder = this.getSuperclassAccessOrder();
        if (accessOrder != null) {
            return accessOrder;
        }
        accessOrder = this.getPackageAccessOrder();
        if (accessOrder != null) {
            return accessOrder;
        }
        return XmlAccessOrder.UNDEFINED;
    }

    protected XmlAccessOrder getSuperclassAccessOrder() {
        JaxbClassMapping superclass = this.superclass;
        while (superclass != null) {
            XmlAccessOrder accessOrder = superclass.getSpecifiedAccessOrder();
            if (accessOrder != null) {
                return accessOrder;
            }
            superclass = superclass.getSuperclass();
        }
        return null;
    }

    protected XmlAccessOrder getPackageAccessOrder() {
        JaxbPackageInfo packageInfo = this.getPackageInfo();
        return packageInfo == null ? null : packageInfo.getAccessOrder();
    }

    protected XmlAccessorOrderAnnotation getXmlAccessorOrderAnnotation() {
        return (XmlAccessorOrderAnnotation)this.getJavaResourceType().getNonNullAnnotation("javax.xml.bind.annotation.XmlAccessorOrder");
    }

    protected XmlAccessOrder getResourceAccessOrder() {
        return XmlAccessOrder.fromJavaResourceModel(this.getXmlAccessorOrderAnnotation().getValue());
    }

    protected void initSpecifiedAccessOrder() {
        this.specifiedAccessOrder = this.getResourceAccessOrder();
    }

    protected void syncSpecifiedAccessOrder() {
        this.setSpecifiedAccessOrder_(this.getResourceAccessOrder());
    }

    protected void initSuperclassName() {
        this.superclassName = this.getResourceSuperclassName();
    }

    protected void syncSuperclassName() {
        String old = this.superclassName;
        this.superclassName = this.getResourceSuperclassName();
        this.firePropertyChanged(SUPERCLASSNAME_PROPERTY, old, this.superclassName);
    }

    protected String getResourceSuperclassName() {
        return this.getJavaResourceType().getSuperclassQualifiedName();
    }

    @Override
    public JaxbClassMapping getSuperclass() {
        return this.superclass;
    }

    protected void setSuperclass_(JaxbClassMapping superclass) {
        JaxbClassMapping old = this.superclass;
        this.superclass = superclass;
        this.firePropertyChanged("superclass", old, superclass);
    }

    protected void updateSuperclass() {
        this.setSuperclass_(this.findSuperclass());
    }

    protected JaxbClassMapping findSuperclass() {
        if (this.superclassName != null) {
            return this.getJaxbProject().getContextRoot().getClassMapping(this.superclassName);
        }
        return null;
    }

    @Override
    public Iterable<JavaPersistentAttribute> getAttributes() {
        return this.attributesContainer.getAttributes();
    }

    @Override
    public int getAttributesSize() {
        return this.attributesContainer.getAttributesSize();
    }

    protected JaxbAttributesContainer.Context buildAttributesContainerOwner() {
        return new JaxbAttributesContainer.Context(){

            @Override
            public XmlAccessType getAccessType() {
                return GenericJavaClassMapping.this.getAccessType();
            }

            @Override
            public void attributeAdded(JaxbPersistentAttribute attribute) {
                GenericJavaClassMapping.this.fireItemAdded("attributes", attribute);
            }

            @Override
            public void attributeRemoved(JaxbPersistentAttribute attribute) {
                GenericJavaClassMapping.this.fireItemRemoved("attributes", attribute);
            }
        };
    }

    @Override
    public Iterable<JaxbPersistentAttribute> getIncludedAttributes() {
        return IterableTools.children(this.getIncludedAttributesContainers(), JaxbAttributesContainer.ATTRIBUTES_TRANSFORMER);
    }

    protected Iterable<JaxbAttributesContainer> getIncludedAttributesContainers() {
        return IterableTools.cloneLive(this.includedAttributesContainers.values());
    }

    @Override
    public int getIncludedAttributesSize() {
        int size = 0;
        for (JaxbAttributesContainer attributesContainer : this.getIncludedAttributesContainers()) {
            size += attributesContainer.getAttributesSize();
        }
        return size;
    }

    protected void syncIncludedAttributes() {
        for (JaxbAttributesContainer attributesContainer : this.includedAttributesContainers.values()) {
            attributesContainer.synchronizeWithResourceModel();
        }
    }

    protected void updateIncludedAttributes() {
        HashSet oldSuperclasses = CollectionTools.set(this.includedAttributesContainers.keySet());
        HashSet oldAttributes = CollectionTools.set(this.getIncludedAttributes());
        if (!this.isXmlTransient()) {
            JaxbClassMapping superclass = this.superclass;
            while (superclass != null && superclass.isXmlTransient()) {
                if (this.includedAttributesContainers.containsKey(superclass)) {
                    this.includedAttributesContainers.get(superclass).update();
                    oldSuperclasses.remove(superclass);
                } else {
                    this.includedAttributesContainers.put(superclass, this.buildIncludedAttributesContainer(superclass));
                }
                superclass = superclass.getSuperclass();
            }
        }
        for (JaxbClassMapping oldSuperclass : oldSuperclasses) {
            this.includedAttributesContainers.remove(oldSuperclass);
        }
        HashSet newAttributes = CollectionTools.set(this.getIncludedAttributes());
        if (IterableTools.elementsAreDifferent((Iterable)oldAttributes, (Iterable)newAttributes)) {
            this.fireCollectionChanged("includedAttributes", newAttributes);
        }
    }

    protected JaxbAttributesContainer buildIncludedAttributesContainer(JaxbClassMapping classMapping) {
        return classMapping.buildIncludedAttributesContainer(this, this.buildIncludedAttributesContainerOwner());
    }

    protected JaxbAttributesContainer.Context buildIncludedAttributesContainerOwner() {
        return new JaxbAttributesContainer.Context(){

            @Override
            public XmlAccessType getAccessType() {
                return GenericJavaClassMapping.this.getAccessType();
            }

            @Override
            public void attributeAdded(JaxbPersistentAttribute attribute) {
                GenericJavaClassMapping.this.fireItemAdded("includedAttributes", attribute);
            }

            @Override
            public void attributeRemoved(JaxbPersistentAttribute attribute) {
                GenericJavaClassMapping.this.fireItemRemoved("includedAttributes", attribute);
            }
        };
    }

    @Override
    public JaxbAttributesContainer buildIncludedAttributesContainer(JaxbClassMapping parent, JaxbAttributesContainer.Context context) {
        return new GenericJavaAttributesContainer(parent, context, this.getJavaResourceType());
    }

    @Override
    public Iterable<JaxbPersistentAttribute> getAllLocallyDefinedAttributes() {
        return IterableTools.concatenate((Iterable[])new Iterable[]{this.getAttributes(), this.getIncludedAttributes()});
    }

    @Override
    public Iterable<JaxbPersistentAttribute> getInheritedAttributes() {
        return IterableTools.concatenate((Iterable[])new Iterable[]{this.getIncludedAttributes(), this.getOtherInheritedAttributes()});
    }

    public Iterable<JaxbPersistentAttribute> getAllAttributes() {
        return IterableTools.concatenate((Iterable[])new Iterable[]{this.getAttributes(), this.getIncludedAttributes(), this.getOtherInheritedAttributes()});
    }

    protected Iterable<JaxbPersistentAttribute> getOtherInheritedAttributes() {
        return this.superclass == null ? IterableTools.emptyIterable() : IterableTools.children((Iterable)ObjectTools.chain((Object)this.superclass, JaxbClassMapping.SUPER_CLASS_TRANSFORMER), JaxbClassMapping.ATTRIBUTES_TRANSFORMER);
    }

    @Override
    public boolean hasRootElementInHierarchy() {
        if (!this.hasRootElementInHierarchy_loaded) {
            this.hasRootElementInHierarchy = this.calculateHasRootElementInHierarchy();
            this.hasRootElementInHierarchy_loaded = true;
        }
        return this.hasRootElementInHierarchy;
    }

    protected boolean calculateHasRootElementInHierarchy() {
        if (this.getXmlRootElement() != null) {
            return true;
        }
        for (JavaType jaxbType : this.getJaxbProject().getContextRoot().getJavaTypes()) {
            if (jaxbType.getMapping() == null || jaxbType.getMapping().isXmlTransient() || jaxbType.getMapping().getXmlRootElement() == null || !TypeTools.isSubType((String)jaxbType.getTypeName().getFullyQualifiedName(), (String)this.getJavaType().getTypeName().getFullyQualifiedName(), (IJavaProject)this.getJaxbProject().getJavaProject())) continue;
            return true;
        }
        return false;
    }

    @Override
    protected Iterable<String> getTransientReferencedXmlTypeNames() {
        return IterableTools.concatenate((Iterable[])new Iterable[]{super.getTransientReferencedXmlTypeNames(), new SingleElementIterable((Object)this.getJavaResourceType().getSuperclassQualifiedName())});
    }

    @Override
    protected Iterable<String> getNonTransientReferencedXmlTypeNames() {
        return IterableTools.concatenate((Iterable[])new Iterable[]{super.getNonTransientReferencedXmlTypeNames(), IterableTools.singletonIterable((Object)this.superclassName), IterableTools.children(this.getAttributeMappings(), JaxbAttributeMapping.REFERENCED_XML_TYPE_NAMES_TRANSFORMER)});
    }

    @Override
    public JaxbAttributeMapping getXmlIdMapping() {
        Iterator allXmlIdMappings = IterableTools.filter((Iterable)IterableTools.downCast((Iterable)IterableTools.filter((Iterable)IterableTools.transform(this.getAllAttributes(), JaxbPersistentAttribute.MAPPING_TRANSFORMER), XmlNamedNodeMapping.IS_NAMED_NODE_MAPPING)), XmlNamedNodeMapping.HAS_XML_ID).iterator();
        return allXmlIdMappings.hasNext() ? (XmlNamedNodeMapping)allXmlIdMappings.next() : null;
    }

    protected Iterable<? extends JaxbAttributeMapping> getAttributeMappings() {
        return IterableTools.transform(this.getAttributes(), JaxbPersistentAttribute.MAPPING_TRANSFORMER);
    }

    @Override
    public Iterable<String> getCompletionProposals(int pos) {
        Iterable<String> result = super.getCompletionProposals(pos);
        if (!IterableTools.isEmpty(result)) {
            return result;
        }
        if (this.propTouches(pos)) {
            return this.getPropProposals();
        }
        for (JaxbPersistentAttribute jaxbPersistentAttribute : this.getAttributes()) {
            result = jaxbPersistentAttribute.getCompletionProposals(pos);
            if (IterableTools.isEmpty(result)) continue;
            return result;
        }
        return EmptyIterable.instance();
    }

    protected Iterable<String> getPropProposals() {
        return IterableTools.transform((Iterable)IterableTools.transform(this.getAllLocallyDefinedAttributes(), JaxbPersistentAttribute.NAME_TRANSFORMER), (Transformer)StringTools.JAVA_STRING_LITERAL_CONTENT_TRANSFORMER);
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.validateConstructor(messages, reporter);
        this.validatePropOrder(messages, reporter);
        this.validateXmlAnyAttributeMapping(messages);
        this.validateXmlAnyElementMapping(messages);
        this.validateXmlValueMapping(messages);
        this.validateXmlIDs(messages);
        for (JaxbPersistentAttribute jaxbPersistentAttribute : this.getAttributes()) {
            jaxbPersistentAttribute.validate(messages, reporter);
        }
    }

    protected void validateConstructor(List<IMessage> messages, IReporter reporter) {
        if (!"javax.xml.bind.annotation.XmlType.DEFAULT".equals(this.getFactoryClass())) {
            if (StringTools.isBlank((String)this.getFactoryMethod())) {
                messages.add(this.buildValidationMessage(this.getFactoryClassTextRange(), JptJaxbCoreValidationMessages.XML_TYPE__UNSPECIFIED_FACTORY_METHOD));
            }
        } else if (this.getFactoryMethod() == null && this.getJavaType().getXmlJavaTypeAdapter() == null && !this.getJavaResourceType().hasPublicOrProtectedNoArgConstructor()) {
            messages.add(this.buildValidationMessage(this.getValidationTextRange(), JptJaxbCoreValidationMessages.XML_TYPE__NO_PUBLIC_OR_PROTECTED_CONSTRUCTOR));
        }
    }

    protected void validatePropOrder(List<IMessage> messages, IReporter reporter) {
        if (IterableTools.isEmpty(this.getPropOrder())) {
            return;
        }
        HashBag props = CollectionTools.bag(this.getPropOrder());
        HashSet<String> allAttributes = new HashSet<String>();
        HashSet<String> requiredAttributes = new HashSet<String>();
        HashSet<String> transientAttributes = new HashSet<String>();
        for (JaxbPersistentAttribute attribute : this.getAllLocallyDefinedAttributes()) {
            allAttributes.add(attribute.getName());
            transientAttributes.add(attribute.getName());
        }
        for (JaxbPersistentAttribute attribute : this.getAllLocallyDefinedAttributes()) {
            if (attribute.getMapping().isParticleMapping()) {
                requiredAttributes.add(attribute.getName());
            }
            if (attribute.getMapping().isTransient()) continue;
            transientAttributes.remove(attribute.getName());
        }
        HashSet<Integer> duplicateProps = new HashSet<Integer>();
        HashSet missingProps = new HashSet(requiredAttributes);
        HashSet<Integer> nonexistentProps = new HashSet<Integer>();
        HashSet<Integer> transientProps = new HashSet<Integer>();
        int i = 0;
        while (i < this.getPropOrderSize()) {
            String prop = this.getProp(i);
            if (props.count((Object)prop) > 1) {
                duplicateProps.add(i);
            }
            if (missingProps.contains(prop)) {
                missingProps.remove(prop);
            }
            if (!allAttributes.contains(prop)) {
                nonexistentProps.add(i);
            }
            if (transientAttributes.contains(prop)) {
                transientProps.add(i);
            }
            ++i;
        }
        Iterator iterator = duplicateProps.iterator();
        while (iterator.hasNext()) {
            i = (Integer)iterator.next();
            messages.add(this.buildValidationMessage(this.getPropTextRange(i), JptJaxbCoreValidationMessages.XML_TYPE__DUPLICATE_PROP, this.getProp(i)));
        }
        for (String missingProp : missingProps) {
            messages.add(this.buildValidationMessage(this.getPropOrderTextRange(), JptJaxbCoreValidationMessages.XML_TYPE__MISSING_PROP, missingProp));
        }
        iterator = nonexistentProps.iterator();
        while (iterator.hasNext()) {
            i = (Integer)iterator.next();
            messages.add(this.buildValidationMessage(this.getPropTextRange(i), JptJaxbCoreValidationMessages.XML_TYPE__NONEXISTENT_PROP, this.getProp(i)));
        }
        iterator = transientProps.iterator();
        while (iterator.hasNext()) {
            i = (Integer)iterator.next();
            messages.add(this.buildValidationMessage(this.getPropTextRange(i), JptJaxbCoreValidationMessages.XML_TYPE__TRANSIENT_PROP, this.getProp(i)));
        }
    }

    protected void validateXmlAnyAttributeMapping(List<IMessage> messages) {
        HashSet<JaxbPersistentAttribute> localAttributes = new HashSet<JaxbPersistentAttribute>();
        HashSet<JaxbPersistentAttribute> allAttributes = new HashSet<JaxbPersistentAttribute>();
        for (JaxbPersistentAttribute jaxbPersistentAttribute : this.getAttributes()) {
            if (jaxbPersistentAttribute.getMappingKey() != "xml-any-attribute") continue;
            localAttributes.add(jaxbPersistentAttribute);
            allAttributes.add(jaxbPersistentAttribute);
        }
        for (JaxbPersistentAttribute jaxbPersistentAttribute : this.getInheritedAttributes()) {
            if (jaxbPersistentAttribute.getMappingKey() != "xml-any-attribute") continue;
            allAttributes.add(jaxbPersistentAttribute);
        }
        if (allAttributes.size() > 1) {
            messages.add(this.buildValidationMessage(this.getValidationTextRange(), JptJaxbCoreValidationMessages.XML_ANY_ATTRIBUTE__MULTIPLE_MAPPINGS_DEFINED));
            for (JaxbPersistentAttribute jaxbPersistentAttribute : localAttributes) {
                messages.add(this.buildValidationMessage((JaxbNode)jaxbPersistentAttribute.getMapping(), jaxbPersistentAttribute.getMapping().getValidationTextRange(), JptJaxbCoreValidationMessages.XML_ANY_ATTRIBUTE__MULTIPLE_MAPPINGS_DEFINED));
            }
        }
    }

    protected void validateXmlAnyElementMapping(List<IMessage> messages) {
        HashSet<JaxbPersistentAttribute> localAttributes = new HashSet<JaxbPersistentAttribute>();
        HashSet<JaxbPersistentAttribute> allAttributes = new HashSet<JaxbPersistentAttribute>();
        for (JaxbPersistentAttribute jaxbPersistentAttribute : this.getAttributes()) {
            if (jaxbPersistentAttribute.getMappingKey() != "xml-any-element") continue;
            localAttributes.add(jaxbPersistentAttribute);
            allAttributes.add(jaxbPersistentAttribute);
        }
        for (JaxbPersistentAttribute jaxbPersistentAttribute : this.getInheritedAttributes()) {
            if (jaxbPersistentAttribute.getMappingKey() != "xml-any-element") continue;
            allAttributes.add(jaxbPersistentAttribute);
        }
        if (allAttributes.size() > 1) {
            messages.add(this.buildValidationMessage(this.getValidationTextRange(), JptJaxbCoreValidationMessages.XML_ANY_ELEMENT__MULTIPLE_MAPPINGS_DEFINED));
            for (JaxbPersistentAttribute jaxbPersistentAttribute : localAttributes) {
                messages.add(this.buildValidationMessage((JaxbNode)jaxbPersistentAttribute.getMapping(), jaxbPersistentAttribute.getMapping().getValidationTextRange(), JptJaxbCoreValidationMessages.XML_ANY_ELEMENT__MULTIPLE_MAPPINGS_DEFINED));
            }
        }
    }

    protected void validateXmlValueMapping(List<IMessage> messages) {
        HashSet<JaxbPersistentAttribute> localAttributes = new HashSet<JaxbPersistentAttribute>();
        HashSet<JaxbPersistentAttribute> allAttributes = new HashSet<JaxbPersistentAttribute>();
        for (JaxbPersistentAttribute jaxbPersistentAttribute : this.getAttributes()) {
            if (jaxbPersistentAttribute.getMappingKey() != "xml-value") continue;
            localAttributes.add(jaxbPersistentAttribute);
            allAttributes.add(jaxbPersistentAttribute);
        }
        for (JaxbPersistentAttribute jaxbPersistentAttribute : this.getInheritedAttributes()) {
            if (jaxbPersistentAttribute.getMappingKey() != "xml-value") continue;
            allAttributes.add(jaxbPersistentAttribute);
        }
        if (allAttributes.size() > 1) {
            messages.add(this.buildValidationMessage(this.getValidationTextRange(), JptJaxbCoreValidationMessages.XML_VALUE__MULTIPLE_MAPPINGS_DEFINED));
            for (JaxbPersistentAttribute jaxbPersistentAttribute : localAttributes) {
                messages.add(this.buildValidationMessage((JaxbNode)jaxbPersistentAttribute.getMapping(), jaxbPersistentAttribute.getMapping().getValidationTextRange(), JptJaxbCoreValidationMessages.XML_VALUE__MULTIPLE_MAPPINGS_DEFINED));
            }
        }
    }

    protected void validateXmlIDs(List<IMessage> messages) {
        HashSet<JaxbPersistentAttribute> localAttributes = new HashSet<JaxbPersistentAttribute>();
        HashSet<JaxbPersistentAttribute> allAttributes = new HashSet<JaxbPersistentAttribute>();
        for (JaxbPersistentAttribute jaxbPersistentAttribute : this.getAttributes()) {
            if (jaxbPersistentAttribute.getMappingKey() != "xml-attribute" && jaxbPersistentAttribute.getMappingKey() != "xml-element" || ((XmlNamedNodeMapping)jaxbPersistentAttribute.getMapping()).getXmlID() == null) continue;
            localAttributes.add(jaxbPersistentAttribute);
            allAttributes.add(jaxbPersistentAttribute);
        }
        for (JaxbPersistentAttribute jaxbPersistentAttribute : this.getInheritedAttributes()) {
            if (jaxbPersistentAttribute.getMappingKey() != "xml-attribute" && jaxbPersistentAttribute.getMappingKey() != "xml-element" || ((XmlNamedNodeMapping)jaxbPersistentAttribute.getMapping()).getXmlID() == null) continue;
            allAttributes.add(jaxbPersistentAttribute);
        }
        if (allAttributes.size() > 1) {
            messages.add(this.buildValidationMessage(this.getValidationTextRange(), JptJaxbCoreValidationMessages.XML_ID__MULTIPLE_MAPPINGS_DEFINED));
            for (JaxbPersistentAttribute jaxbPersistentAttribute : localAttributes) {
                messages.add(this.buildValidationMessage((JaxbNode)jaxbPersistentAttribute.getMapping(), jaxbPersistentAttribute.getMapping().getValidationTextRange(), JptJaxbCoreValidationMessages.XML_ID__MULTIPLE_MAPPINGS_DEFINED));
            }
        }
    }

    protected TextRange getFactoryClassTextRange() {
        TextRange result = this.getXmlTypeAnnotation().getFactoryClassTextRange();
        return result != null ? result : this.getValidationTextRange();
    }

    protected TextRange getFactoryMethodTextRange() {
        TextRange result = this.getXmlTypeAnnotation().getFactoryMethodTextRange();
        return result != null ? result : this.getValidationTextRange();
    }

    protected TextRange getPropOrderTextRange() {
        TextRange result = this.getXmlTypeAnnotation().getPropOrderTextRange();
        return result != null ? result : this.getValidationTextRange();
    }

    protected TextRange getPropTextRange(int index) {
        return this.getXmlTypeAnnotation().getPropTextRange(index);
    }

    protected boolean propTouches(int pos) {
        if (this.getXmlTypeAnnotation().propOrderTouches(pos)) {
            int i = 0;
            while (i < this.getXmlTypeAnnotation().getPropOrderSize()) {
                if (this.getXmlTypeAnnotation().propTouches(i, pos)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class PropOrderContainer
    extends AbstractJaxbNode.ListContainer<String, String> {
        protected PropOrderContainer() {
        }

        @Override
        protected String getContextElementsPropertyName() {
            return "propOrder";
        }

        @Override
        protected String buildContextElement(String resourceElement) {
            return resourceElement;
        }

        @Override
        protected ListIterable<String> getResourceElements() {
            return GenericJavaClassMapping.this.getResourcePropOrder();
        }

        @Override
        protected String getResourceElement(String contextElement) {
            return contextElement;
        }
    }
}

