/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.context.java;

import java.util.List;
import org.eclipse.jpt.common.core.resource.java.Annotation;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.jaxb.core.context.XmlNodeMapping;
import org.eclipse.jpt.jaxb.core.context.XmlSchemaType;
import org.eclipse.jpt.jaxb.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.jaxb.core.internal.context.java.AbstractJavaAdaptableAttributeMapping;
import org.eclipse.jpt.jaxb.core.internal.context.java.GenericJavaAttributeMappingXmlSchemaType;
import org.eclipse.jpt.jaxb.core.resource.java.XmlListAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlSchemaTypeAnnotation;
import org.eclipse.jpt.jaxb.core.validation.JptJaxbCoreValidationMessages;
import org.eclipse.jpt.jaxb.core.xsd.XsdSimpleTypeDefinition;
import org.eclipse.jpt.jaxb.core.xsd.XsdTypeDefinition;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDVariety;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaXmlNodeMapping<A extends Annotation>
extends AbstractJavaAdaptableAttributeMapping<A>
implements XmlNodeMapping {
    protected XmlSchemaType xmlSchemaType;
    protected boolean specifiedXmlList;
    protected boolean defaultXmlList;

    public AbstractJavaXmlNodeMapping(JavaPersistentAttribute parent) {
        super(parent);
        this.initializeXmlSchemaType();
        this.initializeXmlList();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.syncXmlSchemaType();
        this.syncXmlList();
    }

    @Override
    public void update() {
        super.update();
        this.updateXmlSchemaType();
    }

    @Override
    public XmlSchemaType getXmlSchemaType() {
        return this.xmlSchemaType;
    }

    protected void setXmlSchemaType_(XmlSchemaType xmlSchemaType) {
        XmlSchemaType oldXmlSchemaType = this.xmlSchemaType;
        this.xmlSchemaType = xmlSchemaType;
        this.firePropertyChanged("xmlSchemaType", oldXmlSchemaType, xmlSchemaType);
    }

    public boolean hasXmlSchemaType() {
        return this.xmlSchemaType != null;
    }

    @Override
    public XmlSchemaType addXmlSchemaType() {
        if (this.xmlSchemaType != null) {
            throw new IllegalStateException();
        }
        XmlSchemaTypeAnnotation annotation = (XmlSchemaTypeAnnotation)this.getJavaResourceAttribute().addAnnotation(0, "javax.xml.bind.annotation.XmlSchemaType");
        XmlSchemaType xmlJavaTypeAdapter = this.buildXmlSchemaType(annotation);
        this.setXmlSchemaType_(xmlJavaTypeAdapter);
        return xmlJavaTypeAdapter;
    }

    @Override
    public void removeXmlSchemaType() {
        if (this.xmlSchemaType == null) {
            throw new IllegalStateException();
        }
        this.getJavaResourceAttribute().removeAnnotation(0, "javax.xml.bind.annotation.XmlSchemaType");
        this.setXmlSchemaType_(null);
    }

    protected XmlSchemaType buildXmlSchemaType(XmlSchemaTypeAnnotation annotation) {
        return new GenericJavaAttributeMappingXmlSchemaType(this, annotation);
    }

    protected XmlSchemaTypeAnnotation getXmlSchemaTypeAnnotation() {
        if (this.getJavaResourceAttribute().getAnnotationsSize("javax.xml.bind.annotation.XmlSchemaType") > 0) {
            return (XmlSchemaTypeAnnotation)this.getJavaResourceAttribute().getAnnotation(0, "javax.xml.bind.annotation.XmlSchemaType");
        }
        return null;
    }

    protected void initializeXmlSchemaType() {
        XmlSchemaTypeAnnotation annotation = this.getXmlSchemaTypeAnnotation();
        if (annotation != null) {
            this.xmlSchemaType = this.buildXmlSchemaType(annotation);
        }
    }

    protected void updateXmlSchemaType() {
        if (this.xmlSchemaType != null) {
            this.xmlSchemaType.update();
        }
    }

    protected void syncXmlSchemaType() {
        XmlSchemaTypeAnnotation annotation = this.getXmlSchemaTypeAnnotation();
        if (annotation != null) {
            if (this.getXmlSchemaType() != null) {
                this.getXmlSchemaType().synchronizeWithResourceModel();
            } else {
                this.setXmlSchemaType_(this.buildXmlSchemaType(annotation));
            }
        } else {
            this.setXmlSchemaType_(null);
        }
    }

    @Override
    public boolean isXmlList() {
        return this.isSpecifiedXmlList() || this.isDefaultXmlList();
    }

    @Override
    public boolean isSpecifiedXmlList() {
        return this.specifiedXmlList;
    }

    @Override
    public void setSpecifiedXmlList(boolean newValue) {
        if (this.specifiedXmlList == newValue) {
            throw new IllegalStateException();
        }
        if (newValue) {
            this.getJavaResourceAttribute().addAnnotation("javax.xml.bind.annotation.XmlList");
        } else {
            this.getJavaResourceAttribute().removeAnnotation("javax.xml.bind.annotation.XmlList");
        }
        this.setSpecifiedXmlList_(newValue);
    }

    protected void setSpecifiedXmlList_(boolean newValue) {
        boolean oldValue = this.specifiedXmlList;
        this.specifiedXmlList = newValue;
        this.firePropertyChanged("specifiedXmlList", oldValue, newValue);
    }

    @Override
    public boolean isDefaultXmlList() {
        return this.defaultXmlList;
    }

    protected void setDefaultXmlList_(boolean newValue) {
        boolean oldValue = this.defaultXmlList;
        this.defaultXmlList = newValue;
        this.firePropertyChanged("defaultXmlList", oldValue, newValue);
    }

    protected void initializeXmlList() {
        this.specifiedXmlList = this.getXmlListAnnotation() != null;
        this.defaultXmlList = this.calculateDefaultXmlList();
    }

    protected void syncXmlList() {
        this.setSpecifiedXmlList_(this.getXmlListAnnotation() != null);
        this.setDefaultXmlList_(this.calculateDefaultXmlList());
    }

    protected XmlListAnnotation getXmlListAnnotation() {
        return (XmlListAnnotation)this.getJavaResourceAttribute().getAnnotation("javax.xml.bind.annotation.XmlList");
    }

    protected abstract boolean calculateDefaultXmlList();

    @Override
    public XsdTypeDefinition getDataTypeXsdTypeDefinition() {
        if (this.xmlSchemaType != null) {
            return this.xmlSchemaType.getXsdTypeDefinition();
        }
        return super.getDataTypeXsdTypeDefinition();
    }

    @Override
    public Iterable<String> getCompletionProposals(int pos) {
        Iterable<String> result = super.getCompletionProposals(pos);
        if (!IterableTools.isEmpty(result)) {
            return result;
        }
        if (this.xmlSchemaType != null && !IterableTools.isEmpty(result = this.xmlSchemaType.getCompletionProposals(pos))) {
            return result;
        }
        return EmptyIterable.instance();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        if (this.xmlSchemaType != null) {
            this.xmlSchemaType.validate(messages, reporter);
        }
        if (this.isXmlList()) {
            this.validateXmlList(messages, reporter);
        }
    }

    protected void validateXmlList(List<IMessage> messages, IReporter reporter) {
        if (!this.getPersistentAttribute().isJavaResourceAttributeCollectionType()) {
            messages.add(this.buildValidationMessage(this.getXmlListValidationTextRange(), JptJaxbCoreValidationMessages.XML_LIST__ATTRIBUTE_NOT_COLLECTION_TYPE));
        } else {
            XsdTypeDefinition xsdType = this.getDataTypeXsdTypeDefinition();
            if (xsdType != null && (xsdType.getKind() != XsdTypeDefinition.Kind.SIMPLE || ((XSDSimpleTypeDefinition)((XsdSimpleTypeDefinition)xsdType).getXSDComponent()).getVariety() == XSDVariety.LIST_LITERAL)) {
                messages.add(this.buildValidationMessage(this.getValidationTextRange(), JptJaxbCoreValidationMessages.XML_LIST__ITEM_TYPE_NOT_MAPPED_TO_VALID_SCHEMA_TYPE, this.getValueTypeName()));
            }
        }
    }

    protected TextRange getXmlListValidationTextRange() {
        XmlListAnnotation annotation = this.getXmlListAnnotation();
        return annotation == null ? this.getValidationTextRange() : annotation.getTextRange();
    }
}

