/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.wizard.fragment;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IModuleType;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.internal.ServerWorkingCopy;
import org.eclipse.wst.server.core.util.SocketUtil;
import org.eclipse.wst.server.ui.internal.ServerUIPlugin;
import org.eclipse.wst.server.ui.internal.wizard.page.NewManualServerComposite;
import org.eclipse.wst.server.ui.internal.wizard.page.NewServerComposite;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;
import org.eclipse.wst.server.ui.wizard.WizardFragment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewServerWizardFragment
extends WizardFragment {
    public static final byte MODE_EXISTING = 0;
    public static final byte MODE_DETECT = 1;
    public static final byte MODE_MANUAL = 2;
    protected IModule module;
    protected IModuleType moduleType;
    protected String serverTypeId;
    protected NewServerComposite comp;
    protected Map<String, WizardFragment> fragmentMap = new HashMap<String, WizardFragment>();
    protected IPath runtimeLocation = null;

    public NewServerWizardFragment() {
    }

    public NewServerWizardFragment(IModuleType moduleType, String serverTypeId) {
        this.moduleType = moduleType;
        this.serverTypeId = serverTypeId;
    }

    public NewServerWizardFragment(IModule module) {
        this.module = module;
    }

    @Override
    public boolean hasComposite() {
        return true;
    }

    @Override
    public void enter() {
        super.enter();
    }

    @Override
    public Composite createComposite(Composite parent, IWizardHandle wizard) {
        String launchMode = (String)this.getTaskModel().getObject("launch-mode");
        this.comp = this.moduleType != null || this.serverTypeId != null ? new NewServerComposite(parent, wizard, this.moduleType, this.serverTypeId, launchMode) : new NewServerComposite(parent, wizard, this.module, launchMode);
        if (this.getTaskModel() != null) {
            this.comp.setTaskModel(this.getTaskModel());
        }
        return this.comp;
    }

    protected WizardFragment getWizardFragment(String typeId) {
        WizardFragment fragment;
        try {
            fragment = this.fragmentMap.get(typeId);
            if (fragment != null) {
                return fragment;
            }
        }
        catch (Exception exception) {}
        fragment = ServerUIPlugin.getWizardFragment(typeId);
        if (fragment != null) {
            this.fragmentMap.put(typeId, fragment);
        }
        return fragment;
    }

    @Override
    public List getChildFragments() {
        ArrayList<WizardFragment> listImpl = new ArrayList<WizardFragment>();
        this.createChildFragments(listImpl);
        return listImpl;
    }

    @Override
    protected void createChildFragments(List<WizardFragment> list) {
        if (this.getTaskModel() == null) {
            return;
        }
        Byte b = this.getMode();
        if (b != null && b == 2) {
            IServerAttributes server;
            WizardFragment sub;
            IRuntime runtime = (IRuntime)this.getTaskModel().getObject("runtime");
            if (runtime != null && runtime instanceof IRuntimeWorkingCopy && (sub = this.getWizardFragment(runtime.getRuntimeType().getId())) != null) {
                list.add(sub);
            }
            if ((server = (IServerAttributes)this.getTaskModel().getObject("server")) != null) {
                WizardFragment sub2;
                if (server.getServerType().hasServerConfiguration() && server instanceof ServerWorkingCopy) {
                    ServerWorkingCopy swc = (ServerWorkingCopy)server;
                    if (runtime != null && runtime.getLocation() != null && !runtime.getLocation().isEmpty()) {
                        if (this.runtimeLocation == null || !this.runtimeLocation.equals((Object)runtime.getLocation())) {
                            try {
                                swc.importRuntimeConfiguration(runtime, null);
                            }
                            catch (CoreException coreException) {}
                        }
                        this.runtimeLocation = runtime.getLocation();
                    } else {
                        this.runtimeLocation = null;
                    }
                }
                if ((sub2 = this.getWizardFragment(server.getServerType().getId())) != null) {
                    list.add(sub2);
                }
            }
        } else if (b != null) {
            b.byteValue();
        }
    }

    @Override
    public boolean isComplete() {
        if (this.getMode() != null && this.getMode() != 2) {
            return true;
        }
        if (this.getServer() == null) {
            return false;
        }
        if (this.getServer().getServerType() == null) {
            return false;
        }
        return this.checkValidInput();
    }

    private boolean checkValidInput() {
        NewManualServerComposite composite;
        boolean isComplete = false;
        if (this.comp != null && (composite = this.comp.getNewManualServerComposite()) != null && composite instanceof NewManualServerComposite) {
            NewManualServerComposite manualComp = composite;
            if (manualComp.isTimerRunning() || manualComp.isTimerScheduled()) {
                return false;
            }
            if (manualComp.isServerNameInUse()) {
                return false;
            }
            boolean supportsRemote = this.getServer().getServerType().supportsRemoteHosts();
            isComplete = manualComp.getCurrentHostname().trim().length() == 0 ? false : (!supportsRemote && !SocketUtil.isLocalhost((String)manualComp.getCurrentHostname()) ? false : manualComp.canSupportModule());
        }
        return isComplete;
    }

    private IServerWorkingCopy getServer() {
        try {
            return (IServerWorkingCopy)this.getTaskModel().getObject("server");
        }
        catch (Exception exception) {
            return null;
        }
    }

    private Byte getMode() {
        try {
            return (Byte)this.getTaskModel().getObject("mode");
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public void performCancel(IProgressMonitor monitor) throws CoreException {
        if (this.comp != null) {
            this.comp.getNewManualServerComposite().dispose();
        }
        super.performCancel(monitor);
    }

    @Override
    public void performFinish(IProgressMonitor monitor) throws CoreException {
        if (this.comp != null) {
            this.comp.getNewManualServerComposite().dispose();
        }
        super.performFinish(monitor);
    }
}

