/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.types;

import org.eclipse.wst.xml.xpath2.api.DynamicContext;
import org.eclipse.wst.xml.xpath2.api.ResultBuffer;
import org.eclipse.wst.xml.xpath2.api.ResultSequence;
import org.eclipse.wst.xml.xpath2.api.typesystem.TypeDefinition;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.internal.function.CmpEq;
import org.eclipse.wst.xml.xpath2.processor.internal.function.CmpGt;
import org.eclipse.wst.xml.xpath2.processor.internal.function.CmpLt;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyAtomicType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.CalendarType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.CtrType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.NumericType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSAnyURI;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSBase64Binary;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSBoolean;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSHexBinary;
import org.eclipse.wst.xml.xpath2.processor.internal.types.builtin.BuiltinTypeLibrary;

public class XSDuration
extends CtrType
implements CmpEq,
CmpLt,
CmpGt,
Cloneable {
    private static final String XS_DURATION = "xs:duration";
    protected int _year;
    protected int _month;
    protected int _days;
    protected int _hours;
    protected int _minutes;
    protected double _seconds;
    protected boolean _negative;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public XSDuration(int years, int months, int days, int hours, int minutes, double seconds, boolean negative) {
        this._year = years;
        this._month = months;
        this._days = days;
        this._hours = hours;
        this._minutes = minutes;
        this._seconds = seconds;
        this._negative = negative;
        if (this._month >= 12) {
            this._year += this._month / 12;
            this._month %= 12;
        }
        if (this._seconds >= 60.0) {
            int isec = (int)this._seconds;
            double rem = this._seconds - (double)isec;
            this._minutes += isec / 60;
            this._seconds = isec % 60;
            this._seconds += rem;
        }
        if (this._minutes >= 60) {
            this._hours += this._minutes / 60;
            this._minutes %= 60;
        }
        if (this._hours >= 24) {
            this._days += this._hours / 24;
            this._hours %= 24;
        }
    }

    public XSDuration(double secs) {
        this(0, 0, 0, 0, 0, Math.abs(secs), secs < 0.0);
    }

    public XSDuration() {
        this(0, 0, 0, 0, 0, 0.0, false);
    }

    public String type_name() {
        return "duration";
    }

    public String string_type() {
        return XS_DURATION;
    }

    public String getStringValue() {
        int months;
        String ret = "";
        boolean did_something = false;
        String tret = "";
        if (this.negative() && (this.days() != 0 || this.hours() != 0 || this.seconds() != 0.0)) {
            ret = String.valueOf(ret) + "-";
        }
        ret = String.valueOf(ret) + "P";
        int years = this.year();
        if (years != 0) {
            ret = String.valueOf(ret) + years + "Y";
        }
        if ((months = this.month()) != 0) {
            ret = String.valueOf(ret) + months + "M";
        }
        if (this.days() != 0) {
            ret = String.valueOf(ret) + this.days() + "D";
            did_something = true;
        }
        int hours = this.hours();
        int minutes = this.minutes();
        double seconds = this.seconds();
        if (hours != 0) {
            tret = String.valueOf(tret) + hours + "H";
            did_something = true;
        }
        if (minutes != 0) {
            tret = String.valueOf(tret) + minutes + "M";
            did_something = true;
        }
        if (seconds != 0.0) {
            String doubStr = new Double(seconds).toString();
            tret = doubStr.endsWith(".0") ? String.valueOf(tret) + doubStr.substring(0, doubStr.indexOf(".0")) + "S" : String.valueOf(tret) + seconds + "S";
            did_something = true;
        } else if (!did_something) {
            tret = String.valueOf(tret) + "0S";
        }
        if ((this.year() == 0 && this.month() == 0 || hours > 0 || minutes > 0 || seconds > 0.0) && tret.length() > 0) {
            ret = String.valueOf(ret) + "T" + tret;
        }
        return ret;
    }

    public int days() {
        return this._days;
    }

    public int minutes() {
        return this._minutes;
    }

    public int hours() {
        return this._hours;
    }

    public double seconds() {
        return this._seconds;
    }

    public boolean eq(AnyType arg, DynamicContext dynamicContext) throws DynamicError {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.xml.xpath2.processor.internal.types.XSDuration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        XSDuration val = (XSDuration)NumericType.get_single_type(arg, (Class)clazz);
        return this.value() == val.value();
    }

    public boolean lt(AnyType arg, DynamicContext context) throws DynamicError {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.wst.xml.xpath2.processor.internal.types.XSDayTimeDuration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        XSDuration val = (XSDuration)NumericType.get_single_type(arg, (Class)clazz);
        return this.value() < val.value();
    }

    public boolean gt(AnyType arg, DynamicContext context) throws DynamicError {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.wst.xml.xpath2.processor.internal.types.XSDayTimeDuration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        XSDuration val = (XSDuration)NumericType.get_single_type(arg, (Class)clazz);
        return this.value() > val.value();
    }

    public boolean negative() {
        return this._negative;
    }

    public double value() {
        double ret = this.days() * 24 * 60 * 60;
        ret += (double)(this.hours() * 60 * 60);
        ret += (double)(this.minutes() * 60);
        ret += this.seconds();
        if (this.negative()) {
            ret *= -1.0;
        }
        return ret;
    }

    public double time_value() {
        double ret = 0.0;
        ret += (double)(this.hours() * 60 * 60);
        ret += (double)(this.minutes() * 60);
        ret += this.seconds();
        if (this.negative()) {
            ret *= -1.0;
        }
        return ret;
    }

    public ResultSequence constructor(ResultSequence arg) throws DynamicError {
        if (arg.empty()) {
            return ResultBuffer.EMPTY;
        }
        AnyAtomicType aat = (AnyAtomicType)arg.first();
        if (aat instanceof NumericType || aat instanceof CalendarType || aat instanceof XSBoolean || aat instanceof XSBase64Binary || aat instanceof XSHexBinary || aat instanceof XSAnyURI) {
            throw DynamicError.invalidType();
        }
        if (!this.isCastable(aat)) {
            throw DynamicError.cant_cast(null);
        }
        XSDuration duration = this.castDuration(aat);
        if (duration == null) {
            throw DynamicError.cant_cast(null);
        }
        return duration;
    }

    private XSDuration castDuration(AnyAtomicType aat) {
        if (aat instanceof XSDuration) {
            XSDuration duration = (XSDuration)aat;
            return new XSDuration(duration.year(), duration.month(), duration.days(), duration.hours(), duration.minutes(), duration.seconds(), duration.negative());
        }
        return XSDuration.parseDTDuration(aat.getStringValue());
    }

    public static XSDuration parseDTDuration(String str) {
        boolean negative = false;
        int years = 0;
        int months = 0;
        int days = 0;
        int hours = 0;
        int minutes = 0;
        double seconds = 0.0;
        String pstr = "";
        String tstr = "";
        if (str.startsWith("-P")) {
            negative = true;
            pstr = str.substring(2, str.length());
        } else if (str.startsWith("P")) {
            negative = false;
            pstr = str.substring(1, str.length());
        } else {
            return null;
        }
        try {
            String digit;
            int index = pstr.indexOf(89);
            boolean did_something = false;
            if (index != -1) {
                digit = pstr.substring(0, index);
                years = Integer.parseInt(digit);
                pstr = pstr.substring(index + 1, pstr.length());
                did_something = true;
            }
            if ((index = pstr.indexOf(77)) != -1) {
                digit = pstr.substring(0, index);
                months = Integer.parseInt(digit);
                pstr = pstr.substring(index + 1, pstr.length());
                did_something = true;
            }
            if ((index = pstr.indexOf(68)) == -1) {
                if (pstr.startsWith("T")) {
                    tstr = pstr.substring(1, pstr.length());
                }
            } else {
                digit = pstr.substring(0, index);
                days = Integer.parseInt(digit);
                tstr = pstr.substring(index + 1, pstr.length());
                if (tstr.startsWith("T")) {
                    tstr = tstr.substring(1, tstr.length());
                } else {
                    tstr = "";
                    did_something = true;
                }
            }
            if ((index = tstr.indexOf(72)) != -1) {
                digit = tstr.substring(0, index);
                hours = Integer.parseInt(digit);
                tstr = tstr.substring(index + 1, tstr.length());
                did_something = true;
            }
            if ((index = tstr.indexOf(77)) != -1) {
                digit = tstr.substring(0, index);
                minutes = Integer.parseInt(digit);
                tstr = tstr.substring(index + 1, tstr.length());
                did_something = true;
            }
            if ((index = tstr.indexOf(83)) != -1) {
                digit = tstr.substring(0, index);
                seconds = Double.parseDouble(digit);
                tstr = tstr.substring(index + 1, tstr.length());
                did_something = true;
            }
            if (!did_something) {
                return null;
            }
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        return new XSDuration(years, months, days, hours, minutes, seconds, negative);
    }

    public Object clone() throws CloneNotSupportedException {
        return new XSDuration(this.year(), this.month(), this.days(), this.hours(), this.minutes(), this.seconds(), this.negative());
    }

    public int year() {
        return this._year;
    }

    public int month() {
        return this._month;
    }

    protected boolean isCastable(AnyAtomicType aat) {
        String value = aat.getStringValue();
        String type = aat.string_type();
        if ((type.equals("xs:string") || type.equals("xs:untypedAtomic")) && this.isDurationValue(value)) {
            return true;
        }
        return aat instanceof XSDuration;
    }

    private boolean isDurationValue(String value) {
        return value.startsWith("P") || value.startsWith("-P");
    }

    public TypeDefinition getTypeDefinition() {
        return BuiltinTypeLibrary.XS_DURATION;
    }

    public Object getNativeValue() {
        return _datatypeFactory.newDuration(!this.negative(), this.year(), this.month(), this.days(), this.hours(), this.minutes(), (int)this.seconds());
    }
}

