/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.function;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.wst.xml.xpath2.api.EvaluationContext;
import org.eclipse.wst.xml.xpath2.api.ResultBuffer;
import org.eclipse.wst.xml.xpath2.api.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.internal.SeqType;
import org.eclipse.wst.xml.xpath2.processor.internal.TypeError;
import org.eclipse.wst.xml.xpath2.processor.internal.function.Function;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AttrType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.ElementType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.NodeType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.QName;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSIDREF;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSString;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FnID
extends Function {
    private static Collection _expected_args = null;

    public FnID() {
        super(new QName("id"), 1, 2);
    }

    public ResultSequence evaluate(Collection args, EvaluationContext ec) throws DynamicError {
        return FnID.id(args, ec);
    }

    public static ResultSequence id(Collection args, EvaluationContext context) throws DynamicError {
        Collection cargs = Function.convert_arguments(args, FnID.expected_args());
        ResultBuffer rs = new ResultBuffer();
        Iterator argIt = cargs.iterator();
        ResultSequence idrefRS = (ResultSequence)argIt.next();
        String[] idrefst = idrefRS.first().getStringValue().split(" ");
        ArrayList idrefs = FnID.createIDRefs(idrefst);
        ResultSequence nodeArg = null;
        NodeType nodeType = null;
        if (argIt.hasNext()) {
            nodeArg = (ResultSequence)argIt.next();
            nodeType = (NodeType)nodeArg.first();
        } else {
            if (context.getContextItem() == null) {
                throw DynamicError.contextUndefined();
            }
            if (!(context.getContextItem() instanceof NodeType)) {
                throw new DynamicError(TypeError.invalid_type(null));
            }
            nodeType = (NodeType)context.getContextItem();
            if (nodeType.node_value().getOwnerDocument() == null) {
                throw DynamicError.contextUndefined();
            }
        }
        Node node = nodeType.node_value();
        if (node.getOwnerDocument() == null) {
            throw DynamicError.contextUndefined();
        }
        if (FnID.hasIDREF(idrefs, node)) {
            ElementType element = new ElementType((Element)node, context.getStaticContext().getTypeModel());
            rs.add(element);
        }
        FnID.processAttributes(node, idrefs, rs, context);
        FnID.processChildNodes(node, idrefs, rs, context);
        return rs.getSequence();
    }

    private static ArrayList createIDRefs(String[] idReftokens) {
        ArrayList<XSIDREF> xsidRef = new ArrayList<XSIDREF>();
        int i = 0;
        while (i < idReftokens.length) {
            XSIDREF idref = new XSIDREF(idReftokens[i]);
            xsidRef.add(idref);
            ++i;
        }
        return xsidRef;
    }

    private static void processChildNodes(Node node, List idrefs, ResultBuffer rs, EvaluationContext context) {
        if (!node.hasChildNodes()) {
            return;
        }
        NodeList nodeList = node.getChildNodes();
        int nodecnt = 0;
        while (nodecnt < nodeList.getLength()) {
            Node childNode = nodeList.item(nodecnt);
            if (childNode.getNodeType() == 1 && !FnID.isDuplicate(childNode, rs)) {
                ElementType element = new ElementType((Element)childNode, context.getStaticContext().getTypeModel());
                if (element.isID() && FnID.hasIDREF(idrefs, childNode)) {
                    rs.add(element);
                }
                FnID.processAttributes(childNode, idrefs, rs, context);
                FnID.processChildNodes(childNode, idrefs, rs, context);
            }
            ++nodecnt;
        }
    }

    private static void processAttributes(Node node, List idrefs, ResultBuffer rs, EvaluationContext context) {
        if (!node.hasAttributes()) {
            return;
        }
        NamedNodeMap attributeList = node.getAttributes();
        int atsub = 0;
        while (atsub < attributeList.getLength()) {
            Attr atNode = (Attr)attributeList.item(atsub);
            AttrType atType = new AttrType(atNode, context.getStaticContext().getTypeModel());
            if (((NodeType)atType).isID() && FnID.hasIDREF(idrefs, atNode) && !FnID.isDuplicate(node, rs)) {
                ElementType element = new ElementType((Element)node, context.getStaticContext().getTypeModel());
                rs.add(element);
            }
            ++atsub;
        }
    }

    private static boolean hasIDREF(List idrefs, Node node) {
        int i = 0;
        while (i < idrefs.size()) {
            XSIDREF idref = (XSIDREF)idrefs.get(i);
            if (idref.getStringValue().equals(node.getNodeValue())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean isDuplicate(Node node, ResultBuffer rs) {
        ListIterator it = rs.iterator();
        while (it.hasNext()) {
            if (!it.next().equals(node)) continue;
            return true;
        }
        return false;
    }

    public static synchronized Collection expected_args() {
        if (_expected_args == null) {
            _expected_args = new ArrayList();
            SeqType arg = new SeqType(new XSString(), 1);
            _expected_args.add(arg);
            _expected_args.add(new SeqType(0));
        }
        return _expected_args;
    }
}

