/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.utility.command;

import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jpt.common.core.internal.utility.command.CommandJobCommandAdapter;
import org.eclipse.jpt.common.core.internal.utility.command.JobCommandJob;
import org.eclipse.jpt.common.core.utility.command.CombinedExtendedCommandContext;
import org.eclipse.jpt.common.core.utility.command.JobCommand;
import org.eclipse.jpt.common.utility.command.Command;
import org.eclipse.jpt.common.utility.internal.ClassTools;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.reference.SynchronizedBoolean;

public class SimpleJobCommandContext
implements CombinedExtendedCommandContext {
    private final String defaultJobName;
    private final ISchedulingRule defaultJobSchedulingRule;

    public SimpleJobCommandContext() {
        this(null);
    }

    public SimpleJobCommandContext(String defaultJobName) {
        this(defaultJobName, null);
    }

    public SimpleJobCommandContext(String defaultJobName, ISchedulingRule defaultJobSchedulingRule) {
        this.defaultJobName = defaultJobName;
        this.defaultJobSchedulingRule = defaultJobSchedulingRule;
    }

    public void execute(Command command) {
        this.execute(new CommandJobCommandAdapter(command));
    }

    public void waitToExecute(Command command) throws InterruptedException {
        this.waitToExecute(new CommandJobCommandAdapter(command));
    }

    public boolean waitToExecute(Command command, long timeout) throws InterruptedException {
        return this.waitToExecute((JobCommand)new CommandJobCommandAdapter(command), timeout);
    }

    public void execute(JobCommand command) {
        this.execute(command, null);
    }

    public void execute(JobCommand command, String jobName) {
        this.execute(command, jobName, this.defaultJobSchedulingRule);
    }

    public void execute(JobCommand command, String jobName, ISchedulingRule rule) {
        this.execute_(command, this.buildJobName(jobName, command), rule);
    }

    private void execute_(JobCommand command, String jobName, ISchedulingRule rule) {
        JobCommandJob job = new JobCommandJob(jobName, command);
        job.setRule(rule);
        job.schedule();
    }

    public void waitToExecute(JobCommand command) throws InterruptedException {
        this.waitToExecute(command, null);
    }

    public boolean waitToExecute(JobCommand command, long timeout) throws InterruptedException {
        return this.waitToExecute(command, null, timeout);
    }

    public void waitToExecute(JobCommand command, String jobName) throws InterruptedException {
        this.waitToExecute(command, jobName, this.defaultJobSchedulingRule);
    }

    public boolean waitToExecute(JobCommand command, String jobName, long timeout) throws InterruptedException {
        return this.waitToExecute(command, jobName, this.defaultJobSchedulingRule, timeout);
    }

    public void waitToExecute(JobCommand command, String jobName, ISchedulingRule rule) throws InterruptedException {
        this.waitToExecute_(command, this.buildJobName(jobName, command), rule, 0L);
    }

    public boolean waitToExecute(JobCommand command, String jobName, ISchedulingRule rule, long timeout) throws InterruptedException {
        return this.waitToExecute_(command, this.buildJobName(jobName, command), rule, timeout);
    }

    private boolean waitToExecute_(JobCommand command, String jobName, ISchedulingRule rule, long timeout) throws InterruptedException {
        if (timeout == 0L && Job.getJobManager().isSuspended()) {
            return false;
        }
        JobCommandJob job = new JobCommandJob(jobName, command);
        JobChangeListener listener = new JobChangeListener();
        job.addJobChangeListener((IJobChangeListener)listener);
        job.setRule(rule);
        job.schedule();
        try {
            boolean bl = listener.waitUntilDone(timeout);
            return bl;
        }
        finally {
            job.removeJobChangeListener((IJobChangeListener)listener);
        }
    }

    private String buildJobName(String jobName, Object command) {
        if (jobName != null) {
            return jobName;
        }
        if (this.defaultJobName != null) {
            return this.defaultJobName;
        }
        return ClassTools.toStringName(command.getClass());
    }

    public String toString() {
        return ObjectTools.toString((Object)this);
    }

    class JobChangeListener
    extends JobChangeAdapter {
        private final SynchronizedBoolean done = new SynchronizedBoolean(false);

        JobChangeListener() {
        }

        public void done(IJobChangeEvent event) {
            super.done(event);
            this.done.setTrue();
        }

        boolean waitUntilDone(long timeout) throws InterruptedException {
            return this.done.waitUntilTrue(timeout);
        }
    }
}

