/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.resource.java.binary;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jpt.common.core.internal.plugin.JptCommonCorePlugin;
import org.eclipse.jpt.common.core.internal.resource.java.AttributeKey;
import org.eclipse.jpt.common.core.internal.resource.java.binary.BinaryAbstractType;
import org.eclipse.jpt.common.core.internal.resource.java.binary.BinaryField;
import org.eclipse.jpt.common.core.internal.resource.java.binary.BinaryMethod;
import org.eclipse.jpt.common.core.internal.utility.jdt.JavaResourceTypeBinding;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAttribute;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceMethod;
import org.eclipse.jpt.common.core.resource.java.JavaResourceModel;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.utility.jdt.TypeBinding;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.collection.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerAdapter;
import org.eclipse.jpt.common.utility.transformer.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class BinaryType
extends BinaryAbstractType
implements JavaResourceType {
    private String superclassQualifiedName;
    private boolean abstract_;
    private boolean hasNoArgConstructor;
    private boolean hasPrivateNoArgConstructor;
    private final Vector<JavaResourceField> fields = new Vector();
    private final Vector<JavaResourceMethod> methods = new Vector();
    private final Hashtable<AttributeKey, JavaResourceTypeBinding> inheritedFieldTypes = new Hashtable();
    private final Hashtable<AttributeKey, JavaResourceTypeBinding> inheritedMethodTypes = new Hashtable();
    private static final IField[] EMPTY_FIELD_ARRAY = new IField[0];
    private static final IMethod[] EMPTY_METHOD_ARRAY = new IMethod[0];

    BinaryType(JavaResourceModel parent, IType type) {
        this(parent, new BinaryAbstractType.TypeAdapter(type));
    }

    private BinaryType(JavaResourceModel parent, BinaryAbstractType.TypeAdapter adapter) {
        super(parent, adapter);
        this.superclassQualifiedName = this.buildSuperclassQualifiedName();
        this.abstract_ = this.buildAbstract();
        this.hasNoArgConstructor = this.buildHasNoArgConstructor();
        this.hasPrivateNoArgConstructor = this.buildHasPrivateNoArgConstructor();
        CollectionTools.addAll(this.fields, this.buildFields());
        CollectionTools.addAll(this.methods, this.buildMethods());
        this.inheritedFieldTypes.putAll(this.buildInheritedFieldTypes(adapter.getTypeBinding()));
        this.inheritedMethodTypes.putAll(this.buildInheritedMethodTypes(adapter.getTypeBinding()));
    }

    @Override
    public JavaResourceAnnotatedElement.AstNodeType getAstNodeType() {
        return JavaResourceAnnotatedElement.AstNodeType.TYPE;
    }

    @Override
    public void update() {
        super.update();
        this.updateSuperclassQualifiedName();
        this.updateAbstract();
        this.updateHasNoArgConstructor();
        this.updateHasPrivateNoArgConstructor();
        this.updateFields();
        this.updateMethods();
        this.updateInheritedFieldTypes();
        this.updateInheritedMethodTypes();
    }

    @Override
    public void synchronizeWith(TypeDeclaration typeDeclaration) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void resolveTypes(TypeDeclaration typeDeclaration) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getSuperclassQualifiedName() {
        return this.superclassQualifiedName;
    }

    private String buildSuperclassQualifiedName() {
        return BinaryType.convertTypeSignatureToTypeName(this.getSuperclassTypeSignature(this.getElement()));
    }

    private String getSuperclassTypeSignature(IType type) {
        try {
            return type.getSuperclassTypeSignature();
        }
        catch (JavaModelException ex) {
            JptCommonCorePlugin.instance().logError(ex);
            return null;
        }
    }

    protected void updateSuperclassQualifiedName() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isAbstract() {
        return this.abstract_;
    }

    private boolean buildAbstract() {
        try {
            return Flags.isAbstract((int)this.getElement().getFlags());
        }
        catch (JavaModelException ex) {
            JptCommonCorePlugin.instance().logError(ex);
            return false;
        }
    }

    protected void updateAbstract() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasNoArgConstructor() {
        return this.hasNoArgConstructor;
    }

    private boolean buildHasNoArgConstructor() {
        return this.findNoArgConstructor(this.getElement()) != null;
    }

    private IMethod findNoArgConstructor(IType type) {
        try {
            IMethod[] iMethodArray = type.getMethods();
            int n = iMethodArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMethod method = iMethodArray[n2];
                if (method.isConstructor()) {
                    return method;
                }
                ++n2;
            }
        }
        catch (JavaModelException ex) {
            JptCommonCorePlugin.instance().logError(ex);
        }
        return null;
    }

    protected void updateHasNoArgConstructor() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasPrivateNoArgConstructor() {
        return this.hasPrivateNoArgConstructor;
    }

    private boolean buildHasPrivateNoArgConstructor() {
        IMethod method = this.findNoArgConstructor(this.getElement());
        try {
            return method != null && Flags.isPrivate((int)method.getFlags());
        }
        catch (JavaModelException ex) {
            JptCommonCorePlugin.instance().logError(ex);
            return false;
        }
    }

    protected void updateHasPrivateNoArgConstructor() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasPublicOrProtectedNoArgConstructor() {
        Iterable<JavaResourceMethod> constructors = this.getConstructors();
        if (IterableTools.size(constructors) == 0) {
            return true;
        }
        for (JavaResourceMethod constructor : constructors) {
            if (constructor.getParametersSize() != 0) continue;
            return Modifier.isPublic((int)constructor.getModifiers()) || Modifier.isProtected((int)constructor.getModifiers());
        }
        return false;
    }

    @Override
    public boolean hasPublicNoArgConstructor() {
        Iterable<JavaResourceMethod> constructors = this.getConstructors();
        if (IterableTools.size(constructors) == 0) {
            return true;
        }
        for (JavaResourceMethod constructor : constructors) {
            if (constructor.getParametersSize() != 0) continue;
            return Modifier.isPublic((int)constructor.getModifiers());
        }
        return false;
    }

    protected Iterable<JavaResourceMethod> getConstructors() {
        return IterableTools.filter(this.getMethods(), JavaResourceMethod.IS_CONSTRUCTOR);
    }

    @Override
    public Iterable<JavaResourceField> getFields() {
        return IterableTools.cloneLive(this.fields);
    }

    private Iterable<JavaResourceField> buildFields() {
        return IterableTools.transform((Iterable)IterableTools.iterable((Object[])this.getFields(this.getElement())), (Transformer)new FieldTransformer());
    }

    private IField[] getFields(IType type) {
        try {
            return type.getFields();
        }
        catch (JavaModelException ex) {
            JptCommonCorePlugin.instance().logError(ex);
            return EMPTY_FIELD_ARRAY;
        }
    }

    JavaResourceField buildField(IField jdtField) {
        return new BinaryField((JavaResourceType)this, jdtField);
    }

    protected void updateFields() {
        throw new UnsupportedOperationException();
    }

    @Override
    public JavaResourceField getField(String name) {
        for (JavaResourceField field : this.getFields()) {
            if (!ObjectTools.equals((Object)field.getName(), (Object)name)) continue;
            return field;
        }
        return null;
    }

    @Override
    public Iterable<JavaResourceMethod> getMethods() {
        return IterableTools.cloneLive(this.methods);
    }

    private Iterable<JavaResourceMethod> buildMethods() {
        return IterableTools.transform((Iterable)IterableTools.iterable((Object[])this.getMethods(this.getElement())), (Transformer)new MethodTransformer());
    }

    private IMethod[] getMethods(IType type) {
        try {
            return type.getMethods();
        }
        catch (JavaModelException ex) {
            JptCommonCorePlugin.instance().logError(ex);
            return EMPTY_METHOD_ARRAY;
        }
    }

    JavaResourceMethod buildMethod(IMethod jdtMethod) {
        return new BinaryMethod((JavaResourceType)this, jdtMethod);
    }

    protected void updateMethods() {
        throw new UnsupportedOperationException();
    }

    @Override
    public JavaResourceMethod getMethod(String propertyName) {
        for (JavaResourceMethod method : this.getMethods()) {
            if (!ObjectTools.equals((Object)method.getMethodName(), (Object)propertyName)) continue;
            return method;
        }
        return null;
    }

    private Map<AttributeKey, JavaResourceTypeBinding> buildInheritedFieldTypes(ITypeBinding typeBinding) {
        HashMap<AttributeKey, JavaResourceTypeBinding> fieldTypes = new HashMap<AttributeKey, JavaResourceTypeBinding>();
        ITypeBinding scTypeBinding = typeBinding.getSuperclass();
        while (scTypeBinding != null && scTypeBinding.isParameterizedType()) {
            this.buildInheritedFieldTypes_(fieldTypes, scTypeBinding);
            scTypeBinding = scTypeBinding.getSuperclass();
        }
        return fieldTypes;
    }

    private void buildInheritedFieldTypes_(Map<AttributeKey, JavaResourceTypeBinding> fieldTypes, ITypeBinding typeBinding) {
        IVariableBinding[] typeBindingFields;
        String typeName = typeBinding.getTypeDeclaration().getQualifiedName();
        IVariableBinding[] iVariableBindingArray = typeBindingFields = typeBinding.getDeclaredFields();
        int n = typeBindingFields.length;
        int n2 = 0;
        while (n2 < n) {
            IVariableBinding field = iVariableBindingArray[n2];
            String fieldName = field.getName();
            fieldTypes.put(new AttributeKey(typeName, fieldName), new JavaResourceTypeBinding(field.getType()));
            ++n2;
        }
    }

    protected void updateInheritedFieldTypes() {
        throw new UnsupportedOperationException();
    }

    private Map<AttributeKey, JavaResourceTypeBinding> buildInheritedMethodTypes(ITypeBinding typeBinding) {
        HashMap<AttributeKey, JavaResourceTypeBinding> methodTypes = new HashMap<AttributeKey, JavaResourceTypeBinding>();
        ITypeBinding scTypeBinding = typeBinding.getSuperclass();
        while (scTypeBinding != null && scTypeBinding.isParameterizedType()) {
            this.buildInheritedMethodTypes_(methodTypes, scTypeBinding);
            scTypeBinding = scTypeBinding.getSuperclass();
        }
        return methodTypes;
    }

    private void buildInheritedMethodTypes_(Map<AttributeKey, JavaResourceTypeBinding> methodTypes, ITypeBinding typeBinding) {
        IMethodBinding[] typeBindingMethods;
        String typeName = typeBinding.getTypeDeclaration().getQualifiedName();
        IMethodBinding[] iMethodBindingArray = typeBindingMethods = typeBinding.getDeclaredMethods();
        int n = typeBindingMethods.length;
        int n2 = 0;
        while (n2 < n) {
            IMethodBinding method = iMethodBindingArray[n2];
            String methodName = method.getName();
            methodTypes.put(new AttributeKey(typeName, methodName), new JavaResourceTypeBinding(method.getReturnType()));
            ++n2;
        }
    }

    protected void updateInheritedMethodTypes() {
        throw new UnsupportedOperationException();
    }

    @Override
    public TypeBinding getAttributeTypeBinding(JavaResourceAttribute attribute) {
        if (attribute.getParent() == this) {
            return attribute.getTypeBinding();
        }
        AttributeKey key = new AttributeKey(attribute.getParent().getTypeBinding().getQualifiedName(), attribute.getName());
        if (attribute.getAstNodeType() == JavaResourceAnnotatedElement.AstNodeType.FIELD) {
            return this.inheritedFieldTypes.get(key);
        }
        return this.inheritedMethodTypes.get(key);
    }

    @Override
    public boolean hasAnyAnnotatedFields() {
        for (JavaResourceField field : this.getFields()) {
            if (!field.isAnnotated()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasAnyAnnotatedMethods() {
        for (JavaResourceMethod method : this.getMethods()) {
            if (!method.isAnnotated()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasEqualsMethod() {
        for (JavaResourceMethod method : this.getMethods()) {
            if (!ObjectTools.equals((Object)method.getMethodName(), (Object)"equals") || method.getParametersSize() != 1 || !ObjectTools.equals((Object)method.getParameterTypeName(0), (Object)Object.class.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasHashCodeMethod() {
        for (JavaResourceMethod method : this.getMethods()) {
            if (!ObjectTools.equals((Object)method.getMethodName(), (Object)"hashCode") || method.getParametersSize() != 0) continue;
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class FieldTransformer
    extends TransformerAdapter<IField, JavaResourceField> {
        FieldTransformer() {
        }

        public JavaResourceField transform(IField field) {
            return BinaryType.this.buildField(field);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MethodTransformer
    extends TransformerAdapter<IMethod, JavaResourceMethod> {
        MethodTransformer() {
        }

        public JavaResourceMethod transform(IMethod method) {
            return BinaryType.this.buildMethod(method);
        }
    }
}

