/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal;

import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jpt.common.core.AnnotationProvider;
import org.eclipse.jpt.common.core.resource.java.Annotation;
import org.eclipse.jpt.common.core.resource.java.AnnotationDefinition;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.NestableAnnotation;
import org.eclipse.jpt.common.core.resource.java.NestableAnnotationDefinition;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SimpleAnnotationProvider
implements AnnotationProvider {
    private final AnnotationDefinition[] annotationDefinitions;
    private final NestableAnnotationDefinition[] nestableAnnotationDefinitions;

    public SimpleAnnotationProvider(AnnotationDefinition[] annotationDefinitions, NestableAnnotationDefinition[] nestableAnnotationDefinitions) {
        this.annotationDefinitions = annotationDefinitions;
        this.nestableAnnotationDefinitions = nestableAnnotationDefinitions;
    }

    private Iterable<AnnotationDefinition> getAnnotationDefinitions() {
        return IterableTools.iterable((Object[])this.annotationDefinitions);
    }

    private AnnotationDefinition getAnnotationDefinition(String annotationName) {
        AnnotationDefinition[] annotationDefinitionArray = this.annotationDefinitions;
        int n = this.annotationDefinitions.length;
        int n2 = 0;
        while (n2 < n) {
            AnnotationDefinition annotationDefinition = annotationDefinitionArray[n2];
            if (annotationDefinition.getAnnotationName().equals(annotationName)) {
                return annotationDefinition;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public Iterable<String> getAnnotationNames() {
        return IterableTools.transform(this.getAnnotationDefinitions(), AnnotationDefinition.ANNOTATION_NAME_TRANSFORMER);
    }

    @Override
    public Iterable<String> getContainerAnnotationNames() {
        return IterableTools.transform(this.getNestableAnnotationDefinitions(), NestableAnnotationDefinition.CONTAINER_ANNOTATION_NAME_TRANSFORMER);
    }

    @Override
    public Iterable<String> getNestableAnnotationNames() {
        return IterableTools.transform(this.getNestableAnnotationDefinitions(), NestableAnnotationDefinition.NESTABLE_ANNOTATION_NAME_TRANSFORMER);
    }

    @Override
    public Annotation buildAnnotation(JavaResourceAnnotatedElement parent, AnnotatedElement element, String annotationName) {
        return this.getAnnotationDefinition(annotationName).buildAnnotation(parent, element);
    }

    @Override
    public Annotation buildAnnotation(JavaResourceAnnotatedElement parent, IAnnotation jdtAnnotation) {
        return this.getAnnotationDefinition(jdtAnnotation.getElementName()).buildAnnotation(parent, jdtAnnotation);
    }

    @Override
    public NestableAnnotation buildAnnotation(JavaResourceAnnotatedElement parent, IAnnotation jdtAnnotation, int index) {
        return this.getNestableAnnotationDefinition(jdtAnnotation.getElementName()).buildAnnotation(parent, jdtAnnotation, index);
    }

    @Override
    public Annotation buildNullAnnotation(JavaResourceAnnotatedElement parent, String annotationName) {
        return this.getAnnotationDefinition(annotationName).buildNullAnnotation(parent);
    }

    private Iterable<NestableAnnotationDefinition> getNestableAnnotationDefinitions() {
        return IterableTools.iterable((Object[])this.nestableAnnotationDefinitions);
    }

    private NestableAnnotationDefinition getNestableAnnotationDefinition(String annotationName) {
        NestableAnnotationDefinition[] nestableAnnotationDefinitionArray = this.nestableAnnotationDefinitions;
        int n = this.nestableAnnotationDefinitions.length;
        int n2 = 0;
        while (n2 < n) {
            NestableAnnotationDefinition annotationDefinition = nestableAnnotationDefinitionArray[n2];
            if (annotationDefinition.getNestableAnnotationName().equals(annotationName)) {
                return annotationDefinition;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public NestableAnnotation buildAnnotation(JavaResourceAnnotatedElement parent, AnnotatedElement element, String annotationName, int index) {
        return this.getNestableAnnotationDefinition(annotationName).buildAnnotation(parent, element, index);
    }

    @Override
    public String getNestableAnnotationName(String containerAnnotationName) {
        return this.getNestableAnnotationDefinitionForContainer(containerAnnotationName).getNestableAnnotationName();
    }

    @Override
    public String getContainerAnnotationName(String nestableAnnotationName) {
        return this.getNestableAnnotationDefinition(nestableAnnotationName).getContainerAnnotationName();
    }

    @Override
    public String getNestableElementName(String nestableAnnotationName) {
        return this.getNestableAnnotationDefinition(nestableAnnotationName).getElementName();
    }

    private NestableAnnotationDefinition getNestableAnnotationDefinitionForContainer(String containerAnnotationName) {
        NestableAnnotationDefinition[] nestableAnnotationDefinitionArray = this.nestableAnnotationDefinitions;
        int n = this.nestableAnnotationDefinitions.length;
        int n2 = 0;
        while (n2 < n) {
            NestableAnnotationDefinition nestableAnnotationDefinition = nestableAnnotationDefinitionArray[n2];
            if (nestableAnnotationDefinition.getContainerAnnotationName().equals(containerAnnotationName)) {
                return nestableAnnotationDefinition;
            }
            ++n2;
        }
        return null;
    }
}

