/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.paas.client.maven;

import java.util.List;
import oracle.cloud.paas.client.cli.Main;
import oracle.cloud.paas.client.cli.command.DescribeServiceInstance;
import oracle.cloud.paas.client.maven.CloudCliBaseMojo;
import oracle.cloud.paas.model.Association;
import oracle.cloudlogic.javaservice.common.clibase.CommandLine;
import oracle.cloudlogic.javaservice.common.clibase.util.CloudUtil;

public class DescribeServiceInstanceMojo
extends CloudCliBaseMojo {
    private String dbserviceinstanceproperty;
    private String serviceinstancesizeproperty;
    private String serviceinstancestatusproperty;

    public void performCli() throws Exception {
        super.performCli();
        DescribeServiceInstance desc = (DescribeServiceInstance)this.cmd.getExecutor();
        List list = desc.getDBAssociations();
        if (this.serviceinstancesizeproperty != null && desc.getServiceInstance().getSize() != null) {
            this.setMavenProperty(this.serviceinstancesizeproperty, desc.getServiceInstance().getSize().toString());
        }
        if (this.serviceinstancestatusproperty != null && desc.getServiceInstance().getState() != null) {
            this.setMavenProperty(this.serviceinstancestatusproperty, desc.getServiceInstance().getState().toString());
        }
        if (this.dbserviceinstanceproperty != null) {
            List props = CloudUtil.parseString((String)this.dbserviceinstanceproperty, (String)",", (boolean)true);
            if (list.isEmpty()) {
                throw new Exception("There is no Database association found");
            }
            for (int count = 0; count < list.size(); ++count) {
                if (props.size() <= count) continue;
                this.setMavenProperty((String)props.get(count), ((Association)list.get(count)).getTargetInstanceName());
            }
        }
    }

    public CommandLine getCommandLine() {
        return (CommandLine)Main.allCommands.get((Object)"describe-service-instance");
    }

    public void setDbserviceinstanceproperty(String dbserviceinstanceproperty) {
        this.dbserviceinstanceproperty = dbserviceinstanceproperty;
    }

    public String getDbserviceinstanceproperty() {
        return this.dbserviceinstanceproperty;
    }

    public void setServiceinstancesizeproperty(String serviceinstancesizeproperty) {
        this.serviceinstancesizeproperty = serviceinstancesizeproperty;
    }

    public String getServiceinstancesizeproperty() {
        return this.serviceinstancesizeproperty;
    }

    public void setServiceinstancestatusproperty(String serviceinstancestatusproperty) {
        this.serviceinstancestatusproperty = serviceinstancestatusproperty;
    }

    public String getServiceinstancestatusproperty() {
        return this.serviceinstancestatusproperty;
    }
}

