/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.paas.client.maven;

import java.io.File;
import oracle.cloud.paas.client.ClientConstants;
import oracle.cloud.paas.client.cli.Main;
import oracle.cloudlogic.javaservice.common.clibase.CommandLine;
import oracle.cloudlogic.javaservice.common.clibase.CommandLineArg;
import oracle.cloudlogic.javaservice.common.clibase.util.CloudUtil;
import oracle.cloudlogic.javaservice.common.clibase.util.logger.Logger;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;

public abstract class CloudCliBaseMojo
extends AbstractMojo
implements ClientConstants {
    private boolean failonerror = false;
    private boolean forcestandalone = false;
    protected MavenSession session;
    private MavenProject project;
    private String datacenter;
    private String adminurl;
    private String application;
    private String applicationtype;
    private String classpath;
    private String datasource;
    private String debug;
    private String descending;
    private String grid;
    private String gridwidth;
    private String help;
    private String httpproxy;
    private String identitydomain;
    private String ignorehostnameverification;
    private String jobid;
    private String local;
    private String log;
    private String moduleuri;
    private String nohttpproxy;
    private String output;
    private String password;
    private String path;
    private String server;
    private String serviceinstance;
    private String sorton;
    private String trustservercert;
    private String truststore;
    private String user;
    private String verbose;
    private String workmanager;
    private String xml;
    private String severity;
    private String contains;
    private String containsseperator;
    private String last;
    private String unit;
    private String starttime;
    private String endtime;
    private String datetimeformat;
    private String follow;
    private String groupby;
    private String status;
    private String limit;
    private String force;
    private String timeout;
    private String key;
    private String keyuser;
    private String keypassword;
    private String map;
    private String alias;
    private String certfiletype;
    private String search;
    private String library;
    private String specversion;
    private String implversion;
    private String librarytype;
    private String command;
    private String autoexitonfailure;
    private String validatespecialchars;
    protected CommandLine cmd = null;

    public CloudCliBaseMojo() {
        try {
            CommandLine one = this.getCommandLine();
            if (one == null) {
                throw new Exception("Command not found. It could be caused if an old SDK is used.");
            }
            this.cmd = (CommandLine)one.simpleClone();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setMavenProperty(String name, String val) {
        if (name != null) {
            if (val != null) {
                this.project.getProperties().put(name, val);
            } else {
                this.project.getProperties().remove(name);
            }
        }
    }

    public String findProperty(String name) {
        if (name == null) {
            return null;
        }
        String val = this.session.getUserProperties().getProperty(name);
        if (val == null) {
            val = this.project.getProperties().getProperty(name);
        }
        return val;
    }

    public abstract CommandLine getCommandLine();

    private final boolean isStandalone() {
        boolean standalone;
        if (this.project == null) {
            return true;
        }
        boolean bl = standalone = this.project.getArtifact().getArtifactId().equals("standalone-pom") && this.project.getGroupId().equals("org.apache.maven");
        if (standalone) {
            return true;
        }
        return this.isForcestandalone();
    }

    protected void performCli() throws Exception {
        CommandLineArg cp;
        if (this.cmd.toPrintHelp()) {
            this.cmd.emitHelp(Main.getMain(), false, null);
            return;
        }
        if (this.cmd.toEnableDebug()) {
            Logger.getDEFAULT().addAllowed(Logger.LOG_MESSAGE_TYPES.TRACE);
            Logger.getDEFAULT().addAllowed(Logger.LOG_MESSAGE_TYPES.DEBUG);
        }
        if ((cp = (CommandLineArg)this.cmd.getArgs().get((Object)"classpath")) != null) {
            String sdk;
            String classpath = cp.getOptionValue();
            if (classpath == null) {
                classpath = "";
            }
            if ((sdk = this.findProperty("SDK_HOME")) == null) {
                throw new MojoFailureException("SDK_HOME is missing.");
            }
            classpath = classpath + File.pathSeparator + new File(sdk, "lib" + File.separator + "localextension.jar").getAbsolutePath();
            cp.setOptionValue(classpath);
        }
        this.cmd.perform(!this.isStandalone());
    }

    public void execute() throws MojoExecutionException {
        block3: {
            try {
                this.performCli();
            }
            catch (Exception e) {
                if (this.cmd.toEnableDebug()) {
                    Logger.getDEFAULT().addAllowed(Logger.LOG_MESSAGE_TYPES.TRACE);
                }
                Logger.getDEFAULT().println();
                Logger.getDEFAULT().printlnError("--------------------------------------------------------------------");
                CloudUtil.handleFinalException((Throwable)e, (boolean)true);
                Logger.getDEFAULT().printlnError("--------------------------------------------------------------------");
                Logger.getDEFAULT().println();
                if (!this.failonerror) break block3;
                throw new MojoExecutionException(e.getMessage(), e);
            }
        }
    }

    protected void checkAndPutvalue(String val) {
        try {
            throw new Exception("Dummy");
        }
        catch (Exception e) {
            StackTraceElement[] stack = e.getStackTrace();
            String methodName = stack[1].getMethodName();
            if (!methodName.startsWith("set")) {
                throw new RuntimeException("This method should be called from a setter: Called method name is " + methodName);
            }
            String attrib = methodName.substring(3, methodName.length());
            if (attrib.length() == 0) {
                throw new RuntimeException("Invalid attrib Name");
            }
            attrib = attrib.substring(0, 1).toLowerCase() + attrib.substring(1, attrib.length());
            CommandLineArg arg = (CommandLineArg)this.cmd.getArgs().get((Object)attrib);
            if (arg != null) {
                arg.setOptionValue(val);
            }
            return;
        }
    }

    public void setAdminurl(String s) {
        this.checkAndPutvalue(s);
    }

    public void setDatacenter(String s) {
        this.checkAndPutvalue(s);
    }

    public void setApplication(String s) {
        this.checkAndPutvalue(s);
    }

    public void setApplicationtype(String s) {
        this.checkAndPutvalue(s);
    }

    public void setClasspath(String s) {
        this.checkAndPutvalue(s);
    }

    public void setDatasource(String s) {
        this.checkAndPutvalue(s);
    }

    public void setDebug(String s) {
        this.checkAndPutvalue(s);
    }

    public void setDescending(String s) {
        this.checkAndPutvalue(s);
    }

    public void setGrid(String s) {
        this.checkAndPutvalue(s);
    }

    public void setGridwidth(String s) {
        this.checkAndPutvalue(s);
    }

    public void setHelp(String s) {
        this.checkAndPutvalue(s);
    }

    public void setHttpproxy(String s) {
        this.checkAndPutvalue(s);
    }

    public void setIdentitydomain(String s) {
        this.checkAndPutvalue(s);
    }

    public void setIgnorehostnameverification(String s) {
        this.checkAndPutvalue(s);
    }

    public void setJobid(String s) {
        this.checkAndPutvalue(s);
    }

    public void setLocal(String s) {
        this.checkAndPutvalue(s);
    }

    public void setLog(String s) {
        this.checkAndPutvalue(s);
    }

    public void setModuleuri(String s) {
        this.checkAndPutvalue(s);
    }

    public void setNohttpproxy(String s) {
        this.checkAndPutvalue(s);
    }

    public void setOutput(String s) {
        this.checkAndPutvalue(s);
    }

    public void setPassword(String s) {
        this.checkAndPutvalue(s);
    }

    public void setPath(String s) {
        this.checkAndPutvalue(s);
    }

    public void setServer(String s) {
        this.checkAndPutvalue(s);
    }

    public void setServiceinstance(String s) {
        this.checkAndPutvalue(s);
    }

    public void setSorton(String s) {
        this.checkAndPutvalue(s);
    }

    public void setTrustservercert(String s) {
        this.checkAndPutvalue(s);
    }

    public void setTruststore(String s) {
        this.checkAndPutvalue(s);
    }

    public void setUser(String s) {
        this.checkAndPutvalue(s);
    }

    public void setVerbose(String s) {
        this.checkAndPutvalue(s);
    }

    public void setWorkmanager(String s) {
        this.checkAndPutvalue(s);
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public void setFailonerror(boolean failonerror) {
        this.failonerror = failonerror;
    }

    public boolean isFailonerror() {
        return this.failonerror;
    }

    public void setForcestandalone(boolean forcestandalone) {
        this.forcestandalone = forcestandalone;
    }

    public boolean isForcestandalone() {
        return this.forcestandalone;
    }

    public void setFollow(String s) {
        this.checkAndPutvalue(s);
    }

    public void setDatetimeformat(String s) {
        this.checkAndPutvalue(s);
    }

    public void setEndtime(String s) {
        this.checkAndPutvalue(s);
    }

    public void setStarttime(String s) {
        this.checkAndPutvalue(s);
    }

    public void setUnit(String s) {
        this.checkAndPutvalue(s);
    }

    public void setLast(String s) {
        this.checkAndPutvalue(s);
    }

    public void setContainsseperator(String s) {
        this.checkAndPutvalue(s);
    }

    public void setContains(String s) {
        this.checkAndPutvalue(s);
    }

    public void setSeverity(String s) {
        this.checkAndPutvalue(s);
    }

    public void setXml(String s) {
        this.checkAndPutvalue(s);
    }

    public void setGroupby(String s) {
        this.checkAndPutvalue(s);
    }

    public void setStatus(String s) {
        this.checkAndPutvalue(s);
    }

    public void setLimit(String s) {
        this.checkAndPutvalue(s);
    }

    public void setForce(String s) {
        this.checkAndPutvalue(s);
    }

    public void setTimeout(String s) {
        this.checkAndPutvalue(s);
    }

    public void setKey(String s) {
        this.checkAndPutvalue(s);
    }

    public void setCommand(String s) {
        this.checkAndPutvalue(s);
    }

    public void setAutoexitonfailure(String s) {
        this.checkAndPutvalue(s);
    }

    public void setValidatespecialchars(String s) {
        this.checkAndPutvalue(s);
    }

    public void setKeyuser(String s) {
        this.checkAndPutvalue(s);
    }

    public void setKeypassword(String s) {
        this.checkAndPutvalue(s);
    }

    public void setMap(String s) {
        this.checkAndPutvalue(s);
    }

    public void setAlias(String s) {
        this.checkAndPutvalue(s);
    }

    public void setCertfiletype(String s) {
        this.checkAndPutvalue(s);
    }

    public void setSearch(String s) {
        this.checkAndPutvalue(s);
    }

    public void setLibrary(String s) {
        this.checkAndPutvalue(s);
    }

    public void setSpecversion(String s) {
        this.checkAndPutvalue(s);
    }

    public void setImplversion(String s) {
        this.checkAndPutvalue(s);
    }

    public void setLibrarytype(String s) {
        this.checkAndPutvalue(s);
    }
}

