/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.ui.internal.swt.bind;

import org.eclipse.jpt.common.ui.internal.listeners.SWTPropertyChangeListenerWrapper;
import org.eclipse.jpt.common.ui.internal.swt.bind.WidgetLabelAdapter;
import org.eclipse.jpt.common.ui.internal.swt.events.DisposeAdapter;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeAdapter;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LabelModelBinding {
    private final PropertyValueModel<Image> imageModel;
    private final PropertyChangeListener imageListener;
    private final PropertyValueModel<String> textModel;
    private final PropertyChangeListener textListener;
    private final WidgetLabelAdapter labelAdapter;
    private final DisposeListener widgetDisposeListener;

    LabelModelBinding(PropertyValueModel<Image> imageModel, PropertyValueModel<String> textModel, WidgetLabelAdapter labelAdapter) {
        if (imageModel == null || textModel == null || labelAdapter == null) {
            throw new NullPointerException();
        }
        this.imageModel = imageModel;
        this.textModel = textModel;
        this.labelAdapter = labelAdapter;
        this.imageListener = this.buildImageListener();
        this.imageModel.addPropertyChangeListener("value", this.imageListener);
        this.textListener = this.buildTextListener();
        this.textModel.addPropertyChangeListener("value", this.textListener);
        this.widgetDisposeListener = this.buildWidgetDisposeListener();
        this.getWidget().addDisposeListener(this.widgetDisposeListener);
        this.setImage((Image)this.imageModel.getValue());
        this.setText((String)this.textModel.getValue());
    }

    private PropertyChangeListener buildImageListener() {
        return new SWTPropertyChangeListenerWrapper((PropertyChangeListener)new ImageListener());
    }

    private PropertyChangeListener buildTextListener() {
        return new SWTPropertyChangeListenerWrapper((PropertyChangeListener)new TextListener());
    }

    private DisposeListener buildWidgetDisposeListener() {
        return new WidgetDisposeListener();
    }

    void setImage(Image image) {
        if (!this.getWidget().isDisposed()) {
            this.labelAdapter.setImage(image);
        }
    }

    void setText(String text) {
        if (!this.getWidget().isDisposed()) {
            this.labelAdapter.setText(text != null ? text : "");
        }
    }

    private Widget getWidget() {
        return this.labelAdapter.getWidget();
    }

    void widgetDisposed() {
        this.getWidget().removeDisposeListener(this.widgetDisposeListener);
        this.imageModel.removePropertyChangeListener("value", this.imageListener);
        this.textModel.removePropertyChangeListener("value", this.textListener);
    }

    public String toString() {
        return ObjectTools.toString((Object)this, this.textModel);
    }

    class ImageListener
    extends PropertyChangeAdapter {
        ImageListener() {
        }

        public void propertyChanged(PropertyChangeEvent event) {
            LabelModelBinding.this.setImage((Image)event.getNewValue());
        }
    }

    class TextListener
    extends PropertyChangeAdapter {
        TextListener() {
        }

        public void propertyChanged(PropertyChangeEvent event) {
            LabelModelBinding.this.setText((String)event.getNewValue());
        }
    }

    class WidgetDisposeListener
    extends DisposeAdapter {
        WidgetDisposeListener() {
        }

        public void widgetDisposed(DisposeEvent event) {
            LabelModelBinding.this.widgetDisposed();
        }
    }
}

