/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.webapp;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.application.common.services.util.UrlUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class WebAppFolderMapper {
    private final List<MappingInfo> mMappings;
    private final IProject _project;

    public WebAppFolderMapper(IProject project) {
        this._project = project;
        IVirtualComponent rootComponent = ComponentCore.createComponent((IProject)this._project);
        if (rootComponent == null) {
            throw new IllegalArgumentException("project is not a valid virtual web project");
        }
        IPath pathToWebRoot = rootComponent.getRootFolder().getUnderlyingFolder().getProjectRelativePath();
        this.mMappings = new ArrayList<MappingInfo>(1);
        this.mMappings.add(new MappingInfo(project, (IPath)new Path("/"), pathToWebRoot));
    }

    public WebAppFolderMapper(IProject project, MappingInfo[] mappings) {
        this._project = project;
        this.mMappings = new ArrayList<MappingInfo>(Arrays.asList(mappings));
    }

    public List<MappingInfo> getMappings() {
        return Collections.unmodifiableList(this.mMappings);
    }

    public IPath resolveUri(IResource referencingResource, String uri) {
        return UrlUtil.resolveUri(referencingResource, uri);
    }

    public static MappingInfo findProjectRootMapping(MappingInfo[] mappings, String projectName) {
        int i = 0;
        while (i < mappings.length) {
            MappingInfo mi = mappings[i];
            if (projectName.equals(mi.getProjectName()) && mi.getWebAppUri().equals((Object)new Path("/"))) {
                return mi;
            }
            ++i;
        }
        return null;
    }

    public static class MappingInfo
    implements Cloneable {
        private final String mProjectUri;
        private final IProject _project;
        private final IPath mWebAppUri;

        public MappingInfo(IProject project, IPath webAppUri, IPath projectRelativePath) {
            this._project = project;
            this.mWebAppUri = webAppUri;
            this.mProjectUri = new Path("/").equals((Object)projectRelativePath) ? "./" : projectRelativePath.toString();
        }

        public IProject getProject() {
            return this._project;
        }

        public String getProjectName() {
            return this._project.getName();
        }

        public String getProjectUri() {
            return this.mProjectUri;
        }

        public IPath getWebAppUri() {
            return this.mWebAppUri;
        }

        public File getFolder() {
            throw new UnsupportedOperationException();
        }

        public URL getUrl() {
            throw new UnsupportedOperationException();
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }
    }
}

