/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.webapp;

import java.util.Locale;
import java.util.concurrent.CopyOnWriteArrayList;
import oracle.eclipse.tools.application.common.services.Messages;
import oracle.eclipse.tools.application.common.services.appservices.IDesignTimeLocaleService;
import oracle.eclipse.tools.common.services.project.Project;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;

public class DesignTimeLocaleService
implements IDesignTimeLocaleService {
    private static final String PREFIX = "oracle.eclipse.tools.application.common.services.prefs/";
    private static final String CURRENT_LOCALE_LANGUAGE = "oracle.eclipse.tools.application.common.services.prefs/currentLocaleLanguage";
    private static final String CURRENT_LOCALE_COUNTRY = "oracle.eclipse.tools.application.common.services.prefs/currentLocaleCountry";
    private static final String CURRENT_LOCALE_VARIANT = "oracle.eclipse.tools.application.common.services.prefs/currentLocaleVariant";
    private static final String LOCALE_COUNTRY_DEFAULT = "";
    private static final String LOCALE_VARIANT_DEFAULT = "";
    private final CopyOnWriteArrayList<IDesignTimeLocaleService.ICurrentLocaleListener> _listeners = new CopyOnWriteArrayList();
    private final IProject _iProject;
    private final IEclipsePreferences _prefs;

    public DesignTimeLocaleService(Project project) {
        this._iProject = project.getEclipseProject();
        this._prefs = InstanceScope.INSTANCE.getNode("oracle.eclipse.tools.application.common.services");
    }

    @Override
    public Locale getCurrentLocale() {
        String language = this._prefs.get(CURRENT_LOCALE_LANGUAGE, null);
        if (language == null || language.trim().length() == 0) {
            return Locale.getDefault();
        }
        String country = this._prefs.get(CURRENT_LOCALE_COUNTRY, "");
        String variant = this._prefs.get(CURRENT_LOCALE_VARIANT, "");
        return new Locale(language, country, variant);
    }

    @Override
    public Boolean storeCurrentLocale(Locale locale) {
        Locale previous = this.getCurrentLocale();
        Locale newLocale = locale;
        if (newLocale == null) {
            newLocale = Locale.getDefault();
        }
        if (previous.equals(newLocale)) {
            return null;
        }
        String language = newLocale.getLanguage();
        String country = newLocale.getCountry();
        String variant = newLocale.getVariant();
        this._prefs.put(CURRENT_LOCALE_LANGUAGE, language);
        this._prefs.put(CURRENT_LOCALE_COUNTRY, country);
        this._prefs.put(CURRENT_LOCALE_VARIANT, variant);
        try {
            this._prefs.flush();
        }
        catch (BackingStoreException bse) {
            LoggingService.logException((String)"oracle.eclipse.tools.application.common.services", (Throwable)bse, (String)Messages.DesignTimeLocaleService_CannotSaveLocale_Error);
            return Boolean.FALSE;
        }
        this.updateListeners(previous, newLocale);
        return Boolean.TRUE;
    }

    protected void updateListeners(Locale oldLocale, Locale newLocale) {
        IDesignTimeLocaleService.CurrentLocaleUpdateEvent event = new IDesignTimeLocaleService.CurrentLocaleUpdateEvent(this, oldLocale, newLocale, this._iProject);
        for (IDesignTimeLocaleService.ICurrentLocaleListener listener : this._listeners) {
            listener.localeChanged(event);
        }
        MyGlobalLocaleListeners.fireEventToGlobalListeners(event);
    }

    @Override
    public void addCurrentLocaleListener(IDesignTimeLocaleService.ICurrentLocaleListener listener) {
        this._listeners.addIfAbsent(listener);
    }

    @Override
    public void removeCurrentLocaleListener(IDesignTimeLocaleService.ICurrentLocaleListener listener) {
        this._listeners.remove(listener);
    }

    protected static final class MyGlobalLocaleListeners
    extends IDesignTimeLocaleService.GlobalLocaleListeners {
        protected MyGlobalLocaleListeners() {
        }

        public static void fireEventToGlobalListeners(IDesignTimeLocaleService.CurrentLocaleUpdateEvent event) {
            for (IDesignTimeLocaleService.ICurrentLocaleListener listener : _GLOBAL_LISTENERS) {
                listener.localeChanged(event);
            }
        }
    }
}

