/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.variables.internal;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.List;
import oracle.eclipse.tools.application.common.services.documentservices.IImplicitVariableProvider;
import oracle.eclipse.tools.application.common.services.variables.ImplicitVariable;
import oracle.eclipse.tools.application.common.services.variables.ValueReference;
import oracle.eclipse.tools.application.common.services.variables.Variable;
import oracle.eclipse.tools.application.common.services.variables.internal.IValueReferencePersistenceHandler;
import oracle.eclipse.tools.common.services.dependency.artifact.Range;
import oracle.eclipse.tools.common.services.document.IDocument;
import oracle.eclipse.tools.common.services.util.ObjectUtil;
import oracle.eclipse.tools.common.services.util.SerializationUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;

class ImplicitVariableValueReferencePersistenceHandler
implements IValueReferencePersistenceHandler,
Serializable {
    private static final long serialVersionUID = 1L;
    private final IFile _file;
    private final String _varName;
    private final String _fieldName;
    private final Range _referenceLocation;

    ImplicitVariableValueReferencePersistenceHandler(IResource resource, ValueReference valueRef) {
        if (resource == null || resource.getType() != 1) {
            throw new IllegalArgumentException("Program error: The resource must be a file.");
        }
        if (valueRef == null || valueRef.getVariable() == null || !(valueRef.getVariable() instanceof ImplicitVariable)) {
            throw new IllegalArgumentException("Program error: The value reference must be for an implicit variable.");
        }
        this._file = (IFile)resource;
        this._varName = valueRef.getVariable().getName();
        this._fieldName = valueRef.getFieldName();
        this._referenceLocation = valueRef.getLocation();
    }

    @Override
    public ValueReference getValueReference() {
        IImplicitVariableProvider provider;
        IDocument document = (IDocument)this._file.getAdapter(IDocument.class);
        if (document != null && (provider = (IImplicitVariableProvider)document.getAdapter(IImplicitVariableProvider.class)) != null) {
            List<Variable> variables = provider.getImplicitVariables();
            for (Variable var : variables) {
                if (!var.getName().equals(this._varName)) continue;
                return new ValueReference(var, this._fieldName, this._referenceLocation);
            }
        }
        return null;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this._file == null ? 0 : this._file.hashCode());
        result = 31 * result + (this._fieldName == null ? 0 : this._fieldName.hashCode());
        result = 31 * result + (this._referenceLocation == null ? 0 : this._referenceLocation.hashCode());
        result = 31 * result + (this._varName == null ? 0 : this._varName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ImplicitVariableValueReferencePersistenceHandler)) {
            return false;
        }
        ImplicitVariableValueReferencePersistenceHandler other = (ImplicitVariableValueReferencePersistenceHandler)obj;
        return ObjectUtil.equalObjects((Object)this._file, (Object)other._file) && ObjectUtil.equalObjects((Object)this._varName, (Object)other._varName) && ObjectUtil.equalObjects((Object)this._fieldName, (Object)other._fieldName) && ObjectUtil.equalObjects((Object)this._referenceLocation, (Object)other._referenceLocation);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        SerializationUtil su = SerializationUtil.forOutput((ObjectOutputStream)out);
        su.writeResource((IResource)this._file);
        out.writeObject(this._varName);
        out.writeObject(this._fieldName);
        out.writeObject(this._referenceLocation);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException, IllegalArgumentException, IllegalAccessException {
        SerializationUtil su = SerializationUtil.forInput((ObjectInputStream)in);
        su.readFinalFileFromStream((Object)this, "_file");
        su.readFinalFieldFromStream((Object)this, "_varName", String.class);
        su.readFinalFieldFromStream((Object)this, "_fieldName", String.class);
        su.readFinalFieldFromStream((Object)this, "_referenceLocation", Range.class);
    }
}

