/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.variables;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import oracle.eclipse.tools.application.common.services.variables.DataType;
import oracle.eclipse.tools.application.common.services.variables.IFileVariablesCache;
import oracle.eclipse.tools.application.common.services.variables.IFileVariablesCacheProvider;
import oracle.eclipse.tools.application.common.services.variables.IProjectVariablesCache;
import oracle.eclipse.tools.application.common.services.variables.IVariablesCache;
import oracle.eclipse.tools.application.common.services.variables.IVariablesListener;
import oracle.eclipse.tools.application.common.services.variables.IVariablesReadCache;
import oracle.eclipse.tools.application.common.services.variables.Messages;
import oracle.eclipse.tools.application.common.services.variables.ValueReference;
import oracle.eclipse.tools.application.common.services.variables.Variable;
import oracle.eclipse.tools.application.common.services.variables.VariableQuery;
import oracle.eclipse.tools.application.common.services.variables.VariableReferenceIterator;
import oracle.eclipse.tools.application.common.services.variables.VariablesIterator;
import oracle.eclipse.tools.application.common.services.variables.internal.FileVariablesCache;
import oracle.eclipse.tools.application.common.services.variables.internal.ProjectVariablesCache;
import oracle.eclipse.tools.common.services.Activator;
import oracle.eclipse.tools.common.services.concurrency.AbstractJob;
import oracle.eclipse.tools.common.services.dependency.artifact.ArtifactControllerFactory;
import oracle.eclipse.tools.common.services.dependency.artifact.discovery.IDiscoveryContext;
import oracle.eclipse.tools.common.services.dependency.artifact.discovery.IDiscoveryParticipant;
import oracle.eclipse.tools.common.services.dependency.artifact.discovery.IResourceDiscoveryContext;
import oracle.eclipse.tools.common.services.dependency.artifact.discovery.internal.DiscoveryContextImpl;
import oracle.eclipse.tools.common.services.dependency.model.DependencyModelEvent;
import oracle.eclipse.tools.common.services.dependency.model.IDependencyModelListener;
import oracle.eclipse.tools.common.services.dependency.model.internal.DiscoveryParticipantExtensionReader;
import oracle.eclipse.tools.common.services.dependency.structuredmodel.IVisitableDOMModel;
import oracle.eclipse.tools.common.services.dependency.structuredmodel.StructuredModelFactory;
import oracle.eclipse.tools.common.services.document.IDocument;
import oracle.eclipse.tools.common.services.util.SerializationUtil;
import oracle.eclipse.tools.common.util.ProgressMonitorUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.IFileBuffer;
import org.eclipse.core.filebuffers.IFileBufferListener;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class VariablesController
implements IDependencyModelListener {
    private final Map<IResource, IVariablesCache> cacheMap = new LinkedHashMap<IResource, IVariablesCache>();
    private final Map<IResource, IFileVariablesCache> liveCacheMap = new LinkedHashMap<IResource, IFileVariablesCache>();
    private final Map<IFile, Set<IVariablesListener>> variableListenersMap = new LinkedHashMap<IFile, Set<IVariablesListener>>();
    private final Map<IFile, ModelListenerPair> documentListenersMap = new LinkedHashMap<IFile, ModelListenerPair>();
    private static final VariablesController sINSTANCE = new VariablesController();
    private static boolean sINITIALIZED = false;
    private static final Object FAMILY = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final VariablesController getInstance() {
        VariablesController variablesController = sINSTANCE;
        synchronized (variablesController) {
            if (!sINITIALIZED) {
                ArtifactControllerFactory.getController().addListener((IDependencyModelListener)sINSTANCE);
                VariablesController.initializeBufferListener();
                sINITIALIZED = true;
            }
        }
        return sINSTANCE;
    }

    private static final void initializeBufferListener() {
        IFileBufferListener listener = new IFileBufferListener(){

            public void bufferContentAboutToBeReplaced(IFileBuffer buffer) {
            }

            public void bufferContentReplaced(IFileBuffer buffer) {
            }

            public void bufferCreated(IFileBuffer buffer) {
            }

            public void bufferDisposed(IFileBuffer buffer) {
                VariablesController.getInstance().removeDocumentListener(buffer);
                this.clearLiveCache(buffer);
            }

            public void dirtyStateChanged(IFileBuffer buffer, boolean isDirty) {
            }

            public void stateChangeFailed(IFileBuffer buffer) {
            }

            public void stateChanging(IFileBuffer buffer) {
            }

            public void stateValidationChanged(IFileBuffer buffer, boolean isStateValidated) {
            }

            public void underlyingFileDeleted(IFileBuffer buffer) {
            }

            public void underlyingFileMoved(IFileBuffer buffer, IPath path) {
            }

            private void clearLiveCache(IFileBuffer buffer) {
                IFile file = FileBuffers.getWorkspaceFileAtLocation((IPath)buffer.getLocation());
                if (file == null) {
                    return;
                }
                VariablesController.getInstance().removeLiveCache(file);
            }
        };
        FileBuffers.getTextFileBufferManager().addFileBufferListener(listener);
    }

    private VariablesController() {
    }

    public VariablesIterator iterator(IFile file, boolean useWorkingCopy) {
        return new VariablesIterator(this.getFileCache(file, useWorkingCopy));
    }

    public VariablesIterator iterator(IFile file, boolean useWorkingCopy, boolean listenForUpdates, VariableQuery.QueryMatcher matcher) {
        return new VariablesIterator(this.getFileCache(file, useWorkingCopy, listenForUpdates), matcher);
    }

    public VariableReferenceIterator referenceIterator(IFile file, boolean useWorkingCopy) {
        return new VariableReferenceIterator(this.getFileCache(file, useWorkingCopy));
    }

    public IFileVariablesCache getFileCache(IFile file, boolean useWorkingCopy) {
        return this.getFileCache(file, useWorkingCopy, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IFileVariablesCache getFileCache(IFile file, boolean useWorkingCopy, boolean listenForUpdates) {
        if (!useWorkingCopy) {
            Map<IResource, IVariablesCache> map = this.cacheMap;
            synchronized (map) {
                if (!this.cacheMap.containsKey(file)) {
                    this.cacheMap.put((IResource)file, new FileVariablesCache(file, this.getProjectCache(file.getProject())));
                }
                return (IFileVariablesCache)this.cacheMap.get(file);
            }
        }
        IFileVariablesCache variablesCache = null;
        boolean listening = false;
        Map<IResource, IFileVariablesCache> map = this.liveCacheMap;
        synchronized (map) {
            if (listenForUpdates) {
                Map<IFile, ModelListenerPair> map2 = this.documentListenersMap;
                synchronized (map2) {
                    if (this.documentListenersMap.containsKey(file)) {
                        listening = true;
                    }
                }
            }
            if (!this.liveCacheMap.containsKey(file)) {
                this.liveCacheMap.put((IResource)file, this.getFileCache(file, false));
            }
            variablesCache = this.liveCacheMap.get(file);
        }
        if (listenForUpdates && !listening) {
            this.addDocumentListener(file);
        }
        return variablesCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IFileVariablesCache getFileCacheIfExists(IFile file, boolean useWorkingCopy) {
        if (!useWorkingCopy) {
            Map<IResource, IVariablesCache> map = this.cacheMap;
            synchronized (map) {
                if (this.cacheMap.containsKey(file)) {
                    return (IFileVariablesCache)this.cacheMap.get(file);
                }
            }
            return null;
        }
        IFileVariablesCache variablesCache = null;
        Map<IResource, IFileVariablesCache> map = this.liveCacheMap;
        synchronized (map) {
            variablesCache = this.liveCacheMap.get(file);
            if (variablesCache == null) {
                variablesCache = this.getFileCacheIfExists(file, false);
            }
        }
        return variablesCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IProjectVariablesCache getProjectCache(IProject project) {
        Map<IResource, IVariablesCache> map = this.cacheMap;
        synchronized (map) {
            if (!this.cacheMap.containsKey(project)) {
                this.cacheMap.put((IResource)project, new ProjectVariablesCache(project));
            }
            return (IProjectVariablesCache)this.cacheMap.get(project);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IVariablesCache> getVariableCaches(IProject project) {
        ArrayList<IVariablesCache> variablesCaches = new ArrayList<IVariablesCache>();
        Map<IResource, IVariablesCache> map = this.cacheMap;
        synchronized (map) {
            for (Map.Entry<IResource, IVariablesCache> entry : this.cacheMap.entrySet()) {
                IResource key = entry.getKey();
                if (!key.getProject().equals((Object)project) || key.getType() != 1) continue;
                variablesCaches.add(entry.getValue());
            }
        }
        return variablesCaches;
    }

    public boolean hasDocumentListener(IFile file) {
        return this.documentListenersMap.containsKey(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeLiveCache(IFile file) {
        Map<IResource, IFileVariablesCache> map = this.liveCacheMap;
        synchronized (map) {
            this.liveCacheMap.remove(file);
        }
    }

    public boolean isValueRefReferencedByPage(IFile file, boolean useWorkingCopy, ValueReference valRef) {
        return this.getFileCache(file, useWorkingCopy).hasReference(valRef);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(IVariablesListener listener, IFile file) {
        Map<IFile, Set<IVariablesListener>> map = this.variableListenersMap;
        synchronized (map) {
            Set<IVariablesListener> listeners = this.variableListenersMap.get(file);
            if (listeners == null) {
                listeners = new CopyOnWriteArraySet<IVariablesListener>();
                this.variableListenersMap.put(file, listeners);
            }
            listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(IVariablesListener listener, IFile file) {
        boolean removeDocListener = false;
        Map<IFile, Set<IVariablesListener>> map = this.variableListenersMap;
        synchronized (map) {
            Set<IVariablesListener> listeners = this.variableListenersMap.get(file);
            if (listeners != null) {
                listeners.remove(listener);
                if (listeners.isEmpty()) {
                    this.variableListenersMap.remove(file);
                    removeDocListener = true;
                }
            }
        }
        if (removeDocListener) {
            this.removeDocumentListener(file);
            this.removeLiveCache(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateListeners(IFile file, IVariablesListener.VariableChangeEvent event) {
        Set<IVariablesListener> listeners;
        Map<IFile, Set<IVariablesListener>> map = this.variableListenersMap;
        synchronized (map) {
            listeners = this.variableListenersMap.get(file);
        }
        if (listeners != null) {
            for (IVariablesListener lisitener : listeners) {
                lisitener.refresh(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateListeners(IProject project, IVariablesListener.VariableChangeEvent event) {
        HashSet listenersSet = new HashSet();
        Map<IFile, Set<IVariablesListener>> map = this.variableListenersMap;
        synchronized (map) {
            Set<Map.Entry<IFile, Set<IVariablesListener>>> entries = this.variableListenersMap.entrySet();
            for (Map.Entry<IFile, Set<IVariablesListener>> entry : entries) {
                if (!entry.getKey().getProject().equals((Object)project) || entry.getValue() == null) continue;
                listenersSet.addAll(entry.getValue());
            }
        }
        for (IVariablesListener lisitener : listenersSet) {
            lisitener.refresh(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void projectClosed(IProject project) {
        Map<IResource, IVariablesCache> map = this.liveCacheMap;
        synchronized (map) {
            Iterator<IResource> liveMapIter = this.liveCacheMap.keySet().iterator();
            while (liveMapIter.hasNext()) {
                if (liveMapIter.next().getProject() != project) continue;
                liveMapIter.remove();
            }
        }
        map = this.cacheMap;
        synchronized (map) {
            Iterator<IResource> cacheMapIter = this.cacheMap.keySet().iterator();
            while (cacheMapIter.hasNext()) {
                if (cacheMapIter.next().getProject() != project) continue;
                cacheMapIter.remove();
            }
        }
        this.updateListeners(project, new IVariablesListener.VariableChangeEvent(this, (IResource)project, IVariablesListener.VariableChangeEvent.PersistentCache, IVariablesListener.VariableChangeEvent.AllVariableChange, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDocumentListener(IFile file) {
        block7: {
            if (file == null) {
                return;
            }
            try {
                IStructuredDocument doc;
                IVisitableDOMModel model = StructuredModelFactory.getVisitableModelForRead((IFile)file);
                if (model == null || (doc = model.getModel().getStructuredDocument()) == null) break block7;
                DocumentListener listener = new DocumentListener(doc, file);
                Map<IFile, ModelListenerPair> map = this.documentListenersMap;
                synchronized (map) {
                    this.documentListenersMap.put(file, new ModelListenerPair(model, listener));
                }
                doc.addDocumentListener((IDocumentListener)listener);
            }
            catch (CoreException e) {
                LoggingService.logException((String)"oracle.eclipse.tools.application.common.services", (CoreException)e);
            }
            catch (IOException e) {
                LoggingService.logException((String)"oracle.eclipse.tools.application.common.services", (Throwable)e);
            }
        }
    }

    private void removeDocumentListener(IFileBuffer buffer) {
        if (!(buffer instanceof ITextFileBuffer)) {
            return;
        }
        IFile file = FileBuffers.getWorkspaceFileAtLocation((IPath)buffer.getLocation());
        if (file == null) {
            return;
        }
        this.removeDocumentListener(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDocumentListener(IFile file) {
        ModelListenerPair pair = null;
        Map<IFile, ModelListenerPair> map = this.documentListenersMap;
        synchronized (map) {
            pair = this.documentListenersMap.remove(file);
        }
        if (pair != null) {
            try {
                IStructuredDocument doc = pair.model.getModel().getStructuredDocument();
                if (doc != null) {
                    doc.removeDocumentListener((IDocumentListener)pair.listener);
                }
            }
            finally {
                pair.model.dispose();
            }
        }
    }

    public void modelChanged(final DependencyModelEvent event) {
        Set<IProject> modifiedProjects;
        if (event.getProject() != null) {
            modifiedProjects = Collections.singleton(event.getProject());
        } else {
            modifiedProjects = new HashSet<IProject>();
            for (IFile file : this.variableListenersMap.keySet()) {
                modifiedProjects.add(file.getProject());
            }
        }
        for (final IProject eventProject : modifiedProjects) {
            if (event.getType() == DependencyModelEvent.EVENT_TYPE.BEFORE_REFRESH) {
                this.clearCacheMap(eventProject, this.cacheMap);
                this.clearFileCacheMap(eventProject, this.liveCacheMap);
            }
            Job job = new Job(Messages.VariablesController_0){

                protected IStatus run(IProgressMonitor monitor) {
                    switch (event.getType()) {
                        case BEFORE_REFRESH: {
                            VariablesController.getInstance().updateListeners(eventProject, new IVariablesListener.VariableChangeEvent((Object)this, (IResource)eventProject, IVariablesListener.VariableChangeEvent.PersistentCache, IVariablesListener.VariableChangeEvent.AllVariableChange, null));
                            break;
                        }
                        case REFRESHED: {
                            for (IFile file : VariablesController.this.variableListenersMap.keySet()) {
                                ModelListenerPair mlp = (ModelListenerPair)VariablesController.this.documentListenersMap.get(file);
                                if (eventProject != null && !eventProject.equals((Object)file.getProject())) continue;
                                VariablesController.this.primeVariableCache(mlp);
                            }
                            break;
                        }
                        case UPDATED: {
                            for (IFile file : VariablesController.this.variableListenersMap.keySet()) {
                                ModelListenerPair mlp = (ModelListenerPair)VariablesController.this.documentListenersMap.get(file);
                                if (eventProject != null && !eventProject.equals((Object)file.getProject())) continue;
                                VariablesController.this.primeVariableCache(mlp);
                            }
                            break;
                        }
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setRule((ISchedulingRule)(eventProject != null ? eventProject : ResourcesPlugin.getWorkspace().getRoot()));
            job.schedule();
        }
    }

    private void clearCacheMap(IProject project, Map<IResource, IVariablesCache> cacheMapToClear) {
        Iterator<Map.Entry<IResource, IVariablesCache>> cacheMapIter = cacheMapToClear.entrySet().iterator();
        while (cacheMapIter.hasNext()) {
            Map.Entry<IResource, IVariablesCache> entry = cacheMapIter.next();
            if (!project.equals((Object)entry.getKey().getProject())) continue;
            cacheMapIter.remove();
        }
    }

    private void clearFileCacheMap(IProject project, Map<IResource, IFileVariablesCache> cacheMapToClear) {
        Iterator<Map.Entry<IResource, IFileVariablesCache>> cacheMapIter = cacheMapToClear.entrySet().iterator();
        while (cacheMapIter.hasNext()) {
            Map.Entry<IResource, IFileVariablesCache> entry = cacheMapIter.next();
            if (!project.equals((Object)entry.getKey().getProject())) continue;
            cacheMapIter.remove();
        }
    }

    private void primeVariableCache(ModelListenerPair mlp) {
        IStructuredDocument doc;
        IDOMModel model;
        if (mlp != null && mlp.listener != null && mlp.model != null && (model = mlp.model.getModel()) != null && (doc = model.getStructuredDocument()) != null) {
            mlp.listener.primeCache(doc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetDataTypes(IProject project) {
        DataType dt;
        List<Variable> vars;
        IVariablesCache cache;
        Map<IResource, IVariablesCache> map = this.cacheMap;
        synchronized (map) {
            for (Map.Entry<IResource, IVariablesCache> entry : this.cacheMap.entrySet()) {
                if (entry.getKey().getProject() != project || (cache = entry.getValue()) == null || (vars = cache.getVariables()) == null) continue;
                for (Variable var : vars) {
                    dt = var.getType();
                    if (dt == null || !dt.isLoaded() || !dt.isNecessaryToUnload()) continue;
                    dt.setLoaded(false);
                }
            }
        }
        map = this.liveCacheMap;
        synchronized (map) {
            for (Map.Entry<IResource, IVariablesCache> entry : this.liveCacheMap.entrySet()) {
                if (entry.getKey().getProject() != project || (cache = entry.getValue()) == null || (vars = cache.getVariables()) == null) continue;
                for (Variable var : vars) {
                    dt = var.getType();
                    if (dt == null || !dt.isLoaded() || !dt.isNecessaryToUnload()) continue;
                    dt.setLoaded(false);
                }
            }
        }
        this.updateListeners(project, new IVariablesListener.VariableChangeEvent(this, (IResource)project, IVariablesListener.VariableChangeEvent.PersistentCache, IVariablesListener.VariableChangeEvent.AllVariableChange, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public IStatus load(IProject project, int saveNumber) {
        ois = null;
        try {
            block33: {
                fileName = this.getFileName(saveNumber);
                ois = SerializationUtil.getInputStream((IProject)project, (String)fileName);
                if (ois == null) {
                    var9_8 = new Status(2, "oracle.eclipse.tools.application.common.services", "Unable to find file [" + fileName + "].", null);
                    return var9_8;
                }
                streamObject = null;
                var6_21 = this.cacheMap;
                // MONITORENTER : var6_21
                break block33;
                while (true) {
                    if (!(streamObject instanceof SerializableData)) {
                        var9_9 = new Status(4, "oracle.eclipse.tools.application.common.services", "Corrupt project file.");
                        // MONITOREXIT : var6_21
                        return var9_9;
                    }
                    data = (SerializableData)streamObject;
                    this.cacheMap.put(data.resource, data.cache);
                    break;
                }
            }
            if ((streamObject = ois.readObject()) != SerializationUtil.MARKER.END) ** continue;
            // MONITOREXIT : var6_21
            return Status.OK_STATUS;
        }
        catch (IOException e) {
            var9_10 = new Status(4, "oracle.eclipse.tools.application.common.services", e.getMessage(), (Throwable)e);
            return var9_10;
        }
        catch (ClassNotFoundException e) {
            var9_11 = new Status(4, "oracle.eclipse.tools.application.common.services", e.getMessage(), (Throwable)e);
            return var9_11;
        }
        catch (CoreException e) {
            var9_12 = e.getStatus();
            return var9_12;
        }
        finally {
            try {
                if (ois != null) {
                    ois.close();
                }
            }
            catch (IOException e) {
                LoggingService.logException((String)"oracle.eclipse.tools.application.common.services", (Throwable)e);
            }
            this.deleteFile(project, saveNumber);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus store(IProject project, int saveNumber, int prevSaveNumber) {
        ObjectOutputStream oos = null;
        this.deleteFile(project, prevSaveNumber);
        try {
            try {
                oos = SerializationUtil.getOutputStream((IProject)project, (String)this.getFileName(saveNumber));
                Map<IResource, IVariablesCache> map = this.cacheMap;
                synchronized (map) {
                    for (Map.Entry<IResource, IVariablesCache> savedEntry : this.cacheMap.entrySet()) {
                        if (!savedEntry.getKey().exists() || savedEntry.getKey().getProject() != project) continue;
                        SerializableData data = new SerializableData();
                        data.resource = savedEntry.getKey();
                        data.cache = savedEntry.getValue();
                        oos.writeObject(data);
                    }
                }
                oos.writeObject(SerializationUtil.MARKER.END);
                oos.flush();
            }
            catch (IOException e) {
                this.deleteFile(project, saveNumber);
                Status status = new Status(4, "oracle.eclipse.tools.application.common.services", e.getMessage(), (Throwable)e);
                try {
                    if (oos != null) {
                        oos.close();
                    }
                }
                catch (IOException e2) {
                    LoggingService.logException((String)"oracle.eclipse.tools.application.common.services", (Throwable)e2);
                }
                return status;
            }
            catch (CoreException e) {
                this.deleteFile(project, saveNumber);
                IStatus iStatus = e.getStatus();
                try {
                    if (oos != null) {
                        oos.close();
                    }
                }
                catch (IOException e3) {
                    LoggingService.logException((String)"oracle.eclipse.tools.application.common.services", (Throwable)e3);
                }
                return iStatus;
            }
        }
        finally {
            try {
                if (oos != null) {
                    oos.close();
                }
            }
            catch (IOException e) {
                LoggingService.logException((String)"oracle.eclipse.tools.application.common.services", (Throwable)e);
            }
        }
        return Status.OK_STATUS;
    }

    private void deleteFile(IProject project, int saveNumber) {
        if (saveNumber > 0) {
            String prevFileName = this.getFileName(saveNumber);
            try {
                File projectSerializationFile = SerializationUtil.getSerializedFile((IProject)project, (String)prevFileName, (boolean)false);
                if (projectSerializationFile != null && projectSerializationFile.exists()) {
                    projectSerializationFile.delete();
                }
            }
            catch (RuntimeException re) {
                LoggingService.logException((String)"oracle.eclipse.tools.application.common.services", (Throwable)re);
            }
        }
    }

    private String getFileName(int saveNumber) {
        return saveNumber + ".variable.sjo";
    }

    private static class DocumentListener
    implements IDocumentListener {
        private final IFile file;

        private DocumentListener(IStructuredDocument doc, IFile file) {
            this.file = file;
            this.primeCache(doc);
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
        }

        public void documentChanged(DocumentEvent event) {
            org.eclipse.jface.text.IDocument doc = event.getDocument();
            if (doc instanceof IStructuredDocument) {
                Job[] jobs;
                IStructuredDocument structuredDoc = (IStructuredDocument)doc;
                IJobManager mgr = Job.getJobManager();
                Job[] jobArray = jobs = mgr.find(FAMILY);
                int n = jobs.length;
                int n2 = 0;
                while (n2 < n) {
                    Job job = jobArray[n2];
                    if ((job.getState() == 2 || job.getState() == 1) && job instanceof DocumentRediscoveryJob && ((DocumentRediscoveryJob)job).getDocument().equals(structuredDoc)) {
                        return;
                    }
                    ++n2;
                }
                this.fireRediscoveryJob(this.file, structuredDoc, event.getModificationStamp(), false);
            }
        }

        private void primeCache(IStructuredDocument structuredDoc) {
            this.fireRediscoveryJob(this.file, structuredDoc, -1L, true);
        }

        private void fireRediscoveryJob(IFile fileToDiscover, IStructuredDocument structuredDoc, long timeStamp, boolean force) {
            if (!Activator.getDefault().getPreferences().getProjectPreferences(fileToDiscover.getProject()).isDisabled()) {
                DocumentRediscoveryJob job = new DocumentRediscoveryJob(fileToDiscover, structuredDoc, timeStamp, NLS.bind((String)Messages.VariablesController_jobName, (Object)fileToDiscover.getName()), force);
                job.schedule(500L);
            }
        }
    }

    private static final class DocumentRediscoveryJob
    extends AbstractJob {
        private final IStructuredDocument document;
        private final IFile file;
        private final long timeStamp;
        private final boolean force;

        public DocumentRediscoveryJob(IFile file, IStructuredDocument doc, long timeStamp, String name, boolean force) {
            super(name, file.getProject());
            this.document = doc;
            this.file = file;
            this.timeStamp = timeStamp;
            this.force = force;
            this.setPriority(20);
            this.setDelayedRule((ISchedulingRule)file.getProject());
        }

        public IStructuredDocument getDocument() {
            return this.document;
        }

        public boolean belongsTo(Object family) {
            return FAMILY == family;
        }

        /*
         * Unable to fully structure code
         */
        public IStatus runAfterCommands(IProgressMonitor monitor) {
            if (this.file != null && this.file.isAccessible() && ((oldCache = VariablesController.getInstance().getFileCache(this.file, true)).getModificationTimestamp() < this.timeStamp || this.timeStamp == -1L)) {
                block22: {
                    oldVars = oldCache.getVariables();
                    oldRefs = oldCache.getReferences();
                    VariablesController.access$1(VariablesController.getInstance(), this.file);
                    model = null;
                    try {
                        try {
                            model = StructuredModelFactory.getVisitableModelForRead((IFile)this.file);
                            if (model == null) break block22;
                            discoveryParticipants = DiscoveryParticipantExtensionReader.getParticipants((IProject)this.file.getProject());
                            try {
                                ProgressMonitorUtil.beginTask((IProgressMonitor)monitor, (String)Messages.VariablesController_discoveryTaskTitle, (int)(15 * discoveryParticipants.size()));
                                ctx = new DiscoveryContextImpl(this.file.getProject(), Collections.singleton(this.file), true);
                                resCtx = ctx.createContextFor(this.file);
                                try {
                                    for (IDiscoveryParticipant dp : discoveryParticipants) {
                                        subMon = ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)5);
                                        dp.startDiscovery((IDiscoveryContext)ctx, subMon);
                                    }
                                    for (IDiscoveryParticipant dp : discoveryParticipants) {
                                        subMon = ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)5);
                                        dp.discoverFromExistingModel(resCtx, model, subMon);
                                    }
                                }
                                finally {
                                    ** for (dp : discoveryParticipants)
                                }
lbl-1000:
                                // 1 sources

                                {
                                    subMon = ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)5);
                                    dp.stopDiscovery(subMon);
                                    continue;
                                }
lbl31:
                                // 1 sources

                                VariablesController.getInstance().getFileCache(this.file, true).updateModificationStamp(this.timeStamp);
                                resCtx.dispose();
                            }
                            finally {
                                ProgressMonitorUtil.done((IProgressMonitor)monitor);
                            }
                        }
                        catch (CoreException e) {
                            LoggingService.logException((String)"oracle.eclipse.tools.application.common.services", (CoreException)e);
                            var18_22 = e.getStatus();
                            if (model != null) {
                                model.dispose();
                            }
                            return var18_22;
                        }
                        catch (IOException e) {
                            block23: {
                                LoggingService.logException((String)"oracle.eclipse.tools.application.common.services", (Throwable)e);
                                var18_23 = new Status(4, "oracle.eclipse.tools.application.common.services", e.getMessage(), (Throwable)e);
                                if (model == null) break block23;
                                model.dispose();
                            }
                            return var18_23;
                        }
                    }
                    finally {
                        if (model != null) {
                            model.dispose();
                        }
                    }
                }
                events = new ArrayList<IVariablesListener.VariableChangeEvent.Cause>(2);
                newCache = VariablesController.getInstance().getFileCache(this.file, true);
                if (this.force || !newCache.getVariables().equals(oldVars)) {
                    events.add(IVariablesListener.VariableChangeEvent.Cause.VARIABLE);
                }
                if (this.force || !newCache.getReferences().equals(oldRefs)) {
                    events.add(IVariablesListener.VariableChangeEvent.Cause.REFERENCE);
                }
                if (!events.isEmpty()) {
                    VariablesController.getInstance().updateListeners(this.file, new IVariablesListener.VariableChangeEvent(VariablesController.getInstance(), (IResource)this.file, IVariablesListener.VariableChangeEvent.LiveCache, events, newCache));
                }
            }
            return Status.OK_STATUS;
        }

        protected boolean isIncrementalJob() {
            return true;
        }
    }

    private static class ModelListenerPair {
        private final IVisitableDOMModel model;
        private final DocumentListener listener;

        private ModelListenerPair(IVisitableDOMModel m, DocumentListener l) {
            this.model = m;
            this.listener = l;
        }
    }

    private static class SerializableData
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public transient IResource resource;
        public IVariablesCache cache;

        private SerializableData() {
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.defaultWriteObject();
            SerializationUtil su = SerializationUtil.forOutput((ObjectOutputStream)out);
            su.writeResource(this.resource);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException, IllegalArgumentException {
            in.defaultReadObject();
            SerializationUtil su = SerializationUtil.forInput((ObjectInputStream)in);
            this.resource = su.readResource();
        }
    }

    public static final class VariableCacheAdapterFactory
    implements IAdapterFactory {
        private static final Class[] sADAPTER_LIST = new Class[]{IVariablesCache.class, IVariablesReadCache.class, IProjectVariablesCache.class, IFileVariablesCache.class};

        public Object getAdapter(Object adaptableObject, Class adapterType) {
            if (IVariablesReadCache.class.isAssignableFrom(adapterType)) {
                IDocument doc;
                IResourceDiscoveryContext ctx;
                IResource res;
                if (adaptableObject instanceof IDiscoveryContext) {
                    return VariablesController.getInstance().getProjectCache(((IDiscoveryContext)adaptableObject).getProject());
                }
                if (adaptableObject instanceof IResourceDiscoveryContext && (res = (ctx = (IResourceDiscoveryContext)adaptableObject).getResource()) != null && res.getType() == 1 && (doc = (IDocument)res.getAdapter(IDocument.class)) != null) {
                    IFileVariablesCacheProvider cacheProvider = (IFileVariablesCacheProvider)doc.getAdapter(IFileVariablesCacheProvider.class);
                    return cacheProvider != null ? cacheProvider.getCache(ctx.isWorkingCopy()) : null;
                }
            }
            return null;
        }

        public Class[] getAdapterList() {
            return sADAPTER_LIST;
        }
    }
}

