/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.variables;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.application.common.services.variables.Variable;
import oracle.eclipse.tools.common.services.util.AbstractMatcher;
import oracle.eclipse.tools.common.services.util.ExclusiveCompositeMatcher;
import oracle.eclipse.tools.common.services.util.IMatcher;
import oracle.eclipse.tools.common.services.util.InclusiveCompositeMatcher;

public abstract class VariableQuery {
    public abstract List<Variable> findVariable(QueryMatcher var1);

    public static class ExclusiveCompositeQueryMatcher
    extends ExclusiveCompositeMatcher<Variable>
    implements QueryMatcher {
        public ExclusiveCompositeQueryMatcher(List<? extends IMatcher<Variable>> composeThese) {
            super(composeThese);
        }
    }

    public static class InclusiveCompositeQueryMatcher
    extends InclusiveCompositeMatcher<Variable>
    implements QueryMatcher {
        public InclusiveCompositeQueryMatcher(List<? extends AbstractMatcher<Variable>> composeThese) {
            super(composeThese);
        }
    }

    public static class NameMatcher
    implements NameOptimizedQueryMatcher {
        private final List<String> _names;

        public NameMatcher(String name) {
            this._names = Collections.singletonList(name);
        }

        public NameMatcher(List<String> names) {
            this._names = names;
        }

        public boolean matches(Variable variable) {
            for (String possibleName : this._names) {
                if (!possibleName.equals(variable.getName())) continue;
                return true;
            }
            return false;
        }

        @Override
        public List<Variable> getMatches(Map<String, List<Variable>> cache) {
            ArrayList<Variable> matches = new ArrayList<Variable>();
            for (String possibleName : this._names) {
                List<Variable> matchingNames = cache.get(possibleName);
                if (matchingNames == null || matchingNames.size() <= 0) continue;
                matches.addAll(matchingNames);
            }
            return matches;
        }
    }

    public static interface NameOptimizedQueryMatcher
    extends QueryMatcher {
        public List<Variable> getMatches(Map<String, List<Variable>> var1);
    }

    public static interface QueryMatcher
    extends IMatcher<Variable> {
    }
}

