/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.variables;

import java.io.Serializable;
import oracle.eclipse.tools.application.common.services.FileMessage;
import oracle.eclipse.tools.application.common.services.variables.DataType;
import oracle.eclipse.tools.application.common.services.variables.ResolutionTime;
import oracle.eclipse.tools.application.common.services.variables.VariableMetaData;
import oracle.eclipse.tools.common.services.dependency.artifact.Range;
import oracle.eclipse.tools.common.services.dependency.artifact.ResourceLocation;
import oracle.eclipse.tools.common.services.util.HashCodeUtil;
import oracle.eclipse.tools.common.services.util.ObjectUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jst.jsf.context.IModelContext;

public class Variable
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String VAR_MARKER = "oracle.eclipse.tools.application.common.servicesvarmarker";
    private static final byte RECOMPUTE_TYPE = 1;
    private static final byte SCRIPTABLE = 2;
    private static final byte VALIDATION = 4;
    private boolean _loaded;
    private ResolutionTime _resolutionTime;
    private final ResourceLocation location;
    private transient IMarker marker = null;
    private final ResourceLocation _locationInBaseSourceFile;
    private String mName;
    private DataType mType;
    private SCOPE mScope;
    private FileMessage mErrorMessage;
    private byte mFlags;

    public Variable(String name, DataType type, SCOPE scope, ResourceLocation definitionLocation) {
        this(name, type, scope, ResolutionTime.NOT_AVAILABLE, definitionLocation, null);
    }

    public Variable(String name, DataType type, SCOPE scope, ResolutionTime resolutionTime, ResourceLocation definitionLocation) {
        this(name, type, scope, resolutionTime, definitionLocation, null);
    }

    public Variable(String name, DataType type, SCOPE scope, ResolutionTime resolutionTime, ResourceLocation definitionLocation, ResourceLocation locationInBaseSourceFile) {
        this.mName = name == null ? "" : name;
        this.location = definitionLocation;
        this.marker = this.createMarker();
        this.setType(type);
        this.setScope(scope);
        this.internalSetResolutionType(resolutionTime);
        this.mFlags = (byte)6;
        this._locationInBaseSourceFile = locationInBaseSourceFile;
    }

    private IMarker createMarker() {
        if (this.location != null) {
            IResource res = this.location.getResource();
            Range range = this.location.getRange();
            if (res != null && range != null && res.exists()) {
                try {
                    IMarker mkr = res.createMarker(VAR_MARKER);
                    mkr.setAttribute("message", (Object)this.mName);
                    mkr.setAttribute("severity", 0);
                    mkr.setAttribute("charStart", (Object)((int)range.getOffset()));
                    mkr.setAttribute("charEnd", (Object)((int)range.getEndOffset()));
                    return mkr;
                }
                catch (CoreException e) {
                    LoggingService.logException((String)"oracle.eclipse.tools.application.common.services", (CoreException)e);
                }
            }
        }
        return null;
    }

    public String getName() {
        return this.mName;
    }

    public void setName(String name) {
        this.mName = name;
    }

    public DataType getType() {
        if ((this.mFlags & 1) != 0) {
            this.setLoaded(false);
            this.mFlags = (byte)(this.mFlags & 0xFFFFFFFE);
        }
        return this.mType;
    }

    private void setLoaded(boolean loaded) {
        this._loaded = loaded;
    }

    public boolean isLoaded() {
        return this._loaded;
    }

    public final ResolutionTime getResolutionType() {
        return this._resolutionTime;
    }

    protected final void internalSetResolutionType(ResolutionTime resolutionTime) {
        this._resolutionTime = resolutionTime;
    }

    public void setType(DataType type) {
        this.mType = type;
    }

    public SCOPE getScope() {
        return this.mScope;
    }

    public void setScope(SCOPE scope) {
        this.mScope = scope;
    }

    public String getDescription() {
        return null;
    }

    public boolean isScriptable() {
        return (this.mFlags & 2) != 0;
    }

    public void setScriptable(boolean isScriptable) {
        this.mFlags = isScriptable ? (byte)(this.mFlags | 2) : (byte)(this.mFlags & 0xFFFFFFFD);
    }

    public boolean getValidation() {
        return (this.mFlags & 4) != 0;
    }

    public void setValidation(boolean validation) {
        this.mFlags = validation ? (byte)(this.mFlags | 4) : (byte)(this.mFlags & 0xFFFFFFFB);
    }

    public FileMessage getErrorMessage() {
        return this.mErrorMessage;
    }

    public void setErrorMessage(FileMessage errMsg) {
        this.mErrorMessage = errMsg;
    }

    public boolean checkTypeChange(String typeName, IModelContext context) {
        if ((this.mFlags & 1) != 0) {
            return true;
        }
        if (this.mType != null && this.mType.dependsOn(typeName, context)) {
            this.mFlags = (byte)(this.mFlags | 1);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMarker getMarker() {
        Variable variable = this;
        synchronized (variable) {
            if (this.marker == null) {
                this.marker = this.createMarker();
            }
        }
        return this.marker;
    }

    public boolean isInScope(int absOffset) {
        if (this.marker != null && this.getScope() == SCOPE.NESTED_SCOPE) {
            return true;
        }
        return true;
    }

    public ResourceLocation getLocationInBaseSourceFile() {
        return this._locationInBaseSourceFile;
    }

    public ResourceLocation getDefinitionLocation() {
        return this.location;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Variable)) {
            return false;
        }
        Variable thatVar = (Variable)obj;
        return this.mScope == thatVar.mScope && this._resolutionTime == thatVar._resolutionTime && ObjectUtil.equalObjects((Object)this.mName, (Object)thatVar.mName) && ObjectUtil.equalObjects((Object)this.mType, (Object)thatVar.mType);
    }

    public int hashCode() {
        HashCodeUtil hcu = HashCodeUtil.newInstance();
        hcu.hash((Object)this.mScope);
        hcu.hash((Object)this.mName);
        hcu.hash((Object)this.mType);
        hcu.hash((Object)this._resolutionTime);
        return hcu.getHashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.mName);
        builder.append('[');
        builder.append(this.mType);
        builder.append(']');
        return builder.toString();
    }

    public static enum SCOPE {
        PAGE_SCOPE("page"),
        REQUEST_SCOPE("request"),
        SESSION_SCOPE("session"),
        APPLICATION_SCOPE("application"),
        AT_BEGIN_SCOPE("at-begin"),
        AT_END_SCOPE("at-end"),
        NESTED_SCOPE("nested"),
        NONE_SCOPE(null),
        VIEW_SCOPE(VariableMetaData.VIEW_SCOPE),
        FLASH_SCOPE(VariableMetaData.FLASH_SCOPE),
        ADF_VIEW_SCOPE("view"),
        ADF_PAGE_SCOPE("pageFlow"),
        ADF_BACKING_BEAN_SCOPE("backingBean");

        private String str;

        private SCOPE(String str) {
            this.str = str;
        }

        public String getScopeStr() {
            return this.str;
        }

        public static SCOPE fromString(String scopeStr) {
            if (scopeStr == null) {
                return PAGE_SCOPE;
            }
            SCOPE[] sCOPEArray = SCOPE.values();
            int n = sCOPEArray.length;
            int n2 = 0;
            while (n2 < n) {
                SCOPE scope = sCOPEArray[n2];
                if (scopeStr.equals(scope.getScopeStr())) {
                    return scope;
                }
                ++n2;
            }
            return NESTED_SCOPE;
        }
    }
}

