/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.variables;

import java.util.List;
import oracle.eclipse.tools.application.common.services.el.ELExpressionLRUCache;
import oracle.eclipse.tools.application.common.services.variables.ELExpression;
import oracle.eclipse.tools.application.common.services.variables.IValueReferenceELParser;
import oracle.eclipse.tools.application.common.services.variables.ValueReferenceELParser;

public class ValueReferenceELParser2
implements IValueReferenceELParser {
    public static final ValueReferenceELParser2 INSTANCE = new ValueReferenceELParser2();

    @Override
    public ELExpression getSimpleELExpression(String elExpression) {
        return this.getELExpression(elExpression, ELSearchType.SIMPLE_ONLY);
    }

    @Override
    public ELExpression getELExpression(String elExpression) {
        return this.getELExpression(elExpression, ELSearchType.ALL);
    }

    @Override
    public List<ValueReferenceELParser.ValueReferenceELExpr> getExpressionUnescaped(String elExpression) {
        return ELExpressionLRUCache.INSTANCE.getValueRefs(elExpression);
    }

    private ELExpression getELExpression(String elExpression, ELSearchType searchType) {
        String trimmedText = elExpression.trim();
        ELExpression elExpr = this.maybeGetExpression(trimmedText, searchType);
        if (elExpr != null) {
            return elExpr;
        }
        return null;
    }

    private ELExpression maybeGetExpression(String trimmedText, ELSearchType searchType) {
        ELExpression.EscapeType escapeType = ELExpressionLRUCache.INSTANCE.getEscapeType(trimmedText);
        String rawText = ELExpressionLRUCache.INSTANCE.getRawElText(trimmedText);
        if (escapeType != null && rawText != null && (searchType == ELSearchType.ALL || ELExpressionLRUCache.INSTANCE.isSimpleElExpr(trimmedText))) {
            return new ELExpression(escapeType, rawText);
        }
        return null;
    }

    @Override
    public List<ValueReferenceELParser.ValueReferenceELExpr> getExpressions(String elText) {
        if (elText.startsWith("#{") || elText.startsWith("${")) {
            return this.getExpressionUnescaped(elText);
        }
        return this.getExpressionUnescaped(String.format("#{%s}", elText));
    }

    private static enum ELSearchType {
        SIMPLE_ONLY,
        ALL;

    }
}

