/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.variables;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.eclipse.tools.application.common.services.variables.ELExpression;
import oracle.eclipse.tools.application.common.services.variables.IValueReferenceELParser;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTAddExpression;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTAndExpression;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTChoiceExpression;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTEqualityExpression;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTExpression;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTFunctionInvocation;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTLiteral;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTMultiplyExpression;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTOrExpression;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTRelationalExpression;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTUnaryExpression;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTValue;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTValuePrefix;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTValueSuffix;
import org.eclipse.jst.jsp.core.internal.java.jspel.JSPELParser;
import org.eclipse.jst.jsp.core.internal.java.jspel.JSPELParserVisitor;
import org.eclipse.jst.jsp.core.internal.java.jspel.ParseException;
import org.eclipse.jst.jsp.core.internal.java.jspel.SimpleNode;
import org.eclipse.jst.jsp.core.internal.java.jspel.Token;
import org.eclipse.jst.jsp.core.internal.java.jspel.TokenMgrError;

public class ValueReferenceELParser
implements IValueReferenceELParser {
    private static final String hashPatternString = "#\\{(.*)\\}";
    private static final Pattern hashPattern = Pattern.compile("#\\{(.*)\\}");
    private static final String dollarPatternString = "\\$\\{(.*)\\}";
    private static final Pattern dollarPattern = Pattern.compile("\\$\\{(.*)\\}");

    @Override
    public ELExpression getSimpleELExpression(String elExpression) {
        return this.getELExpression(elExpression, ELSearchType.SIMPLE_ONLY);
    }

    @Override
    public ELExpression getELExpression(String elExpression) {
        return this.getELExpression(elExpression, ELSearchType.ALL);
    }

    private ELExpression getELExpression(String elExpression, ELSearchType searchType) {
        String trimmedText = elExpression.trim();
        ELExpression elExpr = this.maybeGetExpression(trimmedText, hashPattern, ELExpression.EscapeType.HASH_SIGN, searchType);
        if (elExpr != null) {
            return elExpr;
        }
        return this.maybeGetExpression(trimmedText, dollarPattern, ELExpression.EscapeType.DOLLAR_SIGN, searchType);
    }

    private ELExpression maybeGetExpression(String trimmedText, Pattern pattern, ELExpression.EscapeType escapeType, ELSearchType searchType) {
        ValRefELVisitor visitor;
        String extractedExpr = this.extractExpr(trimmedText, pattern);
        if (extractedExpr != null && extractedExpr.length() > 0 && (visitor = this.createAndExecuteVisitor(extractedExpr.trim())) != null && (searchType == ELSearchType.ALL || visitor.isSimpleElExpr())) {
            return new ELExpression(escapeType, extractedExpr);
        }
        return null;
    }

    private String extractExpr(String trimmedText, Pattern pattern) {
        Matcher matcher = pattern.matcher(trimmedText);
        if (matcher.matches()) {
            return matcher.group(1).trim();
        }
        return null;
    }

    @Override
    public List<ValueReferenceELExpr> getExpressions(String elText) {
        ValRefELVisitor visitor = this.createAndExecuteVisitor(elText);
        if (visitor != null) {
            return visitor.getValueRefExprs();
        }
        return Collections.emptyList();
    }

    private ValRefELVisitor createAndExecuteVisitor(String elText) {
        StringReader reader = new StringReader(elText);
        JSPELParser parser = new JSPELParser((Reader)reader);
        try {
            ASTExpression expr = parser.Expression();
            ValRefELVisitor visitor = new ValRefELVisitor(0, elText);
            expr.jjtAccept((JSPELParserVisitor)visitor, null);
            return visitor;
        }
        catch (ParseException parseException) {
            return null;
        }
        catch (TokenMgrError tokenMgrError) {
            return null;
        }
    }

    @Override
    public List<ValueReferenceELExpr> getExpressionUnescaped(String elExpression) {
        throw new UnsupportedOperationException("Only supported on ValueReferenceELParser2");
    }

    private static enum ELSearchType {
        SIMPLE_ONLY,
        ALL;

    }

    private static class ValRefELVisitor
    implements JSPELParserVisitor {
        private String _symbolPrefix;
        private final List<ValueReferenceELExpr> _valueRefExprs = new ArrayList<ValueReferenceELExpr>(){
            private static final long serialVersionUID = 467566887372648196L;

            @Override
            public void add(int index, ValueReferenceELExpr element) {
                if (element == null) {
                    throw new NullPointerException("element cannot be null");
                }
                super.add(index, element);
            }

            @Override
            public boolean add(ValueReferenceELExpr element) {
                if (element == null) {
                    throw new NullPointerException("element cannot be null");
                }
                return super.add(element);
            }
        };
        private ValueReferenceELExpr _curValueRefExpr;
        private boolean _isSimpleElExpr = true;
        private boolean _isInsideBracket;

        ValRefELVisitor(int relativePos, String fullText) {
        }

        protected final boolean isSimpleElExpr() {
            return this._isSimpleElExpr;
        }

        public List<ValueReferenceELExpr> getValueRefExprs() {
            return this._valueRefExprs;
        }

        public Object visit(ASTValuePrefix node, Object data) {
            if (node.jjtGetNumChildren() == 0 && node.getFirstToken().kind == 47) {
                this._symbolPrefix = node.getFirstToken().image;
                this._curValueRefExpr = new ValueReferenceELExpr(this._symbolPrefix);
            }
            return node.childrenAccept((JSPELParserVisitor)this, data);
        }

        public Object visit(ASTValueSuffix node, Object data) {
            Token lastToken = node.getLastToken();
            if (node.jjtGetNumChildren() == 0) {
                if (node.getFirstToken().kind == 13 && lastToken.kind == 47 && this._curValueRefExpr != null) {
                    this._curValueRefExpr.addPropertyObjectName(lastToken.image);
                }
                return null;
            }
            if (node.getFirstToken().kind == 30) {
                this._isInsideBracket = true;
                node.childrenAccept((JSPELParserVisitor)this, data);
                this._isInsideBracket = false;
                return null;
            }
            return node.childrenAccept((JSPELParserVisitor)this, data);
        }

        public Object visit(ASTValue node, Object data) {
            Object value = node.childrenAccept((JSPELParserVisitor)this, data);
            if (this._curValueRefExpr != null && !this._isInsideBracket) {
                this._valueRefExprs.add(this._curValueRefExpr);
                this._curValueRefExpr = null;
            }
            return value;
        }

        public Object visit(SimpleNode node, Object data) {
            return node.childrenAccept((JSPELParserVisitor)this, data);
        }

        public Object visit(ASTAddExpression node, Object data) {
            this._isSimpleElExpr = false;
            return node.childrenAccept((JSPELParserVisitor)this, data);
        }

        public Object visit(ASTAndExpression node, Object data) {
            this._isSimpleElExpr = false;
            return node.childrenAccept((JSPELParserVisitor)this, data);
        }

        public Object visit(ASTChoiceExpression node, Object data) {
            this._isSimpleElExpr = false;
            return node.childrenAccept((JSPELParserVisitor)this, data);
        }

        public Object visit(ASTEqualityExpression node, Object data) {
            this._isSimpleElExpr = false;
            return node.childrenAccept((JSPELParserVisitor)this, data);
        }

        public Object visit(ASTExpression node, Object data) {
            return node.childrenAccept((JSPELParserVisitor)this, data);
        }

        public Object visit(ASTFunctionInvocation node, Object data) {
            this._isSimpleElExpr = false;
            return node.childrenAccept((JSPELParserVisitor)this, data);
        }

        public Object visit(ASTLiteral node, Object data) {
            if (this._isInsideBracket && node.getFirstToken().kind == 8) {
                if (this._curValueRefExpr != null) {
                    this._curValueRefExpr.addPropertyObjectName(this.stripQuotes(node.getFirstToken().image));
                }
            } else {
                this._isSimpleElExpr = false;
            }
            return node.childrenAccept((JSPELParserVisitor)this, data);
        }

        public Object visit(ASTMultiplyExpression node, Object data) {
            this._isSimpleElExpr = false;
            return node.childrenAccept((JSPELParserVisitor)this, data);
        }

        public Object visit(ASTOrExpression node, Object data) {
            this._isSimpleElExpr = false;
            return node.childrenAccept((JSPELParserVisitor)this, data);
        }

        public Object visit(ASTRelationalExpression node, Object data) {
            this._isSimpleElExpr = false;
            return node.childrenAccept((JSPELParserVisitor)this, data);
        }

        public Object visit(ASTUnaryExpression node, Object data) {
            return node.childrenAccept((JSPELParserVisitor)this, data);
        }

        private String stripQuotes(String stringLiteral) {
            if (stringLiteral.startsWith("'") || stringLiteral.startsWith("\"")) {
                if (stringLiteral.length() > 2) {
                    return stringLiteral.substring(1, stringLiteral.length() - 1);
                }
                return "";
            }
            return stringLiteral;
        }
    }

    public static final class ValueReferenceELExpr {
        private String _modelObjectName;
        private final ArrayList<String> _propertyObjectNames = new ArrayList(5);

        public ValueReferenceELExpr() {
        }

        public ValueReferenceELExpr(String modelObjectName) {
            this();
            this._modelObjectName = modelObjectName;
        }

        public final String getModelObjectName() {
            return this._modelObjectName;
        }

        public void setModelObjectName(String modelObjectName) {
            this._modelObjectName = modelObjectName;
        }

        public final List<String> getPropertyObjectNames() {
            return Collections.unmodifiableList(this._propertyObjectNames);
        }

        public void addPropertyObjectName(String propName) {
            if (propName == null) {
                throw new NullPointerException("propName cannot be null");
            }
            this._propertyObjectNames.add(propName);
        }

        public void trimSize() {
            this._propertyObjectNames.trimToSize();
        }
    }
}

