/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.variables;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.application.common.services.Messages;
import oracle.eclipse.tools.application.common.services.variables.AbstractModelObject;
import oracle.eclipse.tools.application.common.services.variables.DataType;
import oracle.eclipse.tools.application.common.services.variables.IPathProvider;
import oracle.eclipse.tools.application.common.services.variables.JavaResourceBundleDataType;
import oracle.eclipse.tools.application.common.services.variables.MethodInfo;
import oracle.eclipse.tools.application.common.services.variables.MethodReference;
import oracle.eclipse.tools.application.common.services.variables.ValueReferencePath;
import oracle.eclipse.tools.application.common.services.variables.Variable;
import oracle.eclipse.tools.common.services.dependency.artifact.Range;
import oracle.eclipse.tools.common.services.dependency.artifact.ResourceLocation;
import oracle.eclipse.tools.common.services.util.ObjectUtil;
import oracle.eclipse.tools.common.util.StringUtil;
import org.eclipse.jst.jsf.context.IModelContext;

public class ValueReference
extends AbstractModelObject
implements IPathProvider<ValueReferencePath, ValueReference, IModelContext>,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final char COMPLEX_FIELD_SEP = '.';
    private static final byte UNKNOWN_VAR = 1;
    private static final byte FIELD_COMPUTED = 2;
    private final Variable mVar;
    private final String mFieldName;
    private final Range mLocation;
    private DataType.Field mField;
    private byte mFlags;

    public ValueReference(Variable var) {
        this(var, null);
    }

    public ValueReference(Variable var, String fieldName) {
        this(var, fieldName, null);
    }

    public ValueReference(Variable var, String fieldName, Range referenceLocation) {
        this.mVar = var;
        this.mFieldName = fieldName;
        this.mLocation = referenceLocation;
    }

    private ValueReference(ValueReference valReference, int numFields) {
        this.mVar = valReference.mVar;
        if (numFields > 0) {
            String[] fields = valReference.mFieldName.split("\\" + String.valueOf('.'));
            if (numFields > fields.length) {
                throw new ArrayIndexOutOfBoundsException("numFields=" + numFields + ", which is greater than " + fields.length);
            }
            String[] newFields = new String[numFields];
            System.arraycopy(fields, 0, newFields, 0, numFields);
            this.mFieldName = StringUtil.join((String[])newFields, (char)'.');
        } else {
            this.mFieldName = null;
        }
        this.mLocation = valReference.getLocation();
    }

    public Variable getVariable() {
        return this.mVar;
    }

    public String getFieldName() {
        return this.mFieldName;
    }

    public Range getLocation() {
        return this.mLocation;
    }

    public DataType.Field getField(IModelContext modelContext) {
        if (!(this.mFieldName != null && (this.mFlags & 2) == 0 || this.mVar.getType() instanceof JavaResourceBundleDataType)) {
            return this.mField;
        }
        this.mFlags = (byte)(this.mFlags | 2);
        this.mField = null;
        DataType.Field[] fields = this.getFieldPath(modelContext);
        if (fields != null) {
            this.mField = fields[fields.length - 1];
        }
        return this.mField;
    }

    public DataType.Field[] getFieldPath(IModelContext modelContext) {
        if (this.mFieldName == null) {
            return null;
        }
        DataType dt = this.mVar.getType();
        if (dt == null) {
            return null;
        }
        if (dt instanceof JavaResourceBundleDataType || this.mFieldName.indexOf(46) < 0) {
            DataType.Field field = this.getDataTypeField(dt, this.mFieldName, modelContext);
            if (field == null) {
                return null;
            }
            return new DataType.Field[]{field};
        }
        List fieldNames = StringUtil.split((String)this.mFieldName, (char)'.');
        int count = fieldNames.size();
        DataType.Field[] fields = new DataType.Field[count];
        int i = 0;
        while (i < count) {
            String fieldName = (String)fieldNames.get(i);
            DataType.Field field = this.getDataTypeField(dt, fieldName, modelContext);
            if (field == null) {
                return null;
            }
            fields[i] = field;
            dt = field.getType();
            ++i;
        }
        return fields;
    }

    public FieldInfo[] getFieldsInfo(IModelContext context) {
        if (this.mFieldName == null) {
            return null;
        }
        DataType dt = this.mVar.getType();
        if (this.mFieldName.indexOf(46) < 0) {
            FieldInfo fi = new FieldInfo(this.mFieldName, this.getDataTypeField(dt, this.mFieldName, context));
            return new FieldInfo[]{fi};
        }
        List fieldNames = StringUtil.split((String)this.mFieldName, (char)'.');
        int count = fieldNames.size();
        FieldInfo[] fia = new FieldInfo[count];
        int i = 0;
        while (i < count) {
            String fieldName = (String)fieldNames.get(i);
            DataType.Field field = null;
            if (dt != null) {
                field = this.getDataTypeField(dt, fieldName, context);
                dt = field != null ? field.getType() : null;
            }
            fia[i] = new FieldInfo(fieldName, field);
            ++i;
        }
        return fia;
    }

    private DataType.Field getDataTypeField(DataType dt, String fieldName, IModelContext modelContext) {
        DataType.Field field = dt.getField(fieldName, modelContext);
        if (field == null) {
            int index = fieldName.indexOf(91);
            String fixedFieldName = fieldName;
            if (index > 0) {
                fixedFieldName = fixedFieldName.substring(0, index);
                field = dt.getField(fixedFieldName, modelContext);
            }
        }
        return field;
    }

    public DataType getType(IModelContext context) {
        DataType.Field field = this.getField(context);
        if (field != null) {
            return field.getType();
        }
        Variable var = this.getVariable();
        if (var != null) {
            return var.getType();
        }
        return null;
    }

    public boolean isUnknownVar() {
        return (this.mFlags & 1) != 0;
    }

    public void setUnknownVar() {
        this.mFlags = (byte)(this.mFlags | 1);
    }

    public String toString() {
        if (this.mVar == null) {
            return "";
        }
        String varName = this.mVar.getName();
        if (this.mFieldName != null) {
            return String.valueOf(varName) + '.' + this.mFieldName;
        }
        return varName;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ValueReference)) {
            return false;
        }
        ValueReference thatRef = (ValueReference)obj;
        return ObjectUtil.equalObjects((Object)this.mVar, (Object)thatRef.mVar) && ObjectUtil.equalObjects((Object)this.mFieldName, (Object)thatRef.mFieldName) && ObjectUtil.equalObjects((Object)this.mLocation, (Object)thatRef.mLocation);
    }

    public int hashCode() {
        int hash = 0;
        if (this.mVar != null) {
            hash += this.mVar.hashCode();
        }
        if (this.mFieldName != null) {
            hash += 7 * this.mFieldName.hashCode();
        }
        if (this.mLocation != null) {
            hash += 11 * this.mLocation.hashCode();
        }
        return hash;
    }

    public String getDescription() {
        StringBuffer buf = new StringBuffer();
        if (this.mField != null) {
            buf.append(Messages.ValueReference_Name).append(this.mField.getName()).append("\n");
            buf.append(Messages.ValueReference_Type).append(this.mField.getType().getDisplayName(false));
        } else {
            String sourceLoc;
            buf.append(Messages.ValueReference_Name).append(this.mVar.getName()).append("\n");
            buf.append(Messages.ValueReference_Scope).append(this.getScope(this.mVar)).append("\n");
            DataType type = this.mVar.getType();
            if (type != null) {
                buf.append(Messages.ValueReference_Type).append(type.getDisplayName(false));
            }
            if ((sourceLoc = this.getLocation(this.mVar)) != null) {
                buf.append("\n").append(Messages.ValueReference_Source).append(sourceLoc);
            }
        }
        return buf.toString();
    }

    protected String getScope(Variable variable) {
        switch (variable.getScope()) {
            case PAGE_SCOPE: {
                return "page";
            }
            case REQUEST_SCOPE: {
                return "request";
            }
            case SESSION_SCOPE: {
                return "session";
            }
            case APPLICATION_SCOPE: {
                return "application";
            }
            case AT_BEGIN_SCOPE: {
                return "at-begin";
            }
            case AT_END_SCOPE: {
                return "at-end";
            }
            case NESTED_SCOPE: {
                return "nested";
            }
            case ADF_BACKING_BEAN_SCOPE: {
                return "backingBean";
            }
            case ADF_PAGE_SCOPE: {
                return "pageFlow";
            }
            case ADF_VIEW_SCOPE: {
                return "view";
            }
        }
        return "page";
    }

    private String getLocation(Variable variable) {
        ResourceLocation location = variable.getDefinitionLocation();
        if (location == null) {
            return null;
        }
        return location.getResource().getProjectRelativePath().toString();
    }

    public List<ValueReference> getChildFields(IModelContext context) {
        ValueReference ref = this;
        if (ref.getField(context) == null) {
            Variable var = ref.getVariable();
            DataType type = var.getType();
            if (type != null) {
                List<DataType.Field> fields = type.getFields(context);
                ArrayList<ValueReference> fieldRefs = new ArrayList<ValueReference>();
                for (DataType.Field fld : fields) {
                    fieldRefs.add(new ValueReference(var, fld.getName()));
                }
                return fieldRefs;
            }
        } else {
            Variable var = ref.getVariable();
            DataType.Field fld = ref.getField(context);
            List<DataType.Field> fields = fld.getType().getFields(context);
            ArrayList<ValueReference> fieldRefs = new ArrayList<ValueReference>();
            for (DataType.Field afld : fields) {
                fieldRefs.add(new ValueReference(var, String.valueOf(ref.getFieldName()) + '.' + afld.getName()));
            }
            return fieldRefs;
        }
        return Collections.emptyList();
    }

    public ValueReference findChildField(String fieldName, IModelContext context) {
        List<ValueReference> valRefs = this.getChildFields(context);
        for (ValueReference testRef : valRefs) {
            if (!testRef.getField(context).getName().equals(fieldName)) continue;
            return testRef;
        }
        return null;
    }

    @Override
    public ValueReferencePath getNoPath() {
        return ValueReferencePath.NO_PATH;
    }

    @Override
    public ValueReferencePath getPath(ValueReference input, IModelContext context) {
        if (this.getVariable().equals(input.getVariable())) {
            DataType.Field[] fieldPath = input.getFieldPath(context);
            if (fieldPath == null) {
                if (input.getFieldName() == null) {
                    return new ValueReferencePath(Collections.EMPTY_LIST, this, this);
                }
                return this.getNoPath();
            }
            ArrayList<ValueReference> path = new ArrayList<ValueReference>(fieldPath.length + 1);
            ValueReference currentValueReference = this;
            int fieldCount = 1;
            ValueReference currentSearchReference = new ValueReference(input, fieldCount++);
            while (!currentSearchReference.equals(input)) {
                ValueReference findReference = this.matchChildren(currentValueReference, currentSearchReference, context);
                if (findReference == null) {
                    return this.getNoPath();
                }
                path.add(findReference);
                currentValueReference = findReference;
                currentSearchReference = new ValueReference(input, fieldCount++);
            }
            return new ValueReferencePath(path, this, input);
        }
        return this.getNoPath();
    }

    private ValueReference matchChildren(ValueReference currentValueReference, ValueReference currentSearchReference, IModelContext context) {
        for (ValueReference testRef : currentValueReference.getChildFields(context)) {
            if (!testRef.equals(currentSearchReference)) continue;
            return testRef;
        }
        return null;
    }

    public List<MethodReference> getMethodReferences() {
        DataType dt = this.getType(DataType.NullModelContext.getInstance());
        if (dt == DataType.getUnspecifiedType()) {
            return Collections.emptyList();
        }
        ArrayList<MethodReference> methodRefs = new ArrayList<MethodReference>();
        for (MethodInfo mi : dt.getPublicMethods()) {
            methodRefs.add(new MethodReference(this, mi));
        }
        return methodRefs;
    }

    public boolean contains(ValueReference ref) {
        if (this.mVar.equals(ref.getVariable())) {
            int thatFieldsCount;
            FieldInfo[] thisFields = this.getFieldsInfo(DataType.NullModelContext.getInstance());
            FieldInfo[] thatFields = ref.getFieldsInfo(DataType.NullModelContext.getInstance());
            int thisFieldsCount = thisFields != null ? thisFields.length : 0;
            int n = thatFieldsCount = thatFields != null ? thatFields.length : 0;
            if (thisFieldsCount == 0) {
                return true;
            }
            if (thatFieldsCount >= thisFieldsCount && thisFields != null && thatFields != null) {
                int i = 0;
                while (i < thisFields.length) {
                    FieldInfo thisField = thisFields[i];
                    FieldInfo thatField = thatFields[i];
                    if (!thisField.mFieldName.equals(thatField.mFieldName)) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
        }
        return false;
    }

    public static class FieldInfo {
        public String mFieldName;
        public DataType.Field mField;

        FieldInfo(String fieldName) {
            this.mFieldName = fieldName;
        }

        FieldInfo(String fieldName, DataType.Field field) {
            this.mFieldName = fieldName;
            this.mField = field;
        }
    }
}

