/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.variables;

import oracle.eclipse.tools.application.common.services.Activator;
import oracle.eclipse.tools.application.common.services.variables.DataType;
import oracle.eclipse.tools.application.common.services.variables.ResolutionTime;
import oracle.eclipse.tools.application.common.services.variables.Variable;
import oracle.eclipse.tools.common.services.dependency.artifact.Range;
import oracle.eclipse.tools.common.services.dependency.artifact.ResourceLocation;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;

public class NestedVariableWithLocation
extends Variable {
    private static final long serialVersionUID = 1L;

    public NestedVariableWithLocation(String name, DataType type, Variable.SCOPE scope, ResolutionTime resolutionTime, ResourceLocation definitionLocation, ResourceLocation locationInBaseSourceFile) {
        super(name, type, scope, resolutionTime, definitionLocation, locationInBaseSourceFile);
    }

    @Override
    public boolean isInScope(int absOffset) {
        IMarker marker = this.getMarker();
        if (marker != null) {
            Integer endOffset;
            Integer startOffset;
            try {
                startOffset = (Integer)marker.getAttribute("charStart");
                endOffset = (Integer)marker.getAttribute("charEnd");
            }
            catch (CoreException e) {
                LoggingService.logException((Plugin)Activator.getDefault(), (CoreException)e);
                return true;
            }
            Range range = new Range((long)startOffset.intValue(), (long)(endOffset - startOffset));
            if (this.getScope() == Variable.SCOPE.NESTED_SCOPE) {
                return range.contains((long)absOffset);
            }
        }
        return true;
    }
}

