/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.variables;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.application.common.services.appservices.IDatatypeProvider;
import oracle.eclipse.tools.application.common.services.techextservices.IDataTypeIntrospector;
import oracle.eclipse.tools.application.common.services.variables.AnnotationInfo;
import oracle.eclipse.tools.application.common.services.variables.DataType;
import oracle.eclipse.tools.application.common.services.variables.JDTDataType;
import oracle.eclipse.tools.common.services.project.Project;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.Signature;

public class MethodInfo {
    private String _name;
    private DataType _retType;
    private List<DataType> _paramTypes;
    private List<String> _paramNames;
    private IDataTypeIntrospector _introspector;
    private IDatatypeProvider _dtProvider;
    private List<AnnotationInfo> _annotations;
    private Integer _modifiers;
    private DataType _declaringType;
    public static final String UNSPECIFIED_METHOD_NAME = "_unspec_";

    public MethodInfo(Project project, String methodName, String returnType, String[] paramTypes) {
        this(project, returnType, paramTypes);
        this._name = methodName;
    }

    public MethodInfo(IProject project, String methodName, String returnType, String[] paramTypes) {
        this((Project)project.getAdapter(Project.class), methodName, returnType, paramTypes);
    }

    public MethodInfo(Project project, String returnType, String[] paramTypes) {
        this._dtProvider = (IDatatypeProvider)project.getAppService(IDatatypeProvider.class);
        this._retType = this.getDataType(returnType);
        this._paramTypes = this.getMethodParamTypes(paramTypes);
        this._name = UNSPECIFIED_METHOD_NAME;
    }

    public MethodInfo(IDataTypeIntrospector introspector, JDTDataType declaringType, String methodName, String returnType, String[] paramTypes, String[] paramNames, List<AnnotationInfo> annotations, Integer modifierFlags) {
        this._introspector = introspector;
        this._retType = this.getDataType(returnType);
        this._paramTypes = this.getMethodParamTypes(paramTypes);
        this._paramNames = this.getMethodParamNames(paramNames);
        this._name = methodName;
        this._declaringType = declaringType;
        this._modifiers = modifierFlags;
        this._annotations = annotations;
    }

    public MethodInfo(MethodInfo mi) {
        this._name = mi.getMethodName();
        this._retType = this.getReturnedType();
        this._paramTypes = mi.getParameterTypes();
        this._paramNames = mi.getParamNames();
    }

    public MethodInfo(IDataTypeIntrospector introspector, Method method) {
        this._name = method.getName();
        this._introspector = introspector;
        this._retType = this.getDataType(method.getReturnType().getName());
        this._paramTypes = this.getMethodParamTypes(this.getParamClassNames(method.getParameterTypes()));
    }

    private String[] getParamClassNames(Class<?>[] parameterTypes) {
        String[] paramTypeNames = new String[parameterTypes.length];
        int i = 0;
        while (i < parameterTypes.length) {
            paramTypeNames[i] = parameterTypes[i].getName();
            ++i;
        }
        return paramTypeNames;
    }

    private DataType getDataType(String typeName) {
        if (this._introspector != null) {
            return this._introspector.introspect(typeName, null);
        }
        return this._dtProvider.getDataType(typeName, null);
    }

    private List<DataType> getMethodParamTypes(String[] paramTypes) {
        ArrayList<DataType> ret = new ArrayList<DataType>();
        String[] stringArray = paramTypes;
        int n = paramTypes.length;
        int n2 = 0;
        while (n2 < n) {
            String param = stringArray[n2];
            DataType dt = this.getDataType(param);
            if (dt != null) {
                ret.add(dt);
            }
            ++n2;
        }
        return ret;
    }

    private List<String> getMethodParamNames(String[] paramNames) {
        ArrayList<String> ret = new ArrayList<String>();
        String[] stringArray = paramNames;
        int n = paramNames.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            ret.add(name);
            ++n2;
        }
        return ret;
    }

    public String getMethodName() {
        return this._name != null ? this._name : UNSPECIFIED_METHOD_NAME;
    }

    public void setMethodName(String name) {
        this._name = name;
    }

    public DataType getReturnedType() {
        return this._retType;
    }

    public List<DataType> getParameterTypes() {
        return this._paramTypes;
    }

    public void setParameterNames(List<String> names) {
        assert (names == null || names.size() == this.getParameterTypes().size());
        this._paramNames = names;
    }

    public List<String> getParamNames() {
        if (this._paramNames == null && !this._paramTypes.isEmpty()) {
            this._paramNames = new ArrayList<String>(this._paramTypes.size());
            int i = 0;
            while (i < this._paramTypes.size()) {
                StringBuffer buf = new StringBuffer("p").append(i);
                this._paramNames.add(buf.toString());
                ++i;
            }
        }
        return this._paramNames;
    }

    public String getDisplaySignature(boolean fullParamTypes) {
        StringBuffer buffer = new StringBuffer();
        return buffer.toString();
    }

    public String getSignature() {
        String returnType = null;
        returnType = this._retType != null && !this._retType.isUnknown() ? this.safeGetSignature(this._retType) : "V";
        ArrayList<String> argTypes = new ArrayList<String>();
        for (DataType argType : this._paramTypes) {
            argTypes.add(this.safeGetSignature(argType));
        }
        return Signature.createMethodSignature((String[])argTypes.toArray(new String[0]), (String)returnType);
    }

    private String safeGetSignature(DataType dataType) {
        String returnType = dataType.getName();
        if (Signature.getArrayCount((String)returnType) == 0) {
            returnType = Signature.createTypeSignature((String)dataType.getName(), (boolean)true);
        }
        return returnType;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(this._retType.getName());
        buf.append(" ").append(this._name).append("(");
        int i = 0;
        for (DataType pType : this._paramTypes) {
            String pname = pType.getName();
            buf.append(pname).append(" ");
            if (this._paramNames != null && this._paramNames.size() == this._paramTypes.size()) {
                buf.append(this._paramNames.get(i));
            } else {
                buf.append("p").append(i);
            }
            if (i < this._paramTypes.size() - 1) {
                buf.append(",");
            }
            ++i;
        }
        buf.replace(buf.length(), buf.length(), ")");
        return buf.toString();
    }

    public String getLabel() {
        StringBuffer buf = new StringBuffer(this._retType.getDisplayName(true));
        buf.append(" ").append(this._name).append("(");
        int i = 0;
        for (DataType pType : this._paramTypes) {
            String pname = pType.getDisplayName(true);
            buf.append(pname).append(" ");
            if (this._paramNames != null && this._paramNames.size() == this._paramTypes.size()) {
                buf.append(this._paramNames.get(i));
            } else {
                buf.append("p").append(i);
            }
            if (i < this._paramTypes.size() - 1) {
                buf.append(",");
            }
            ++i;
        }
        buf.replace(buf.length(), buf.length(), ")");
        return buf.toString();
    }

    public int getModifiers() {
        return this._modifiers;
    }

    public DataType getDeclaringDataType() {
        return this._declaringType;
    }

    public List<AnnotationInfo> getAnnotations() {
        if (this._annotations != null) {
            return Collections.unmodifiableList(this._annotations);
        }
        return Collections.emptyList();
    }

    public boolean isAnnotationPresent(Class<?> klass) {
        for (AnnotationInfo anno : this.getAnnotations()) {
            if (!anno.getName().equals(klass.getName())) continue;
            return true;
        }
        return false;
    }

    public <T> T getAnnotation(Class<T> klass) {
        this.isAnnotationPresent(klass);
        return null;
    }
}

