/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.variables;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import oracle.eclipse.tools.application.common.services.appservices.IBundleResource;
import oracle.eclipse.tools.application.common.services.appservices.IDatatypeProvider;
import oracle.eclipse.tools.application.common.services.techextservices.IDataTypeIntrospector;
import oracle.eclipse.tools.application.common.services.util.LocalizeUtil;
import oracle.eclipse.tools.application.common.services.variables.DataType;
import oracle.eclipse.tools.application.common.services.variables.JavaDataType;
import oracle.eclipse.tools.common.services.document.IFilePositionContext;
import oracle.eclipse.tools.common.services.project.Project;
import oracle.eclipse.tools.common.services.util.HashCodeUtil;
import oracle.eclipse.tools.common.services.util.ObjectUtil;
import oracle.eclipse.tools.common.services.util.SerializationUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jst.jsf.context.IModelContext;

public final class JavaResourceBundleDataType
extends JavaDataType
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String _baseName;
    private final transient DataType _type;

    public JavaResourceBundleDataType(IDataTypeIntrospector introspector, Project project, String baseName) {
        super("java.util.Map", project);
        this._type = introspector.introspect("java.lang.String", Collections.EMPTY_SET);
        this._baseName = baseName;
    }

    @Override
    public DataType getComponentType() {
        return this._type;
    }

    @Override
    public ResourceBundleField getField(String fieldName, IModelContext modelContext) {
        List<DataType.Field> fields = this.getFields(modelContext);
        int i = 0;
        int n = fields.size();
        while (i < n) {
            DataType.Field field = fields.get(i);
            if (field instanceof ResourceBundleField && field.getName().equals(fieldName)) {
                return (ResourceBundleField)field;
            }
            ++i;
        }
        return null;
    }

    @Override
    public void setLoaded(boolean loaded) {
        super.setLoaded(loaded);
    }

    @Override
    public void addField(DataType.Field field) {
        throw new UnsupportedOperationException("This method is not supported in Java Resource Bundle DataTypes.");
    }

    @Override
    public List<DataType.Field> getFields(IModelContext modelContext) {
        ArrayList<ResourceBundleField> fields = new ArrayList<ResourceBundleField>();
        IBundleResource bundleResource = this.getBundleResource(modelContext);
        if (bundleResource != null) {
            ResourceBundle bundle = bundleResource.loadBundle();
            if (bundle != null) {
                Enumeration<String> keyIt = bundle.getKeys();
                while (keyIt.hasMoreElements()) {
                    String keyName = keyIt.nextElement();
                    String value = bundle.getString(keyName);
                    fields.add(new ResourceBundleField(keyName, this._type, value));
                }
            }
            return Collections.unmodifiableList(fields);
        }
        return Collections.EMPTY_LIST;
    }

    public Map<String, String> getFieldsAsMap(IModelContext context) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (DataType.Field field : this.getFields(context)) {
            map.put(field.getName(), ((ResourceBundleField)field).getValue());
        }
        return map;
    }

    public Locale getLocale(IModelContext modelContext) {
        ResourceBundle bundle;
        IBundleResource bundleResource = this.getBundleResource(modelContext);
        if (bundleResource != null && (bundle = bundleResource.loadBundle()) != null) {
            return bundle.getLocale();
        }
        return null;
    }

    public String getBaseName() {
        return this._baseName;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JavaResourceBundleDataType)) {
            return false;
        }
        JavaResourceBundleDataType thatType = (JavaResourceBundleDataType)obj;
        if (!ObjectUtil.equalObjects((Object)this.getBaseName(), (Object)thatType.getBaseName())) {
            return false;
        }
        return this.getFields(DataType.NullModelContext.getInstance()).equals(thatType.getFields(DataType.NullModelContext.getInstance()));
    }

    @Override
    public int hashCode() {
        HashCodeUtil hcu = HashCodeUtil.newInstance();
        String baseName = this.getBaseName();
        hcu.hash((Object)baseName);
        hcu.hash(this.getFields(DataType.NullModelContext.getInstance()));
        return hcu.getHashCode();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        SerializationUtil su = SerializationUtil.forOutput((ObjectOutputStream)out);
        su.writeResource((IResource)this.getProject().getEclipseProject());
        out.writeObject(this._baseName);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException, IllegalArgumentException, IllegalAccessException {
        SerializationUtil su = SerializationUtil.forInput((ObjectInputStream)in);
        IProject iProject = su.readProject();
        su.readFinalFieldFromStream((Object)this, "_baseName", String.class);
        if (iProject == null) {
            throw new IllegalStateException("Stream refers to null project.");
        }
        Project project = (Project)iProject.getAdapter(Project.class);
        if (project == null) {
            throw new IllegalStateException("Unknown project reference in stream.");
        }
        IDatatypeProvider dtp = (IDatatypeProvider)project.getAppService(IDatatypeProvider.class);
        if (dtp == null) {
            throw new IllegalStateException("Unable to adapt project to data type provider.");
        }
        IDataTypeIntrospector introspector = dtp.getIntrospector();
        if (introspector == null) {
            throw new IllegalStateException("Unable to data type information.");
        }
        su.setFinalField((Object)this, "_type", DataType.class, (Object)introspector.introspect("java.lang.String", null));
    }

    public IBundleResource getBundleResource(IModelContext modelContext) {
        IFilePositionContext docContext;
        if (modelContext != null && (docContext = (IFilePositionContext)modelContext.getAdapter(IFilePositionContext.class)) != null) {
            return LocalizeUtil.INSTANCE.getBundleResource(docContext, this._baseName);
        }
        return null;
    }

    public static final class ResourceBundleField
    extends JavaDataType.JavaField {
        private static final long serialVersionUID = -6815821327064533749L;
        private final String _value;

        public ResourceBundleField(String name, DataType type, String value) {
            super(name, type, null, null);
            this._value = value;
        }

        @Override
        public String getReadMethodName() {
            throw new UnsupportedOperationException("bundle fields have no read methods");
        }

        public final String getValue() {
            return this._value;
        }

        @Override
        public boolean equals(Object other) {
            if (other instanceof ResourceBundleField) {
                ResourceBundleField otherField = (ResourceBundleField)other;
                String name = this.getName();
                DataType type = this.getType();
                return (name == null ? otherField.getName() == null : name.equals(otherField.getName())) && (this._value == null ? otherField._value == null : this._value.equals(otherField._value)) && (type == null ? otherField.getType() == null : type.equals(otherField.getType()));
            }
            return false;
        }

        @Override
        public int hashCode() {
            HashCodeUtil hcu = HashCodeUtil.newInstance();
            hcu.hash((Object)this.getName());
            hcu.hash((Object)this.getType());
            hcu.hash((Object)this._value);
            return hcu.getHashCode();
        }
    }
}

