/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.variables;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import oracle.eclipse.tools.application.common.services.appservices.IAppClassLoaderProvider;
import oracle.eclipse.tools.application.common.services.appservices.IDatatypeProvider;
import oracle.eclipse.tools.application.common.services.techextservices.IDataTypeIntrospector;
import oracle.eclipse.tools.application.common.services.variables.DataType;
import oracle.eclipse.tools.common.services.project.Project;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;

public class JavaDataType
extends DataType {
    private static final long serialVersionUID = 1L;
    private transient IDatatypeProvider _dataTypeProvider = null;
    private static Map<String, String> mPrimitiveToClassMap = new HashMap<String, String>(8);
    private static Map<String, String> mQualifiedMap;

    static {
        mPrimitiveToClassMap.put(Integer.TYPE.getName(), Integer.class.getName());
        mPrimitiveToClassMap.put(Boolean.TYPE.getName(), Boolean.class.getName());
        mPrimitiveToClassMap.put(Character.TYPE.getName(), Character.class.getName());
        mPrimitiveToClassMap.put(Float.TYPE.getName(), Float.class.getName());
        mPrimitiveToClassMap.put(Double.TYPE.getName(), Double.class.getName());
        mPrimitiveToClassMap.put(Byte.TYPE.getName(), Byte.class.getName());
        mPrimitiveToClassMap.put(Short.TYPE.getName(), Short.class.getName());
        mPrimitiveToClassMap.put(Long.TYPE.getName(), Long.class.getName());
        mQualifiedMap = new HashMap<String, String>(12);
        mQualifiedMap.put("Integer", Integer.class.getName());
        mQualifiedMap.put("Boolean", Boolean.class.getName());
        mQualifiedMap.put("Character", Character.class.getName());
        mQualifiedMap.put("Float", Float.class.getName());
        mQualifiedMap.put("Double", Double.class.getName());
        mQualifiedMap.put("Byte", Byte.class.getName());
        mQualifiedMap.put("Short", Short.class.getName());
        mQualifiedMap.put("Long", Long.class.getName());
        mQualifiedMap.put("Number", Number.class.getName());
        mQualifiedMap.put("String", String.class.getName());
        mQualifiedMap.put("StringBuffer", StringBuffer.class.getName());
        mQualifiedMap.put("Object", Object.class.getName());
    }

    public JavaDataType(String typeName, Project _project) {
        super(null, typeName, _project);
    }

    public JavaDataType(IDataTypeIntrospector introspector, String typeName, Project _project) {
        super(introspector, typeName, _project);
    }

    @Override
    public boolean isUpdatable() {
        if (this.getProject() != null) {
            IJavaProject jProj = JavaCore.create((IProject)this.getProject().getEclipseProject());
            try {
                ICompilationUnit cu;
                IType type = jProj.findType(this.getName());
                if (type != null && (cu = type.getCompilationUnit()) != null && !cu.isReadOnly() && type.getResource().isAccessible() && !type.getResource().getResourceAttributes().isReadOnly()) {
                    return true;
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        return false;
    }

    protected static short computeTypeFlags(String type) {
        short flags = 0;
        if (type.equals(String.class.getName())) {
            flags = (short)(flags | 0x40);
        } else if (type.equals(Boolean.class.getName()) || type.equals(Boolean.TYPE.getName())) {
            flags = (short)(flags | 0x20);
        } else if (type.equals(Integer.class.getName()) || type.equals(Integer.TYPE.getName()) || type.equals(Float.class.getName()) || type.equals(Float.TYPE.getName()) || type.equals(Double.class.getName()) || type.equals(Double.TYPE.getName()) || type.equals(Short.class.getName()) || type.equals(Short.TYPE.getName()) || type.equals(Long.class.getName()) || type.equals(Long.TYPE.getName()) || type.equals(Byte.class.getName()) || type.equals(Byte.TYPE.getName()) || type.equals(Number.class.getName())) {
            flags = (short)(flags | 0x10);
        }
        return flags;
    }

    @Override
    public boolean isSubClass(String superClassName) {
        if (superClassName == null) {
            return false;
        }
        if (this.isPrimitiveType() || JavaDataType.isPrimitive(superClassName)) {
            return false;
        }
        if (this.getName().equals(superClassName)) {
            return true;
        }
        IAppClassLoaderProvider loaderProvider = null;
        try (IAppClassLoaderProvider.IClassLoader loader = null;){
            String n;
            Class<?> typeClass;
            try {
                loaderProvider = (IAppClassLoaderProvider)this.getProject().getAppService(IAppClassLoaderProvider.class);
                loader = loaderProvider.getAppClassLoader();
                typeClass = loader.loadClass(this.getName());
            }
            catch (Throwable throwable) {
                if (loader != null) {
                    loader.close();
                }
                return false;
            }
            do {
                if ((typeClass = typeClass.getSuperclass()) != null) continue;
                return false;
            } while (!(n = typeClass.getName()).equals(superClassName));
            return true;
        }
    }

    @Override
    public boolean isAssignableFrom(String superClassName) {
        if (superClassName == null) {
            return false;
        }
        assert (!this.isPrimitiveType() && !JavaDataType.isPrimitive(superClassName));
        if (this.getName().equals(superClassName)) {
            return true;
        }
        IAppClassLoaderProvider loaderProvider = null;
        try (IAppClassLoaderProvider.IClassLoader loader = null;){
            Class<?> superTypeClass;
            Class<?> typeClass;
            try {
                loaderProvider = (IAppClassLoaderProvider)this.getProject().getAppService(IAppClassLoaderProvider.class);
                loader = loaderProvider.getAppClassLoader();
                typeClass = loader.loadClass(this.getName());
                superTypeClass = loader.loadClass(superClassName);
            }
            catch (Throwable throwable) {
                if (loader != null) {
                    loader.close();
                }
                return false;
            }
            boolean bl = superTypeClass.isAssignableFrom(typeClass);
            return bl;
        }
    }

    @Override
    public boolean isMatchable(DataType otherType) {
        if (this.isArray() && !otherType.isArray() || !this.isArray() && otherType.isArray()) {
            return false;
        }
        if (this.isPrimitiveType() || otherType.isPrimitiveType()) {
            if (otherType.isBoolean() && this.isBoolean()) {
                return true;
            }
            if (otherType.isNumeric() && this.isNumeric()) {
                return true;
            }
            if (otherType.getDisplayName(false).equals(Character.TYPE.getName()) && this.getDisplayName(false).equals(Character.TYPE.getName())) {
                return true;
            }
        } else {
            if (otherType.isSubClass(this.getName())) {
                return true;
            }
            if (otherType.isAssignableFrom(this.getName())) {
                return true;
            }
        }
        return false;
    }

    private Iterator<Class<?>> getSuperTypes() {
        IAppClassLoaderProvider loaderProvider = null;
        try (IAppClassLoaderProvider.IClassLoader loader = null;){
            Class<?> typeClass;
            try {
                loaderProvider = (IAppClassLoaderProvider)this.getProject().getAppService(IAppClassLoaderProvider.class);
                loader = loaderProvider.getAppClassLoader();
                typeClass = loader.loadClass(this.getName());
            }
            catch (ClassNotFoundException classNotFoundException) {
                Iterator<Class<?>> iterator = Collections.EMPTY_LIST.iterator();
                if (loader != null) {
                    loader.close();
                }
                return iterator;
            }
            ArrayList superClasses = new ArrayList();
            while ((typeClass = typeClass.getSuperclass()) != null) {
                superClasses.add(typeClass);
            }
            Iterator<Class<?>> iterator = superClasses.iterator();
            return iterator;
        }
    }

    private Iterator<Class<?>> getInterfaces() {
        IAppClassLoaderProvider loaderProvider = null;
        try (IAppClassLoaderProvider.IClassLoader loader = null;){
            Class<?> typeClass;
            try {
                loaderProvider = (IAppClassLoaderProvider)this.getProject().getAppService(IAppClassLoaderProvider.class);
                loader = loaderProvider.getAppClassLoader();
                typeClass = loader.loadClass(this.getName());
            }
            catch (ClassNotFoundException classNotFoundException) {
                Iterator<Class<?>> iterator = Collections.EMPTY_LIST.iterator();
                if (loader != null) {
                    loader.close();
                }
                return iterator;
            }
            ArrayList interfaces = new ArrayList();
            interfaces.addAll(Arrays.asList(typeClass.getInterfaces()));
            Iterator<Class<?>> superTypes = this.getSuperTypes();
            while (superTypes.hasNext()) {
                interfaces.addAll(Arrays.asList(superTypes.next().getInterfaces()));
            }
            Iterator<Class<?>> iterator = interfaces.iterator();
            return iterator;
        }
    }

    @Override
    protected void addSuperClassSignatures(Set<String> superClasses) {
        super.acquireLock();
        try {
            Iterator<Class<?>> superTypes = this.getSuperTypes();
            this.addSignatures(superTypes, superClasses);
        }
        finally {
            super.releaseLock();
        }
    }

    @Override
    protected void addSuperInterfaceSignatures(Set<String> interfaces) {
        super.acquireLock();
        try {
            Iterator<Class<?>> superTypes = this.getInterfaces();
            this.addSignatures(superTypes, interfaces);
        }
        finally {
            super.releaseLock();
        }
    }

    private void addSignatures(Iterator<Class<?>> clazzes, Set<String> signatures) {
        while (clazzes.hasNext()) {
            Class<?> clazz = clazzes.next();
            String name = clazz.getName();
            if (Signature.getArrayCount((String)name) == 0) {
                name = Signature.createTypeSignature((String)name, (boolean)true);
            }
            signatures.add(name);
        }
    }

    public static boolean isPrimitive(String typeName) {
        return mPrimitiveToClassMap.get(typeName) != null;
    }

    @Override
    public boolean isPrimitiveType() {
        return JavaDataType.isPrimitive(this.getName());
    }

    public void associateClass(Class c, DataType genericsComponentType) {
        block14: {
            this.acquireLock();
            try {
                if (this.isAssociated()) {
                    return;
                }
                this.setAssociated();
                IDatatypeProvider dtprovider = this.getDatatypeProvider(genericsComponentType);
                if (c.isArray()) {
                    if (dtprovider != null) {
                        DataType componentType = dtprovider.getDataType(c.getComponentType().getName(), null);
                        this.setArray(componentType);
                    } else {
                        LoggingService.logError((String)"oracle.eclipse.tools.application.common.services", (String)("No DataTypeProvider (c.isArray() :" + c.getName()));
                    }
                    break block14;
                }
                if (c.isEnum() || c == Enum.class) {
                    this.setEnum(true);
                }
                if (Map.class.isAssignableFrom(c)) {
                    this.setEnumerable(genericsComponentType != null ? genericsComponentType : this.getDataTypeIntrospector().introspect("java.util.Map$Entry", null));
                    this.setUnknownFields();
                    break block14;
                }
                if (JavaDataType.isEnumerableClass(c)) {
                    this.setEnumerable(genericsComponentType);
                    break block14;
                }
                if (Date.class.isAssignableFrom(c)) {
                    this.setDate();
                    break block14;
                }
                Class<?>[] interfaces = c.getInterfaces();
                int i = 0;
                while (i < interfaces.length) {
                    if (interfaces[i].getName().equals("org.apache.commons.beanutils.DynaBean")) {
                        this.setUnknownFields();
                        break;
                    }
                    ++i;
                }
            }
            finally {
                this.releaseLock();
            }
        }
    }

    private IDatatypeProvider getDatatypeProvider(DataType genericsComponentType) {
        this.acquireLock();
        try {
            if (this._dataTypeProvider == null) {
                if (this.getProject() != null) {
                    this._dataTypeProvider = (IDatatypeProvider)this.getProject().getAppService(IDatatypeProvider.class);
                } else if (genericsComponentType != null && genericsComponentType.getProject() != null) {
                    IDatatypeProvider iDatatypeProvider = (IDatatypeProvider)genericsComponentType.getProject().getAppService(IDatatypeProvider.class);
                    return iDatatypeProvider;
                }
            }
            IDatatypeProvider iDatatypeProvider = this._dataTypeProvider;
            return iDatatypeProvider;
        }
        finally {
            this.releaseLock();
        }
    }

    public static boolean isEnumerableClass(Class<?> cl) {
        return Collection.class.isAssignableFrom(cl) || Enumeration.class.isAssignableFrom(cl) || Iterator.class.isAssignableFrom(cl) || Map.class.isAssignableFrom(cl);
    }

    public static String qualify(String className) {
        String qt = mQualifiedMap.get(className);
        if (qt == null) {
            qt = className;
        }
        return qt;
    }

    public static String unQualifyImplicit(String className) {
        String fixedClassName = className;
        if (fixedClassName.startsWith("java.lang.")) {
            fixedClassName = fixedClassName.substring("java.lang.".length());
        }
        return fixedClassName;
    }

    public static String signatureToJniName(String typeName) {
        int index = typeName.indexOf("[]");
        if (index <= 0) {
            return typeName;
        }
        String componentTypeName = typeName.substring(0, index);
        if (componentTypeName.equals("boolean")) {
            return "[Z";
        }
        if (componentTypeName.equals("byte")) {
            return "[B";
        }
        if (componentTypeName.equals("char")) {
            return "[C";
        }
        if (componentTypeName.equals("double")) {
            return "[D";
        }
        if (componentTypeName.equals("float")) {
            return "[F";
        }
        if (componentTypeName.equals("int")) {
            return "[I";
        }
        if (componentTypeName.equals("long")) {
            return "[J";
        }
        if (componentTypeName.equals("short")) {
            return "[S";
        }
        return "[L" + componentTypeName + ';';
    }

    public static String jniToSignatureName(String typeName) {
        int len = typeName.length();
        if (typeName.charAt(0) != '[') {
            return typeName;
        }
        String componentTypeName = null;
        if (typeName.charAt(len - 1) == ';') {
            if (len > 3 && typeName.charAt(1) == 'L') {
                componentTypeName = typeName.substring(2, len - 1);
            }
        } else if (len == 2) {
            switch (typeName.charAt(1)) {
                case 'Z': {
                    componentTypeName = "boolean";
                    break;
                }
                case 'B': {
                    componentTypeName = "byte";
                    break;
                }
                case 'C': {
                    componentTypeName = "char";
                    break;
                }
                case 'D': {
                    componentTypeName = "double";
                    break;
                }
                case 'F': {
                    componentTypeName = "float";
                    break;
                }
                case 'I': {
                    componentTypeName = "int";
                    break;
                }
                case 'J': {
                    componentTypeName = "long";
                    break;
                }
                case 'S': {
                    componentTypeName = "short";
                }
            }
        }
        if (componentTypeName == null) {
            return typeName;
        }
        return String.valueOf(componentTypeName) + "[]";
    }

    public static String displayName(String typeName) {
        return JavaDataType.unQualifyImplicit(typeName);
    }

    private Object readResolve() {
        IDatatypeProvider dtp;
        Project project = this.getProject();
        if (project != null && (dtp = (IDatatypeProvider)project.getAppService(IDatatypeProvider.class)) != null) {
            DataType type;
            IDataTypeIntrospector instrospector = dtp.getIntrospector();
            if (instrospector != null && (type = instrospector.introspect(this.getName(), null)) instanceof JavaDataType) {
                return type;
            }
            if (this._dataTypeProvider == null) {
                this._dataTypeProvider = dtp;
            }
        }
        return this;
    }

    public static class JavaField
    extends DataType.Field {
        private static final long serialVersionUID = 1L;
        private final String mReadMethodName;
        private final String mWriteMethodName;

        public JavaField(String name, DataType type, String readMethodName, String writeMethodName) {
            super(name, type);
            this.mReadMethodName = readMethodName;
            this.mWriteMethodName = writeMethodName;
        }

        public String getReadMethodName() {
            return this.mReadMethodName;
        }

        public String getWriteMethodName() {
            return this.mWriteMethodName;
        }

        public boolean isReadable() {
            return this.mReadMethodName != null;
        }

        public boolean isWritable() {
            return this.mWriteMethodName != null;
        }

        @Override
        public boolean equals(Object other) {
            if (other instanceof JavaField && super.equals(other)) {
                JavaField otherField = (JavaField)other;
                String readMethodName = this.getReadMethodName();
                String otherReadMethodName = otherField.getReadMethodName();
                String writeMethodName = this.getWriteMethodName();
                String otherWriteMethodName = otherField.getWriteMethodName();
                return (readMethodName == null ? otherReadMethodName == null : readMethodName.equals(otherReadMethodName)) && (writeMethodName == null ? otherWriteMethodName == null : writeMethodName.equals(otherWriteMethodName));
            }
            return false;
        }

        @Override
        public int hashCode() {
            String readMethodName = this.getReadMethodName();
            String writeMethodName = this.getWriteMethodName();
            int result = super.hashCode();
            result = 37 * result + (readMethodName == null ? 0 : readMethodName.hashCode());
            result = 37 * result + (writeMethodName == null ? 0 : writeMethodName.hashCode());
            return result;
        }
    }
}

