/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.variables;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import oracle.eclipse.tools.application.common.services.variables.IVariablesCache;
import org.eclipse.core.resources.IResource;

public interface IVariablesListener {
    public void refresh(VariableChangeEvent var1);

    public static class VariableChangeEvent
    extends EventObject {
        public static final Collection<Cause> AllVariableChange = Collections.unmodifiableSet(new HashSet<Cause>(Arrays.asList(Cause.VARIABLE, Cause.REFERENCE)));
        public static final Collection<Cause> VariableChange = Collections.singleton(Cause.VARIABLE);
        public static final Collection<Cause> ReferenceChange = Collections.singleton(Cause.REFERENCE);
        public static final Collection<CacheType> AllCaches = Collections.unmodifiableSet(new HashSet<CacheType>(Arrays.asList(CacheType.LIVE, CacheType.PERSISTENT)));
        public static final Collection<CacheType> LiveCache = Collections.singleton(CacheType.LIVE);
        public static final Collection<CacheType> PersistentCache = Collections.singleton(CacheType.PERSISTENT);
        private final Collection<Cause> _cause;
        private final IResource _context;
        private final Collection<CacheType> _cacheType;
        private final IVariablesCache _cache;
        private static final long serialVersionUID = 1464384326972351109L;

        static {
            if (Cause.values().length != AllVariableChange.size()) {
                throw new AssertionError((Object)"AllVariableChange must contain all Cause values");
            }
            if (CacheType.values().length != AllCaches.size()) {
                throw new AssertionError((Object)"AllCaches must contain all CacheType values");
            }
        }

        public VariableChangeEvent(Object source, IResource context, Collection<CacheType> cacheType, Collection<Cause> cause, IVariablesCache cache) {
            super(source);
            if (cause.isEmpty() || cacheType.isEmpty()) {
                throw new AssertionError((Object)"Neither cause nor cache type may be empty");
            }
            this._context = context;
            this._cacheType = cacheType;
            this._cause = cause;
            this._cache = cache;
        }

        public Collection<Cause> getCauses() {
            return Collections.unmodifiableCollection(this._cause);
        }

        public IResource getContext() {
            return this._context;
        }

        public Collection<CacheType> getCacheType() {
            return Collections.unmodifiableCollection(this._cacheType);
        }

        public IVariablesCache getCache() {
            return this._cache;
        }

        public boolean isCauseOnly(Cause cause) {
            return this.containsOnly(cause, this._cause);
        }

        public boolean isCacheOnly(CacheType cache) {
            return this.containsOnly(cache, this._cacheType);
        }

        protected final <T> boolean containsOnly(T value, Collection<T> values) {
            return values.size() == 1 && values.contains(value);
        }

        public static enum CacheType {
            LIVE,
            PERSISTENT;

        }

        public static enum Cause {
            VARIABLE,
            REFERENCE;

        }
    }
}

