/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.variables;

import oracle.eclipse.tools.application.common.services.util.BeanUtil;
import oracle.eclipse.tools.application.common.services.variables.AbstractModelObject;
import oracle.eclipse.tools.application.common.services.variables.ComponentGenerationInfo;
import oracle.eclipse.tools.application.common.services.variables.IComponentGenerationInfoProvider;
import oracle.eclipse.tools.application.common.services.variables.ValueReference;
import oracle.eclipse.tools.common.services.document.FilePositionContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.jst.jsf.context.IModelContext;

public class FieldGenerationInfo
extends AbstractModelObject {
    private static final long serialVersionUID = -3852036587348716638L;
    private ValueReference _valRef;
    private ComponentGenerationInfo _compGenInfo;
    private String _label;
    private IComponentGenerationInfoProvider _compInfoProvider;
    private final IFile _file;
    public static final String PROP_LABEL = "label";

    public FieldGenerationInfo(ValueReference valRef, IComponentGenerationInfoProvider compInfoProvider, IFile file) {
        this._valRef = valRef;
        this._compInfoProvider = compInfoProvider;
        this._label = FieldGenerationInfo.getGeneratedLabel(valRef);
        this._file = file;
    }

    public FieldGenerationInfo(ValueReference valRef, ComponentGenerationInfo compGenInfo, String label, IFile file) {
        this._valRef = valRef;
        this._compGenInfo = compGenInfo;
        this._label = label;
        this._file = file;
    }

    public ValueReference getValueReference() {
        return this._valRef;
    }

    public String getFieldName() {
        return this._valRef.getFieldName();
    }

    public String getDisplayName() {
        return this._valRef.getType((IModelContext)new FilePositionContext(this._file)).getDisplayName();
    }

    public ComponentGenerationInfo getComponentGenerationInfo() {
        if (this._compGenInfo == null) {
            FilePositionContext context = new FilePositionContext(this._file);
            this._compGenInfo = this._compInfoProvider.getComponentGenerationInfo(this._valRef.getField((IModelContext)context), this._compInfoProvider.getDefaultComponentType(this._valRef.getField((IModelContext)context)));
        }
        return this._compGenInfo;
    }

    public String getLabel() {
        if (this._label == null && this._valRef != null) {
            String fldName = this._valRef.getFieldName();
            this._label = fldName == null ? "empty" : BeanUtil.getBeanPropDisplayName(fldName);
        }
        return this._label;
    }

    public void setLabel(String label) {
        String oldValue = this._label;
        this._label = label;
        this.firePropertyChange(PROP_LABEL, oldValue, label);
    }

    private static String getGeneratedLabel(ValueReference valRef) {
        if (valRef.getFieldName() != null) {
            return BeanUtil.getBeanPropDisplayName(valRef.getFieldName());
        }
        return null;
    }

    public String toString() {
        return String.valueOf(this._valRef.getFieldName()) + ":: [label =" + this._label + ", " + this.getComponentGenerationInfo().toString() + "]";
    }
}

