/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.variables;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import oracle.eclipse.tools.application.common.services.techextservices.IDataTypeIntrospector;
import oracle.eclipse.tools.application.common.services.variables.AbstractModelObject;
import oracle.eclipse.tools.application.common.services.variables.MethodInfo;
import oracle.eclipse.tools.common.services.project.Project;
import oracle.eclipse.tools.common.services.util.ObjectUtil;
import oracle.eclipse.tools.common.services.util.SerializationUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jst.jsf.context.IModelContext;

public abstract class DataType
extends AbstractModelObject
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String mName;
    private final Project _project;
    private final IDataTypeIntrospector _introspector;
    private volatile short mFlags;
    private DataType mComponentType;
    private List<Field> mFields;
    private Set<String> _superClasses;
    private Set<String> _superInterfaces;
    private final transient ReentrantLock mLock = new ReentrantLock();
    protected static final short ARRAY_TYPE = 1;
    protected static final short ENUMERABLE_TYPE = 2;
    protected static final short UNKNOWN_FIELDS = 4;
    protected static final short UNKNOWN_TYPE = 8;
    protected static final short NUMERIC_TYPE = 16;
    protected static final short BOOLEAN_TYPE = 32;
    protected static final short STRING_TYPE = 64;
    protected static final short DATE_TYPE = 128;
    protected static final short LOADED = 256;
    protected static final short CLASS_ASSOCIATED = 512;
    protected static final short INHERIT = 1024;
    protected static final short MAP_TYPE = 2048;
    protected static final short ENUM_TYPE = 8192;
    private static final short LOAD_TYPE_FLAGS = 10;
    protected static final String MAP_ENTRY = "java.util.Map$Entry";

    public DataType(IDataTypeIntrospector introspector, String typeName, Project project) {
        this(introspector, typeName, DataType.computeTypeFlags(typeName), project);
    }

    private DataType(IDataTypeIntrospector introspector, String typeName, short flags) {
        this(introspector, typeName, DataType.computeTypeFlags(typeName), (Project)null);
    }

    private DataType(IDataTypeIntrospector introspector, String typeName, short flags, Project project) {
        this._project = project;
        this.mName = typeName;
        this._introspector = introspector;
        this.mFlags = (short)(flags | 0x100 | 0x400);
    }

    protected final void acquireLock() {
        this.mLock.lock();
    }

    protected final void releaseLock() {
        this.mLock.unlock();
    }

    protected IDataTypeIntrospector getDataTypeIntrospector() {
        return this._introspector;
    }

    protected static short computeTypeFlags(String type) {
        short flags = 0;
        if (type.equals(String.class.getName())) {
            flags = (short)(flags | 0x40);
        } else if (type.equals(Boolean.class.getName()) || type.equals(Boolean.TYPE.getName())) {
            flags = (short)(flags | 0x20);
        } else if (type.equals(Integer.class.getName()) || type.equals(Integer.TYPE.getName()) || type.equals(Float.class.getName()) || type.equals(Float.TYPE.getName()) || type.equals(Double.class.getName()) || type.equals(Double.TYPE.getName()) || type.equals(Short.class.getName()) || type.equals(Short.TYPE.getName()) || type.equals(Long.class.getName()) || type.equals(Long.TYPE.getName()) || type.equals(Byte.class.getName()) || type.equals(Byte.TYPE.getName()) || type.equals(Number.class.getName())) {
            flags = (short)(flags | 0x10);
        }
        return flags;
    }

    public final String getName() {
        return this.mName;
    }

    public final Project getProject() {
        return this._project;
    }

    public List<MethodInfo> getPublicMethods() {
        if (this._introspector != null) {
            return this._introspector.getPublicMethods(this);
        }
        return Collections.emptyList();
    }

    public final Set<String> getSuperClassSignatures() {
        this.mLock.lock();
        try {
            if (this._superClasses == null) {
                this.checkLoad();
                LinkedHashSet<String> superClasses = new LinkedHashSet<String>();
                this.addSuperClassSignatures(superClasses);
                this._superClasses = Collections.unmodifiableSet(superClasses);
            }
            Set<String> set = this._superClasses;
            return set;
        }
        finally {
            this.mLock.unlock();
        }
    }

    protected abstract void addSuperClassSignatures(Set<String> var1);

    public final Set<String> getSuperInterfaces() {
        this.mLock.lock();
        try {
            if (this._superInterfaces == null) {
                this.checkLoad();
                LinkedHashSet<String> superInterfaces = new LinkedHashSet<String>();
                this.addSuperInterfaceSignatures(superInterfaces);
                this._superInterfaces = Collections.unmodifiableSet(superInterfaces);
            }
            Set<String> set = this._superInterfaces;
            return set;
        }
        finally {
            this.mLock.unlock();
        }
    }

    protected abstract void addSuperInterfaceSignatures(Set<String> var1);

    public boolean isNumeric() {
        return (this.mFlags & 0x10) != 0;
    }

    public boolean isBoolean() {
        return (this.mFlags & 0x20) != 0;
    }

    public boolean isString() {
        return (this.mFlags & 0x40) != 0;
    }

    public boolean isEnum() {
        this.checkLoad();
        return (this.mFlags & 0x2000) != 0;
    }

    protected boolean isAssociated() {
        return (this.mFlags & 0x200) != 0;
    }

    protected void setAssociated() {
        this.mFlags = (short)(this.mFlags | 0x200);
    }

    public boolean isDate() {
        this.checkLoad();
        return (this.mFlags & 0x80) != 0;
    }

    public void setDate() {
        this.mFlags = (short)(this.mFlags | 0x80);
    }

    public boolean isArray() {
        return (this.mFlags & 1) != 0;
    }

    protected void setEnum(boolean isEnum) {
        this.mFlags = isEnum ? (short)(this.mFlags | 0x2000) : (short)(this.mFlags & 0xFFFFDFFF);
    }

    public void setArray(DataType componentType) {
        assert (componentType != null);
        this.mLock.lock();
        try {
            this.mFlags = (short)(this.mFlags | 1);
            this.mComponentType = componentType;
        }
        finally {
            this.mLock.unlock();
        }
    }

    public DataType getComponentType() {
        this.mLock.lock();
        try {
            this.checkLoad();
            DataType dataType = this.mComponentType;
            return dataType;
        }
        finally {
            this.mLock.unlock();
        }
    }

    public boolean isEnumerable() {
        this.checkLoad();
        return (this.mFlags & 3) != 0;
    }

    public void setEnumerable(DataType componentType) {
        this.mLock.lock();
        try {
            this.mFlags = (short)(this.mFlags | 2);
            this.mComponentType = componentType;
        }
        finally {
            this.mLock.unlock();
        }
    }

    public boolean isWildcard() {
        return false;
    }

    public boolean isUnknownFields() {
        this.checkLoad();
        return (this.mFlags & 4) != 0;
    }

    public void setUnknownFields() {
        this.mFlags = (short)(this.mFlags | 4);
    }

    public boolean isMap() {
        this.checkLoad();
        return (this.mFlags & 0x800) != 0;
    }

    public void setMap() {
        this.mFlags = (short)(this.mFlags | 0x800);
    }

    public boolean isUnknown() {
        this.checkLoad();
        return (this.mFlags & 8) != 0;
    }

    public void setUnknown() {
        this.mFlags = (short)(this.mFlags | 8);
    }

    public boolean isUnspecified() {
        return this == UnspecifiedDataType.UNSPECIFIED;
    }

    public static DataType getUnspecifiedType() {
        return UnspecifiedDataType.UNSPECIFIED;
    }

    public boolean isUpdatable() {
        return false;
    }

    public boolean isLoaded() {
        return (this.mFlags & 0x100) != 0;
    }

    public void setLoaded(boolean loaded) {
        if (loaded) {
            this.mFlags = (short)(this.mFlags | 0x100);
        } else {
            this.mLock.lock();
            try {
                this.mFlags = (short)(this.mFlags & 0xFFFFFEF5);
                this.mFields = null;
                this._superClasses = null;
                this._superInterfaces = null;
            }
            finally {
                this.mLock.unlock();
            }
        }
    }

    public boolean isNecessaryToUnload() {
        return true;
    }

    public boolean isInherit() {
        return (this.mFlags & 0x400) != 0;
    }

    public void setInherit(boolean inherit) {
        assert (!this.isLoaded());
        this.mFlags = inherit ? (short)(this.mFlags | 0x400) : (short)(this.mFlags & 0xFFFFFBFF);
    }

    public boolean mightHaveFields(IModelContext context) {
        if (this.isLoaded()) {
            return !this.getFields(context).isEmpty();
        }
        return true;
    }

    public List<Field> getFields(IModelContext modelContext) {
        this.mLock.lock();
        try {
            this.checkLoad();
            List<Field> list = this.mFields == null ? Collections.EMPTY_LIST : Collections.unmodifiableList(new ArrayList<Field>(this.mFields));
            return list;
        }
        finally {
            this.mLock.unlock();
        }
    }

    public void addField(Field field) {
        this.mLock.lock();
        try {
            if (this.mFields == null) {
                this.mFields = new ArrayList<Field>();
            }
            this.mFields.add(field);
        }
        finally {
            this.mLock.unlock();
        }
    }

    public int getNumFields(IModelContext modelContext) {
        this.mLock.lock();
        try {
            this.checkLoad();
            int n = this.getFields(modelContext).size();
            return n;
        }
        finally {
            this.mLock.unlock();
        }
    }

    public Field getField(String fieldName, IModelContext modelContext) {
        this.mLock.lock();
        try {
            List<Field> fields = this.getFields(modelContext);
            int i = 0;
            int n = fields.size();
            while (i < n) {
                Field field = fields.get(i);
                if (field.getName().equals(fieldName)) {
                    Field field2 = field;
                    return field2;
                }
                ++i;
            }
            return null;
        }
        finally {
            this.mLock.unlock();
        }
    }

    public String getDisplayName() {
        return this.getDisplayName(false);
    }

    public String getDisplayName(boolean abbreviated) {
        this.mLock.lock();
        try {
            String displayName;
            if (this.isArray()) {
                displayName = String.valueOf(this.getComponentType().getDisplayName(abbreviated)) + "[]";
            } else {
                String string = displayName = abbreviated ? ObjectUtil.getClassName((String)this.getName()) : this.getName();
                if (this.isEnumerable() && this.getComponentType() != null && this.getComponentType() != DataType.getUnspecifiedType() && !this.isMap()) {
                    displayName = String.valueOf(displayName) + '<' + this.getComponentType().getDisplayName(abbreviated) + '>';
                }
            }
            String string = displayName = displayName.replace('$', '.');
            return string;
        }
        finally {
            this.mLock.unlock();
        }
    }

    public boolean dependsOn(String typeName, IModelContext context) {
        if (typeName.equals(this.mName)) {
            return true;
        }
        this.mLock.lock();
        try {
            List<Field> fields = this.getFields(context);
            for (Field field : fields) {
                if (!typeName.equals(field.getType().getName())) continue;
                return true;
            }
            return false;
        }
        finally {
            this.mLock.unlock();
        }
    }

    public String toString() {
        return this.getName();
    }

    public boolean isMatchable(DataType otherType) {
        return false;
    }

    public boolean equals(Object obj) {
        this.mLock.lock();
        try {
            boolean equals;
            if (!(obj instanceof DataType)) {
                return false;
            }
            DataType thatType = (DataType)obj;
            boolean bl = equals = ObjectUtil.equalObjects((Object)this.mName, (Object)thatType.mName) && ObjectUtil.equalObjects((Object)this._project, (Object)thatType._project);
            return bl;
        }
        finally {
            this.mLock.unlock();
        }
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this._project == null ? 0 : this._project.hashCode());
        result = 31 * result + (this.mName == null ? 0 : this.mName.hashCode());
        return result;
    }

    protected void load() {
        if (this._project != null && this._introspector != null) {
            this._introspector.load(this, this.isInherit());
        }
    }

    private void checkLoad() {
        this.mLock.lock();
        try {
            if (!this.isLoaded()) {
                this.setLoaded(true);
                this.load();
            }
        }
        finally {
            this.mLock.unlock();
        }
    }

    public boolean isPrimitiveType() {
        return false;
    }

    public boolean isSubClass(String superClassName) {
        return false;
    }

    public boolean isAssignableFrom(String superClassName) {
        return false;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.mLock.lock();
        try {
            SerializationUtil su = SerializationUtil.forOutput((ObjectOutputStream)out);
            out.writeObject(this.mName);
            out.writeObject(this.mFields);
            out.writeObject(this.mComponentType);
            out.writeShort(this.mFlags);
            out.writeObject(this._superClasses);
            out.writeObject(this._superInterfaces);
            if (this._project == null) {
                out.writeObject(null);
            } else {
                su.writeResource((IResource)this._project.getEclipseProject());
            }
        }
        finally {
            this.mLock.unlock();
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException, IllegalArgumentException, IllegalAccessException {
        SerializationUtil su = SerializationUtil.forInput((ObjectInputStream)in);
        su.setFinalField((Object)this, "mLock", ReentrantLock.class, (Object)new ReentrantLock());
        this.mLock.lock();
        try {
            su.readFinalFieldFromStream((Object)this, "mName", String.class);
            this.mFields = (List)in.readObject();
            this.mComponentType = (DataType)in.readObject();
            this.mFlags = in.readShort();
            this._superClasses = (Set)in.readObject();
            this._superInterfaces = (Set)in.readObject();
            IProject prj = su.readProject();
            if (prj == null) {
                su.setFinalField((Object)this, "_project", Project.class, null);
            } else {
                su.setFinalField((Object)this, "_project", Project.class, prj.getAdapter(Project.class));
            }
        }
        finally {
            this.mLock.unlock();
        }
    }

    /* synthetic */ DataType(IDataTypeIntrospector iDataTypeIntrospector, String string, short s, DataType dataType) {
        this(iDataTypeIntrospector, string, s);
    }

    public static class Field
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String mName;
        private final DataType mType;
        private volatile byte mFlags;
        private static final byte INHERITED = 1;

        public Field(String name, DataType type) {
            String nonNullName = name;
            if (nonNullName == null) {
                nonNullName = "";
            }
            this.mName = nonNullName;
            this.mType = type;
        }

        public boolean isInherited() {
            return (this.mFlags & 1) != 0;
        }

        public void setInherited(boolean b) {
            this.mFlags = b ? (byte)(this.mFlags | 1) : (byte)(this.mFlags & 0xFFFFFFFE);
        }

        public String getName() {
            return this.mName;
        }

        public DataType getType() {
            return this.mType;
        }

        public String toString() {
            return this.mName;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Field)) {
                return false;
            }
            Field thatField = (Field)obj;
            return ObjectUtil.equalObjects((Object)this.getName(), (Object)thatField.getName()) && ObjectUtil.equalObjects((Object)this.getType(), (Object)thatField.getType());
        }

        public int hashCode() {
            int code = this.getName() == null ? 31 : this.getName().hashCode();
            return code ^= this.getType() == null ? -32 : this.getType().hashCode();
        }
    }

    public static final class NullModelContext
    implements IModelContext {
        private static final IModelContext INSTANCE = new NullModelContext();

        public static IModelContext getInstance() {
            return INSTANCE;
        }

        private NullModelContext() {
        }

        public Object getAdapter(Class adapter) {
            return null;
        }
    }

    private static final class UnspecifiedDataType
    extends DataType {
        private static final long serialVersionUID = 1L;
        private static final DataType UNSPECIFIED = new UnspecifiedDataType(null, "?unknown?", 8);

        private UnspecifiedDataType(IDataTypeIntrospector introspector, String typeName, short flags) {
            super(introspector, typeName, flags, (DataType)null);
        }

        @Override
        protected void addSuperClassSignatures(Set<String> superClasses) {
        }

        @Override
        protected void addSuperInterfaceSignatures(Set<String> superClasses) {
        }

        @Override
        public boolean isUnknown() {
            return true;
        }

        @Override
        public boolean isUnspecified() {
            return true;
        }

        @Override
        public void setLoaded(boolean loaded) {
        }

        @Override
        public boolean isLoaded() {
            return true;
        }

        private Object readResolve() {
            return UNSPECIFIED;
        }
    }
}

