/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.variables;

import java.beans.PropertyChangeListener;
import oracle.eclipse.tools.application.common.services.Messages;
import oracle.eclipse.tools.application.common.services.variables.AbstractModelObject;

public class ComponentGenerationInfo
extends AbstractModelObject {
    private static final long serialVersionUID = -4300843292276815954L;
    private ComponentType _component;
    private boolean _disabled = false;
    public static final String PROP_COMPONENT_TYPE = "componentType";
    private static final String PROP_COMPONENT_ENABLED = "enabled";

    public ComponentGenerationInfo(ComponentType comp) {
        this._component = comp;
    }

    public ComponentType getComponentType() {
        return this._component;
    }

    public void setComponentType(ComponentType component) {
        ComponentType oldValue = this._component;
        this._component = component;
        this.firePropertyChange(PROP_COMPONENT_TYPE, (Object)oldValue, (Object)component);
    }

    public void setComponentType(String componentTypeName) {
        this.setComponentType(ComponentType.valueOf(componentTypeName));
    }

    public boolean isEnabled() {
        return !this._disabled;
    }

    public void setEnabled(boolean enabled) {
        boolean oldValue = !this._disabled;
        this._disabled = !enabled;
        this.firePropertyChange(PROP_COMPONENT_ENABLED, oldValue, enabled);
    }

    public String toString() {
        return "compType = " + this._component.getDisplayName() + ", enabled = " + !this._disabled;
    }

    public static enum ComponentType {
        Textbox(Messages.ComponentGenerationInfo_TextField, true, false),
        MultiLineTextbox(Messages.ComponentGenerationInfo_TextArea, true, false),
        PasswordField(Messages.ComponentGenerationInfo_PasswordField, true, false),
        Label(Messages.ComponentGenerationInfo_Label, false, false),
        Checkbox(Messages.ComponentGenerationInfo_Checkbox, true, false),
        CheckboxGroup(Messages.ComponentGenerationInfo_CheckboxGroup, true, true),
        RadioButtonGroup(Messages.ComponentGenerationInfo_RadiobuttonGroup, true, false),
        SingleSelectList(Messages.ComponentGenerationInfo_SingleSelectList, true, false),
        SingleSelectMenu(Messages.ComponentGenerationInfo_Menu, true, false),
        MultiSelectList(Messages.ComponentGenerationInfo_MultiSelectList, true, true),
        Image(Messages.ComponentGenerationInfo_Image, false, false),
        Link(Messages.ComponentGenerationInfo_Link, false, false),
        MultiSelectMenu(Messages.ComponentGenerationInfo_MultiSelectMenu, true, true);

        private boolean _isInputType;
        private boolean _isMulti;
        private String _label;

        private ComponentType(String displayName, boolean isInputType, boolean isMultiValueComponent) {
            this._label = displayName;
            this._isInputType = isInputType;
            this._isMulti = isMultiValueComponent;
        }

        public boolean isInputType() {
            return this._isInputType;
        }

        public boolean isMultiValueType() {
            return this._isMulti;
        }

        public String getDisplayName() {
            return this._label;
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
        }

        public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
        }

        public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        }
    }
}

