/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.variables;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.eclipse.tools.application.common.services.variables.ExternalVariable;
import oracle.eclipse.tools.application.common.services.variables.IVariablesCache;
import oracle.eclipse.tools.application.common.services.variables.IVariablesListener;
import oracle.eclipse.tools.application.common.services.variables.VariablesController;
import oracle.eclipse.tools.common.services.dependency.artifact.discovery.AbstractSimpleDiscoveryParticipant;
import oracle.eclipse.tools.common.services.dependency.artifact.discovery.IDiscoveryContext;
import oracle.eclipse.tools.common.services.dependency.artifact.discovery.IDiscoveryParticipant;
import oracle.eclipse.tools.common.services.dependency.artifact.discovery.IResourceDiscoveryContext;
import oracle.eclipse.tools.common.services.dependency.structuredmodel.IStructuredXMLModelVisitor;
import oracle.eclipse.tools.common.services.dependency.structuredmodel.IVisitableDOMModel;
import oracle.eclipse.tools.common.services.dependency.structuredmodel.StructuredModelFactory;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;

public abstract class AbstractVariablesDiscoveryParticipant
extends AbstractSimpleDiscoveryParticipant
implements IDiscoveryParticipant {
    private Set<IProject> changedProjects = new HashSet<IProject>();
    private IDiscoveryContext projectContext = null;

    public void startDiscovery(IDiscoveryContext context, IProgressMonitor monitor) {
        this.projectContext = context;
        this.changedProjects.clear();
    }

    public IStatus stopDiscovery(IProgressMonitor monitor) {
        this.projectContext = null;
        for (IProject project : this.changedProjects) {
            VariablesController.getInstance().updateListeners(project, new IVariablesListener.VariableChangeEvent((Object)this, (IResource)project, IVariablesListener.VariableChangeEvent.AllCaches, IVariablesListener.VariableChangeEvent.AllVariableChange, null));
        }
        return Status.OK_STATUS;
    }

    public void discover(IResourceDiscoveryContext context, IProgressMonitor monitor) {
        IVisitableDOMModel model = null;
        IFile file = (IFile)context.getResource();
        this.changedProjects.add(file.getProject());
        IVariablesCache cache = (IVariablesCache)this.projectContext.getAdapter(IVariablesCache.class);
        if (cache != null) {
            try {
                model = StructuredModelFactory.getVisitableModelForRead((IFile)file);
                if (model == null) {
                    return;
                }
                try {
                    this.visitModel(model, file, cache);
                }
                catch (OperationCanceledException e) {
                    LoggingService.logException((String)"oracle.eclipse.tools.application.common.services", (Throwable)e);
                }
                catch (CoreException e) {
                    LoggingService.logException((String)"oracle.eclipse.tools.application.common.services", (CoreException)e);
                }
                catch (IOException e) {
                    LoggingService.logException((String)"oracle.eclipse.tools.application.common.services", (Throwable)e);
                }
            }
            finally {
                if (model != null) {
                    model.dispose();
                }
            }
        }
    }

    protected abstract boolean visit(IDOMElement var1, IFile var2, List<ExternalVariable> var3);

    protected void visitModel(IVisitableDOMModel model, IFile file, IVariablesCache cache) {
        Visitor visitor = new Visitor(file);
        model.accept((IStructuredXMLModelVisitor)visitor);
        List vars = visitor.getExternalVaraibles();
        for (ExternalVariable var : vars) {
            cache.add(var);
        }
    }

    public IDiscoveryContext getProjectContext() {
        return this.projectContext;
    }

    private class Visitor
    implements IStructuredXMLModelVisitor {
        private final IFile file;
        private final List<ExternalVariable> discoveredVars = new ArrayList<ExternalVariable>();

        public Visitor(IFile file) {
            this.file = file;
        }

        public boolean visit(IDOMNode node) {
            return false;
        }

        public boolean visit(IDOMElement element) {
            return AbstractVariablesDiscoveryParticipant.this.visit(element, this.file, this.discoveredVars);
        }

        public boolean visit(IDOMDocument document) {
            return true;
        }

        public boolean visit(IDOMAttr attribute) {
            return false;
        }

        private List<ExternalVariable> getExternalVaraibles() {
            return Collections.unmodifiableList(this.discoveredVars);
        }
    }
}

