/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.util;

import java.io.File;
import java.net.URI;
import java.net.URL;
import oracle.eclipse.tools.application.common.services.util.UrlUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class WorkspaceUtil {
    public static IFile convertToIFile(IProject project, URL url) {
        IResource resource = WorkspaceUtil.convertToResource(project, url);
        if (resource != null && resource.getType() == 1) {
            return (IFile)resource;
        }
        return null;
    }

    public static IResource convertToResource(IProject project, URL url) {
        IResource resource;
        File f = UrlUtil.getUrlFile(url);
        if (f == null) {
            return null;
        }
        URI uri = null;
        uri = f.toURI();
        if (uri == null) {
            return null;
        }
        if (f.isDirectory()) {
            IResource resource2;
            if (project != null && (resource2 = WorkspaceUtil.tryOptimizedResolve(project, uri, false)) != null) {
                return resource2;
            }
            IContainer[] containers = ResourcesPlugin.getWorkspace().getRoot().findContainersForLocationURI(uri);
            if (containers.length == 1) {
                return containers[0];
            }
            if (containers.length > 1) {
                if (project == null) {
                    return containers[0];
                }
                IContainer[] iContainerArray = containers;
                int n = containers.length;
                int n2 = 0;
                while (n2 < n) {
                    IContainer container = iContainerArray[n2];
                    if (container.getProject().getLocation().equals((Object)project.getLocation())) {
                        return container;
                    }
                    ++n2;
                }
            }
            return null;
        }
        if (project != null && (resource = WorkspaceUtil.tryOptimizedResolve(project, uri, true)) != null) {
            return resource;
        }
        IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(uri);
        if (files.length == 1) {
            if (project == null) {
                return files[0];
            }
            if (files[0].getProject().getLocation().equals((Object)project.getLocation())) {
                return files[0];
            }
        } else if (files.length > 1) {
            if (project == null) {
                return files[0];
            }
            IFile[] iFileArray = files;
            int n = files.length;
            int n3 = 0;
            while (n3 < n) {
                IFile file = iFileArray[n3];
                if (file.getProject().getLocation().equals((Object)project.getLocation())) {
                    return file;
                }
                ++n3;
            }
        }
        return null;
    }

    private static IResource tryOptimizedResolve(IProject project, URI uri, boolean isFile) {
        URI projectLocationURI = project.getLocationURI();
        URI relativize = projectLocationURI.relativize(uri);
        if (!relativize.isAbsolute()) {
            if (isFile) {
                IFile file = project.getFile(relativize.getPath());
                if (file.exists()) {
                    return file;
                }
            } else {
                IFolder folder = project.getFolder(relativize.getPath());
                if (folder.exists()) {
                    return folder;
                }
            }
        }
        return null;
    }

    public static IFile getWorkspaceFile(File file) {
        Path path = new Path(file.getAbsolutePath());
        IFile iFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)path);
        if (iFile != null) {
            return iFile;
        }
        return null;
    }

    public static IProject UrlToProject(URL url) {
        IResource resource;
        URL fixedUrl = url;
        if (UrlUtil.isJarUrl(fixedUrl)) {
            fixedUrl = UrlUtil.getJarFileUrl(fixedUrl);
        }
        if ((resource = WorkspaceUtil.convertToResource(null, fixedUrl)) != null) {
            return resource.getProject();
        }
        return null;
    }
}

