/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class FileUtil {
    public static final boolean DEEP = true;

    public static String removeFileExtension(String fileName) {
        int dotIndex = fileName.lastIndexOf(46);
        if (dotIndex < 0) {
            return fileName;
        }
        return fileName.substring(0, dotIndex);
    }

    public static String getFileExtension(String fileName) {
        if (fileName == null) {
            return null;
        }
        int dotIndex = fileName.lastIndexOf(46);
        if (dotIndex < 0) {
            return null;
        }
        return fileName.substring(dotIndex + 1);
    }

    public static URL getFileUrl(File file) {
        try {
            return file.toURL();
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public static List<IFile> getFiles(IContainer container, String extension, boolean deep) throws CoreException {
        List<IFile> result = Collections.emptyList();
        IResource[] files = container.members();
        if (files == null) {
            return result;
        }
        result = new ArrayList<IFile>();
        IResource[] iResourceArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            IResource res = iResourceArray[n2];
            if (res.getType() == 2) {
                if (deep) {
                    result.addAll(FileUtil.getFiles((IContainer)res, extension, true));
                }
            } else if (res.getType() == 1) {
                if (extension != null) {
                    if (extension.equalsIgnoreCase(res.getFileExtension())) {
                        result.add((IFile)res);
                    }
                } else {
                    result.add((IFile)res);
                }
            }
            ++n2;
        }
        return Collections.unmodifiableList(result);
    }

    public static IPath getRelative(IContainer parent, IFile file) {
        IPath containerPath = parent.getProjectRelativePath();
        IPath filePath = file.getProjectRelativePath();
        IPath relativePath = filePath.makeRelativeTo(containerPath);
        return relativePath;
    }
}

