/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.resource.internal;

import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import oracle.eclipse.tools.application.common.services.Messages;
import oracle.eclipse.tools.application.common.services.appservices.IBundleResource;
import oracle.eclipse.tools.application.common.services.resource.internal.AbstractResourceBundleExt;
import oracle.eclipse.tools.application.common.services.variables.Variable;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;

public class ResourceBundleExtLocalizationContext
extends AbstractResourceBundleExt {
    private final IBundleResource _bundleRes;
    private final String _baseName;
    private ResourceBundle _bundle;

    public ResourceBundleExtLocalizationContext(IBundleResource bundleRes, String baseName) {
        Assert.isNotNull((Object)bundleRes);
        Assert.isNotNull((Object)baseName);
        this._bundleRes = bundleRes;
        this._bundle = this._bundleRes.loadBundle();
        if (this._bundle == null) {
            throw new IllegalStateException(Messages.ResourceBundleExtLocalizationContext_UnableToLoadResourceBundle);
        }
        this._baseName = baseName;
    }

    @Override
    public Enumeration<String> getKeys() {
        return this._bundle.getKeys();
    }

    @Override
    public Locale getLocale() {
        return this._bundle.getLocale();
    }

    @Override
    public String getString(String key) {
        return this._bundle.getString(key);
    }

    @Override
    public String getBaseName() {
        return this._baseName;
    }

    @Override
    public String getSimpleBaseName() {
        return this.getBaseName().substring(this.getBaseName().lastIndexOf(46) + 1);
    }

    @Override
    public String getLocaleSpecificName() {
        return this.getLocaleSpecificName(this.getBaseName(), this._bundle.getLocale());
    }

    @Override
    public String getSimpleLocaleSpecificName() {
        return this.getLocaleSpecificName(this.getSimpleBaseName(), this._bundle.getLocale());
    }

    @Override
    public IStatus doAddKey(String key) {
        return this.doAddKey(key, "");
    }

    @Override
    public IStatus doAddKey(String key, String value) {
        return this._bundleRes.addKey(key, value, null);
    }

    @Override
    public IStatus getModificationStatus() {
        return this.checkIsBundleModifiable(this._bundleRes);
    }

    @Override
    public Variable getVariable() {
        return null;
    }

    @Override
    public void refreshResourceBundle() {
        this._bundle = null;
        this._bundle = this._bundleRes.loadBundle();
        if (this._bundle == null) {
            throw new IllegalStateException(Messages.ResourceBundleExtLocalizationContext_ResourceNowMissing);
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "@" + Integer.toHexString(this.hashCode()) + "(" + this.getLocaleSpecificName() + ")";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ResourceBundleExtLocalizationContext)) {
            return false;
        }
        ResourceBundleExtLocalizationContext other = (ResourceBundleExtLocalizationContext)obj;
        return this.getLocale().equals(other.getLocale()) && this.getBaseName().equals(other.getBaseName());
    }

    public int hashCode() {
        return this.getLocale().hashCode() ^ this.getBaseName().hashCode();
    }
}

