/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.resource.internal;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import oracle.eclipse.tools.application.common.services.Messages;
import oracle.eclipse.tools.application.common.services.appservices.IBundleResource;
import oracle.eclipse.tools.application.common.services.resource.internal.AbstractResourceBundleExt;
import oracle.eclipse.tools.application.common.services.variables.DataType;
import oracle.eclipse.tools.application.common.services.variables.JavaResourceBundleDataType;
import oracle.eclipse.tools.application.common.services.variables.Variable;
import oracle.eclipse.tools.common.services.document.IFilePositionContext;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jst.jsf.context.IModelContext;

public class ResourceBundleExtElValueExpression
extends AbstractResourceBundleExt {
    private final JavaResourceBundleDataType _dataType;
    private final Variable _var;
    private final IFilePositionContext _context;

    public ResourceBundleExtElValueExpression(IFilePositionContext context, JavaResourceBundleDataType dataType, Variable var) {
        Assert.isNotNull((Object)dataType);
        this._dataType = dataType;
        this._var = var;
        this._context = context;
    }

    @Override
    public Enumeration<String> getKeys() {
        return new FieldsEnumeration(new ArrayList<DataType.Field>(this._dataType.getFields((IModelContext)this._context)));
    }

    @Override
    public Locale getLocale() {
        return this._dataType.getLocale((IModelContext)this._context);
    }

    @Override
    public String getString(String key) {
        if (key == null) {
            throw new NullPointerException();
        }
        JavaResourceBundleDataType.ResourceBundleField field = this._dataType.getField(key, (IModelContext)this._context);
        if (field == null) {
            throw new MissingResourceException(Messages.bind((String)Messages.ResourceBundleExtElValueExpression_MissingResourceException_Msg, (Object)this.getClass().getName(), (Object)key), this.getClass().getName(), key);
        }
        return field.getValue();
    }

    @Override
    public String getBaseName() {
        String baseName = this._dataType.getBaseName();
        if (baseName == null) {
            baseName = "";
        }
        return baseName;
    }

    @Override
    public String getSimpleBaseName() {
        return this.getBaseName().substring(this.getBaseName().lastIndexOf(46) + 1);
    }

    @Override
    public String getLocaleSpecificName() {
        return this.getLocaleSpecificName(this.getBaseName(), this._dataType.getLocale((IModelContext)this._context));
    }

    @Override
    public String getSimpleLocaleSpecificName() {
        return this.getLocaleSpecificName(this.getSimpleBaseName(), this._dataType.getLocale((IModelContext)this._context));
    }

    @Override
    public IStatus doAddKey(String key) {
        return this.doAddKey(key, "");
    }

    @Override
    public Variable getVariable() {
        return this._var;
    }

    @Override
    public void refreshResourceBundle() {
        this._dataType.getBundleResource((IModelContext)this._context).loadBundle();
    }

    @Override
    public IStatus doAddKey(String key, String value) {
        return this._dataType.getBundleResource((IModelContext)this._context).addKey(key, value, null);
    }

    @Override
    public IStatus getModificationStatus() {
        IBundleResource bundleResource = this._dataType.getBundleResource((IModelContext)this._context);
        return this.checkIsBundleModifiable(bundleResource);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "@" + Integer.toHexString(this.hashCode()) + "(" + this.getLocaleSpecificName() + ")";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ResourceBundleExtElValueExpression)) {
            return false;
        }
        ResourceBundleExtElValueExpression other = (ResourceBundleExtElValueExpression)obj;
        return this._dataType.equals(other._dataType);
    }

    public int hashCode() {
        return this._dataType.hashCode();
    }

    private static final class FieldsEnumeration
    implements Enumeration<String> {
        private final List<DataType.Field> _fields;
        private int _index = 0;

        public FieldsEnumeration(List<DataType.Field> fields) {
            this._fields = fields;
        }

        @Override
        public boolean hasMoreElements() {
            return this._index < this._fields.size();
        }

        @Override
        public String nextElement() {
            return this._fields.get(this._index++).getName();
        }
    }
}

