/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.resource.internal;

import java.util.Locale;
import java.util.concurrent.CopyOnWriteArrayList;
import oracle.eclipse.tools.application.common.services.Messages;
import oracle.eclipse.tools.application.common.services.appservices.IBundleResource;
import oracle.eclipse.tools.application.common.services.resource.IResourceBundleExt;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public abstract class AbstractResourceBundleExt
implements IResourceBundleExt {
    private final CopyOnWriteArrayList<IResourceBundleExt.INewResourceKeyListener> _listeners = new CopyOnWriteArrayList();

    @Override
    public void addNewResourceKeyListener(IResourceBundleExt.INewResourceKeyListener listener) {
        this._listeners.addIfAbsent(listener);
    }

    @Override
    public void removeNewResourceKeyListener(IResourceBundleExt.INewResourceKeyListener listener) {
        this._listeners.remove(listener);
    }

    protected void updateListeners(String key, String value) {
        IResourceBundleExt.NewResourceKeyEvent event = new IResourceBundleExt.NewResourceKeyEvent(this, key, value);
        for (IResourceBundleExt.INewResourceKeyListener listener : this._listeners) {
            listener.newResourceKey(event);
        }
    }

    @Override
    public void addKey(String key) {
        if (this.doAddKey(key).isOK()) {
            this.updateListeners(key, "");
        }
    }

    @Override
    public void addKey(String key, String value) {
        if (this.doAddKey(key, value).isOK()) {
            this.updateListeners(key, value);
        }
    }

    public abstract IStatus doAddKey(String var1);

    public abstract IStatus doAddKey(String var1, String var2);

    public IStatus checkIsBundleModifiable(IBundleResource bundleResource) {
        if (bundleResource != null) {
            IFile underlyingResource = bundleResource.getUnderlyingResource();
            if (underlyingResource == null) {
                return new Status(4, "oracle.eclipse.tools.application.common.services", Messages.AbstractResourceBundleExt_1);
            }
            if (!underlyingResource.isAccessible()) {
                return new Status(4, "oracle.eclipse.tools.application.common.services", Messages.AbstractResourceBundleExt_6);
            }
            if (underlyingResource.isReadOnly()) {
                return new Status(4, "oracle.eclipse.tools.application.common.services", Messages.AbstractResourceBundleExt_3);
            }
            return Status.OK_STATUS;
        }
        return new Status(4, "oracle.eclipse.tools.application.common.services", Messages.AbstractResourceBundleExt_5);
    }

    protected String getLocaleSpecificName(String baseName, Locale locale) {
        String localeName = locale == null ? "" : locale.toString();
        return localeName.length() == 0 ? baseName : String.valueOf(baseName) + '_' + localeName;
    }

    @Override
    public void refreshResourceBundle() {
    }
}

