/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.resource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import oracle.eclipse.tools.application.common.services.appservices.IBundleResource;
import oracle.eclipse.tools.application.common.services.appservices.IDesignTimeLocaleService;
import oracle.eclipse.tools.application.common.services.collection.StructuredDocumentResourceLocationFactory;
import oracle.eclipse.tools.application.common.services.documentservices.IDocumentLocalizationContext;
import oracle.eclipse.tools.application.common.services.documentservices.WebtierDocumentServicesFactory;
import oracle.eclipse.tools.application.common.services.resource.IResourceBundleExt;
import oracle.eclipse.tools.application.common.services.resource.ResourceBundleExtFactory;
import oracle.eclipse.tools.application.common.services.variables.DocumentVariableQuery;
import oracle.eclipse.tools.application.common.services.variables.JavaResourceBundleDataType;
import oracle.eclipse.tools.application.common.services.variables.ResolutionTime;
import oracle.eclipse.tools.application.common.services.variables.Variable;
import oracle.eclipse.tools.application.common.services.variables.VariableQuery;
import oracle.eclipse.tools.common.services.dependency.artifact.Range;
import oracle.eclipse.tools.common.services.dependency.artifact.ResourceLocation;
import oracle.eclipse.tools.common.services.document.IDocument;
import oracle.eclipse.tools.common.services.project.Project;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.xml.model.emfbinding.IEStoreNodeBindingAdapter;
import oracle.eclipse.tools.xml.model.emfbinding.dom.INamespaceContext;
import oracle.eclipse.tools.xml.model.emfbinding.dom.NodeAdapterEStoreEObjectImpl;
import oracle.eclipse.tools.xml.model.emfbinding.dom.NodeEStoreDOMAdapter;
import oracle.eclipse.tools.xml.model.util.NamespaceContextManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.w3c.dom.Node;

public final class ResourceBundleUtil {
    public static final String INSERT_POSITION = "oracle.eclipse.tools.application.common.services.resource.ResourceBundleUtil.INSERT_POSITION";
    public static final ResourceBundleUtil INSTANCE = new ResourceBundleUtil();
    private static final Variable[] EMPTY_VARIABLES = new Variable[0];

    private ResourceBundleUtil() {
    }

    public long getOffset(EObject eObject, EStructuralFeature eFeature) {
        long offset = this.getOffsetFromBindingAdapter(eObject);
        if (offset != -1L) {
            return offset;
        }
        offset = this.getOffsetForAttr(eObject, eFeature);
        if (offset != -1L) {
            return offset;
        }
        return this.getOffsetForTag(eObject);
    }

    public long getOffsetForAttr(EObject eObject, EStructuralFeature eFeature) {
        IFile baseFile = this.getBaseFile(eObject);
        if (baseFile == null) {
            return -1L;
        }
        INamespaceContext namespaceContext = NamespaceContextManager.getNamespaceContext((IFile)baseFile);
        if (!(eObject instanceof NodeAdapterEStoreEObjectImpl)) {
            return -1L;
        }
        List boundFeature = NodeEStoreDOMAdapter.INSTANCE.getBoundFeature((NodeAdapterEStoreEObjectImpl)eObject, (EAttribute)eFeature, namespaceContext);
        if (boundFeature.size() == 0) {
            return -1L;
        }
        Node node = (Node)boundFeature.get(0);
        if (!(node instanceof IDOMAttr)) {
            return -1L;
        }
        IDOMAttr domAttr = (IDOMAttr)node;
        StructuredDocumentResourceLocationFactory fsdrlFactory = new StructuredDocumentResourceLocationFactory(baseFile);
        ResourceLocation resourceLocation = fsdrlFactory.createForAttributeValue(domAttr);
        Range range = resourceLocation.getRange();
        return range.getOffset();
    }

    public long getOffsetForTag(EObject eObject) {
        if (!(eObject instanceof NodeAdapterEStoreEObjectImpl)) {
            return -1L;
        }
        NodeAdapterEStoreEObjectImpl boundEObject = (NodeAdapterEStoreEObjectImpl)eObject;
        Node node = NodeEStoreDOMAdapter.INSTANCE.getBoundObject(boundEObject);
        if (!(node instanceof IDOMElement)) {
            return -1L;
        }
        IDOMElement domElement = (IDOMElement)node;
        IFile baseFile = this.getBaseFile(eObject);
        if (baseFile == null) {
            return -1L;
        }
        StructuredDocumentResourceLocationFactory fsdrlFactory = new StructuredDocumentResourceLocationFactory(baseFile);
        ResourceLocation resourceLocation = fsdrlFactory.createForEntireElement(domElement);
        Range range = resourceLocation.getRange();
        return range.getOffset();
    }

    public IFile getBaseFile(EObject eObject) {
        Resource resource = eObject.eResource();
        if (resource == null) {
            return null;
        }
        IAdaptable existingAdapter = (IAdaptable)EcoreUtil.getExistingAdapter((Notifier)resource, IAdaptable.class);
        if (existingAdapter == null) {
            return null;
        }
        return (IFile)existingAdapter.getAdapter(IFile.class);
    }

    public IResourceBundleExt getBundleExtFromLocalizationContext(EObject eObject, EStructuralFeature eFeature) {
        IBundleResource bundleResource;
        IDocumentLocalizationContext context = this.getLocalizationContext(eObject);
        if (context == null) {
            return null;
        }
        long offset = this.getOffset(eObject, eFeature);
        if (offset == -1L) {
            return null;
        }
        String baseName = context.getImplicitBundleName((int)offset);
        Project project = this.getProject(eObject);
        if (project == null) {
            return null;
        }
        Locale currentLocale = ((IDesignTimeLocaleService)project.getAppService(IDesignTimeLocaleService.class)).getCurrentLocale();
        ArrayList<Locale> preferredLocales = new ArrayList<Locale>();
        preferredLocales.add(currentLocale);
        Locale locale = context.resolveLocale((int)offset, preferredLocales);
        if (baseName != null && locale != null && (bundleResource = context.resolveBundle((int)offset, baseName, locale)) != null) {
            try {
                return ResourceBundleExtFactory.INSTANCE.create(bundleResource, baseName);
            }
            catch (IllegalStateException e) {
                LoggingService.logWarning((String)"oracle.eclipse.tools.common.services", (String)e.getMessage());
                return null;
            }
        }
        return null;
    }

    public IDocumentLocalizationContext getLocalizationContext(EObject eObject) {
        IDocument document = this.getDocument(this.getBaseFile(eObject));
        if (document == null) {
            return null;
        }
        WebtierDocumentServicesFactory factory = new WebtierDocumentServicesFactory();
        return (IDocumentLocalizationContext)factory.createAdapter(IDocumentLocalizationContext.class, document);
    }

    public long getOffsetFromBindingAdapter(EObject eObject) {
        IEStoreNodeBindingAdapter adapter;
        Long insertOffset;
        long offset = -1L;
        if (eObject instanceof NodeAdapterEStoreEObjectImpl && (insertOffset = (Long)(adapter = ((NodeAdapterEStoreEObjectImpl)eObject).getBindingAdapter()).getData(INSERT_POSITION)) != null) {
            offset = insertOffset;
        }
        return offset;
    }

    public Variable[] getExternalVariableBundles(EObject eObject, EStructuralFeature eFeature, final Collection<ResolutionTime> expectedResTime) {
        IDocument document = INSTANCE.getDocument(INSTANCE.getBaseFile(eObject));
        if (document == null) {
            return EMPTY_VARIABLES;
        }
        long offset = this.getOffset(eObject, eFeature);
        if (offset == -1L) {
            return EMPTY_VARIABLES;
        }
        DocumentVariableQuery query = new DocumentVariableQuery(document, (int)offset, true);
        VariableQuery.QueryMatcher matcher = new VariableQuery.QueryMatcher(){

            public boolean matches(Variable variable) {
                return variable.getType() instanceof JavaResourceBundleDataType && expectedResTime.contains((Object)variable.getResolutionType());
            }
        };
        List<Variable> variables = query.findVariable(matcher);
        return variables.toArray(new Variable[variables.size()]);
    }

    public IDocument getDocument(IFile baseFile) {
        if (baseFile == null) {
            return null;
        }
        return (IDocument)baseFile.getAdapter(IDocument.class);
    }

    public Project getProject(EObject eObject) {
        IFile baseFile = this.getBaseFile(eObject);
        if (baseFile == null) {
            return null;
        }
        return (Project)baseFile.getProject().getAdapter(Project.class);
    }
}

