/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.metadata.query.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.application.common.services.metadata.IVariant;
import oracle.eclipse.tools.application.common.services.metadata.IVersion;
import oracle.eclipse.tools.application.common.services.metadata.query.AbstractVariantContextAdapterFactory;
import oracle.eclipse.tools.application.common.services.metadata.query.AbstractVersionContextAdapterFactory;
import oracle.eclipse.tools.common.util.PluginUtil;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataModelContext;

public final class MetadataModelContextAdapterFactory {
    private static final String EXTENSION_POINT_ID = "metaDataModelContextAdapterFactories";
    private static MetadataModelContextAdapterFactory INSTANCE = null;
    private List<AbstractVersionContextAdapterFactory> _versionContextAdapterFactories = new ArrayList<AbstractVersionContextAdapterFactory>();
    private List<AbstractVariantContextAdapterFactory> _variantContextAdapterFactories = new ArrayList<AbstractVariantContextAdapterFactory>();

    public static synchronized MetadataModelContextAdapterFactory getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new MetadataModelContextAdapterFactory();
            INSTANCE.init();
        }
        return INSTANCE;
    }

    private void init() {
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint point = extensionRegistry.getExtensionPoint("oracle.eclipse.tools.application.common.services", EXTENSION_POINT_ID);
        if (point != null) {
            IConfigurationElement[] elements = point.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                IConfigurationElement element = elements[i];
                this.addContextAdapterFactory(element);
                ++i;
            }
        }
    }

    private void addContextAdapterFactory(IConfigurationElement element) {
        String className = element.getAttribute("class");
        Object o = PluginUtil.instantiate((String)element.getContributor().getName(), (String)className);
        if (o instanceof AbstractVersionContextAdapterFactory) {
            this._versionContextAdapterFactories.add((AbstractVersionContextAdapterFactory)o);
        } else if (o instanceof AbstractVariantContextAdapterFactory) {
            this._variantContextAdapterFactories.add((AbstractVariantContextAdapterFactory)o);
        }
    }

    private MetadataModelContextAdapterFactory() {
    }

    public IVersion getVersionContext(IMetaDataModelContext context) {
        for (AbstractVersionContextAdapterFactory factory : this._versionContextAdapterFactories) {
            if (!factory.isFactoryFor(context)) continue;
            return factory.getVersionContext(context);
        }
        return null;
    }

    public IVariant getVariantContext(IMetaDataModelContext context) {
        for (AbstractVariantContextAdapterFactory factory : this._variantContextAdapterFactories) {
            if (!factory.isFactoryFor(context)) continue;
            return factory.getVariantContext(context);
        }
        return null;
    }

    public List<AbstractVersionContextAdapterFactory> getVersionContextAdapterFactories() {
        return Collections.unmodifiableList(this._versionContextAdapterFactories);
    }

    public List<AbstractVariantContextAdapterFactory> getVariantContextAdapterFactories() {
        return Collections.unmodifiableList(this._variantContextAdapterFactories);
    }
}

