/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.metadata.internal;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.eclipse.tools.application.common.services.Activator;
import oracle.eclipse.tools.application.common.services.metadata.IVersion;
import oracle.eclipse.tools.application.common.services.metadata.internal.DefaultVersionFactory;

public class Version
implements IVersion {
    private static final int[] VERSION_ARRAY_0_0 = new int[2];
    private static final Pattern pattern = Pattern.compile(".*?([0-9]+(\\.[0-9]+)*)");
    private String _versionString;
    private int[] _versionSegments;
    private static final String DOT = ".";

    public Version(String versionString) throws NumberFormatException {
        this._versionString = versionString;
        this._versionSegments = this.init(versionString);
    }

    int[] getVersionSegments() {
        return this._versionSegments;
    }

    private int[] init(String versionString) throws NumberFormatException {
        String temp = versionString != null ? versionString : "0.0";
        Matcher matcher = pattern.matcher(temp);
        ArrayList<Integer> intList = new ArrayList<Integer>();
        if (matcher.matches()) {
            temp = matcher.group(1);
            int dotPos = temp.indexOf(DOT);
            while (dotPos > 0) {
                String seg = temp.substring(0, dotPos);
                temp = temp.substring(dotPos + 1);
                Integer versionInt = this.parseInt(seg);
                if (versionInt == null) {
                    Activator.log(String.format("%s is not a valid version string, using 0.0", versionString), new Exception());
                    return VERSION_ARRAY_0_0;
                }
                intList.add(versionInt);
                dotPos = temp.indexOf(DOT);
            }
            Integer versionInt = this.parseInt(temp);
            if (versionInt == null) {
                Activator.log(String.format("%s is not a valid version string, using 0.0", versionString), new Exception());
                return VERSION_ARRAY_0_0;
            }
            intList.add(versionInt);
            int[] arrayOfInt = new int[intList.size()];
            int i = 0;
            while (i < intList.size()) {
                arrayOfInt[i] = (Integer)intList.get(i);
                ++i;
            }
            return arrayOfInt;
        }
        return VERSION_ARRAY_0_0;
    }

    private Integer parseInt(String seg) {
        try {
            return Integer.valueOf(seg);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    @Override
    public int compareTo(IVersion otherVersion) {
        if (otherVersion == this) {
            return 0;
        }
        int[] otherSegs = this.getComparableVersion(otherVersion).getVersionSegments();
        int MAX_SEGS = Math.max(this._versionSegments.length, otherSegs.length);
        int i = 0;
        while (i < MAX_SEGS) {
            int otherSeg;
            int thisSeg = this._versionSegments.length - 1 >= i ? this._versionSegments[i] : 0;
            int diff = thisSeg - (otherSeg = otherSegs.length - 1 >= i ? otherSegs[i] : 0);
            if (diff != 0) {
                return diff;
            }
            ++i;
        }
        return 0;
    }

    @Override
    public String getVersionString() {
        return this._versionString;
    }

    public String toString() {
        return "Version: " + this.getVersionString();
    }

    private Version getComparableVersion(IVersion otherVersion) {
        Version compVersion = null;
        compVersion = !(otherVersion instanceof Version) ? (Version)new DefaultVersionFactory().getVersion(otherVersion.getVersionString()) : (Version)otherVersion;
        return compVersion;
    }
}

