/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.metadata.internal;

import oracle.eclipse.tools.application.common.services.Activator;
import oracle.eclipse.tools.application.common.services.metadata.internal.StandardMetaDataFileInfo2;
import oracle.eclipse.tools.application.common.services.metadata.internal.StandardMetaDataFileRegistry2;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class StandardMetaDataFileRegistryReader2 {
    protected static final String EXTENSION_POINT_ID = "standardMetaDataFiles";
    protected static final String TAG_NAME = "StandardMetaDataFile";
    protected static final String ATT_URI = "uri";
    protected static final String ATT_LOCATION = "location";
    protected static final String ATT_LOCATOR = "locator";
    private StandardMetaDataFileRegistry2 annotationFileRegistry;

    public StandardMetaDataFileRegistryReader2(StandardMetaDataFileRegistry2 registry) {
        this.annotationFileRegistry = registry;
    }

    public void readRegistry() {
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint point = extensionRegistry.getExtensionPoint("oracle.eclipse.tools.application.common.services", EXTENSION_POINT_ID);
        if (point != null) {
            IConfigurationElement[] elements = point.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                this.readElement(elements[i]);
                ++i;
            }
        }
    }

    private void readElement(IConfigurationElement element) {
        if (element.getName().equalsIgnoreCase(TAG_NAME)) {
            String uri = element.getAttribute(ATT_URI);
            String location = element.getAttribute(ATT_LOCATION);
            String locator = element.getAttribute(ATT_LOCATOR);
            String bundleId = null;
            if (uri != null && location != null) {
                try {
                    bundleId = element.getContributor().getName();
                    StandardMetaDataFileInfo2 fileInfo = new StandardMetaDataFileInfo2(location, bundleId, locator);
                    this.annotationFileRegistry.addStandardMetaDataFileInfo(uri, fileInfo);
                }
                catch (Exception e) {
                    Activator.log(4, "Internal Error: exception occurred while reading StandardMetaDataFile ext-pt: " + location + ":" + uri, e);
                }
            }
        }
    }
}

