/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.metadata.internal;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import oracle.eclipse.tools.application.common.services.Activator;
import oracle.eclipse.tools.application.common.services.TraceOptions;
import oracle.eclipse.tools.application.common.services.metadata.internal.DomainLoadingStrategyRegistry2;
import oracle.eclipse.tools.application.common.services.metadata.internal.IDomainLoadingStrategy2;
import oracle.eclipse.tools.application.common.services.metadata.internal.MetaDataModel2;
import oracle.eclipse.tools.application.common.services.metadata.internal.StandardModelFactory2;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jst.jsf.common.metadata.Model;
import org.eclipse.jst.jsf.common.metadata.internal.AbstractMetaDataModelManager;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataModelContext;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataModelManager;
import org.eclipse.jst.jsf.common.metadata.internal.ModelNotSetException;

public final class MetaDataModelManager2
extends AbstractMetaDataModelManager {
    private static IMetaDataModelManager SHARED_INSTANCE;
    private static final Lock GLOBAL_INSTANCE_LOCK;
    private final ModelMap models = new ModelMap();

    static {
        GLOBAL_INSTANCE_LOCK = new ReentrantLock();
    }

    public static synchronized IMetaDataModelManager getSharedInstance() {
        if (SHARED_INSTANCE == null) {
            SHARED_INSTANCE = new MetaDataModelManager2(null);
        }
        return SHARED_INSTANCE;
    }

    private boolean isCommonModelsManagerInstance() {
        return this == MetaDataModelManager2.getSharedInstance();
    }

    MetaDataModelManager2(IProject project) {
    }

    public Model getModel(IMetaDataModelContext modelContext) {
        boolean gotLock = false;
        try {
            int numTries = 0;
            Job currentJob = Job.getJobManager().currentJob();
            while (numTries < 6 && !(gotLock = GLOBAL_INSTANCE_LOCK.tryLock(5000L, TimeUnit.MILLISECONDS))) {
                ++numTries;
                if (currentJob == null) continue;
                currentJob.yieldRule(null);
            }
            if (!gotLock) {
                return null;
            }
            StandardModelFactory2.debug(">START getModel: " + modelContext, TraceOptions.MD_GET);
            Model m = null;
            if (!this.isCommonModelsManagerInstance()) {
                m = MetaDataModelManager2.getSharedInstance().getModel(modelContext);
            }
            if (m == null) {
                MetaDataModel2 model = this.models.get(modelContext);
                if (model == null) {
                    long in = System.nanoTime();
                    if (TraceOptions.MD_LOAD_TIME) {
                        System.out.println("Start load: " + modelContext.getModelIdentifier());
                    }
                    model = this.loadMetadata(modelContext);
                    if (TraceOptions.MD_LOAD_TIME) {
                        System.out.println("\t\tTime to load " + modelContext.getModelIdentifier() + ": " + String.valueOf((double)(System.nanoTime() - in) / 1000000.0));
                    }
                } else if (model.needsRefresh()) {
                    try {
                        model.reload();
                    }
                    catch (ModelNotSetException modelNotSetException) {
                        model = this.loadMetadata(modelContext);
                    }
                }
                StandardModelFactory2.debug(">END getModel: " + modelContext, TraceOptions.MD_GET);
                if (model != null && !model.isEmpty()) {
                    Model model2 = (Model)model.getRoot();
                    return model2;
                }
            }
            Model model = m;
            return model;
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        finally {
            if (gotLock) {
                GLOBAL_INSTANCE_LOCK.unlock();
            }
        }
    }

    private MetaDataModel2 loadMetadata(IMetaDataModelContext context) {
        IDomainLoadingStrategy2 strategy = DomainLoadingStrategyRegistry2.getInstance().getLoadingStrategy(context.getDomainId());
        if (strategy == null) {
            Activator.log(4, "Internal Error: Unable to locate metadata loading strategy for: " + context.toString());
            return null;
        }
        MetaDataModel2 model = new MetaDataModel2(this, context, strategy);
        model.load();
        this.addModel(model);
        return model;
    }

    private void addModel(MetaDataModel2 model) {
        if (model != null) {
            this.models.put(model);
        }
    }

    public void dispose() {
        super.dispose();
        this.models.dispose();
    }

    public void destroy() {
        this.dispose();
    }

    private static class ModelMap {
        final Map<String, MetaDataModel2> map;
        private final AtomicBoolean _isDisposed = new AtomicBoolean(false);

        ModelMap() {
            this.map = new HashMap<String, MetaDataModel2>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void put(MetaDataModel2 model) {
            assert (!this._isDisposed.get());
            String key = this.calculateKey(model);
            ModelMap modelMap = this;
            synchronized (modelMap) {
                this.map.put(key, model);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public MetaDataModel2 get(IMetaDataModelContext context) {
            assert (!this._isDisposed.get());
            String key = this.calculateKey(context);
            ModelMap modelMap = this;
            synchronized (modelMap) {
                return this.map.get(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dispose() {
            if (this._isDisposed.compareAndSet(false, true)) {
                ModelMap modelMap = this;
                synchronized (modelMap) {
                    Iterator<Map.Entry<String, MetaDataModel2>> it = this.map.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry<String, MetaDataModel2> entry = it.next();
                        MetaDataModel2 model = entry.getValue();
                        if (model != null) {
                            model.cleanup();
                        }
                        it.remove();
                    }
                }
            }
        }

        private String calculateKey(MetaDataModel2 model) {
            return this.calculateKey(model.getModelContext());
        }

        private String calculateKey(IMetaDataModelContext context) {
            StringBuffer buf = new StringBuffer(context.getDomainId()).append(":").append(context.getModelIdentifier());
            return buf.toString().toUpperCase();
        }
    }
}

