/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.metadata.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import oracle.eclipse.tools.application.common.services.Activator;
import oracle.eclipse.tools.application.common.services.metadata.internal.IMetaDataLocator2;
import oracle.eclipse.tools.application.common.services.metadata.internal.IPathSensitiveMetaDataLocator2;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;

public class MetaDataLocatorFactory2
implements IResourceChangeListener {
    private static MetaDataLocatorFactory2 INSTANCE = null;
    private Map<String, IMetaDataLocator2> _locators;
    private static final boolean DEBUG = false;

    public static synchronized MetaDataLocatorFactory2 getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new MetaDataLocatorFactory2();
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)INSTANCE, 6);
        }
        return INSTANCE;
    }

    private Map<String, IMetaDataLocator2> getLocators() {
        if (this._locators == null) {
            this._locators = new HashMap<String, IMetaDataLocator2>();
        }
        return this._locators;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IMetaDataLocator2 getLocator(String locatorClassName, String bundleId, IProject project) {
        Class<?> klass = Activator.loadClass(locatorClassName, bundleId);
        String key = this.getKey(locatorClassName, bundleId);
        IMetaDataLocator2 locator = null;
        try {
            IMetaDataLocator2 tempLocator = (IMetaDataLocator2)klass.newInstance();
            if (tempLocator == null) return locator;
            if (tempLocator instanceof IPathSensitiveMetaDataLocator2) {
                if (project == null) {
                    return null;
                }
                key = this.getKey(locatorClassName, project.getName());
            }
            if ((locator = this.getLocators().get(key)) != null) return locator;
            locator = tempLocator;
            if (locator instanceof IPathSensitiveMetaDataLocator2) {
                ((IPathSensitiveMetaDataLocator2)locator).setProjectContext(project);
            }
            this.getLocators().put(key, locator);
            locator.startLocating();
            return locator;
        }
        catch (InstantiationException e) {
            Activator.log("Could not instantiate IMetaDataLocator2: " + key, e);
            return locator;
        }
        catch (IllegalAccessException e) {
            Activator.log("IllegalAccessException while creating IMetaDataLocator2: " + key, e);
        }
        return locator;
    }

    private String getKey(String locatorClassName, String contextId) {
        StringBuffer buf = new StringBuffer(contextId);
        buf.append(":");
        buf.append(locatorClassName);
        return buf.toString();
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        for (IMetaDataLocator2 locator : this.getLocators().values()) {
            locator.stopLocating();
        }
        this.getLocators().clear();
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IProject aProject;
        if ((event.getType() == 2 || event.getType() == 4) && (aProject = (IProject)event.getResource()) != null) {
            ArrayList<String> locatorsToRemove = new ArrayList<String>();
            for (String key : this.getLocators().keySet()) {
                if (!this.locatorIsForProject(key, aProject.getName())) continue;
                locatorsToRemove.add(key);
            }
            if (!locatorsToRemove.isEmpty()) {
                for (String key : locatorsToRemove) {
                    IMetaDataLocator2 locator = this.getLocators().get(key);
                    locator.stopLocating();
                    this.getLocators().remove(key);
                }
            }
        }
    }

    private boolean locatorIsForProject(String key, String projectName) {
        StringTokenizer t = new StringTokenizer(key, ":");
        String contextId = t.nextToken();
        return contextId.equals(projectName);
    }
}

