/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.metadata.internal;

import java.util.HashSet;
import java.util.Set;
import oracle.eclipse.tools.application.common.services.Activator;
import oracle.eclipse.tools.application.common.services.metadata.internal.IDomainSourceModelType2;
import oracle.eclipse.tools.application.common.services.metadata.internal.IDomainSourceModelTypeDescriptor2;
import oracle.eclipse.tools.application.common.services.metadata.internal.IMetaDataLocator2;
import oracle.eclipse.tools.application.common.services.metadata.internal.MetaDataLocatorFactory2;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class DomainSourceModelTypeDescriptor
implements IDomainSourceModelTypeDescriptor2 {
    private static final String TRANSLATORS_EXTENSION_POINT_ID = "domainSourceModelTypeTranslators";
    private static final String STANDARD_FILE_NULL_TRANSLATOR = "oracle.eclipse.tools.application.common.services.metadata.internal.StandardMetaDataFilesTranslator";
    private String domain = "DEFAULT";
    private String domainSourceModelTypeId;
    private String locatorClassName = "oracle.eclipse.tools.application.common.services.metadata.internal.StandardMetaDataLocator";
    private Set translatorDescriptors;
    private String bundleId = "oracle.eclipse.tools.application.common.services";
    private int ordinal;

    public DomainSourceModelTypeDescriptor(String domain, String domainSourceModelTypeId, String locatorClassName, String bundleId, int ordinal) {
        this.domain = domain;
        this.locatorClassName = locatorClassName;
        this.domainSourceModelTypeId = domainSourceModelTypeId;
        this.bundleId = bundleId;
        this.ordinal = ordinal;
        this.init();
    }

    public DomainSourceModelTypeDescriptor() {
    }

    private synchronized void init() {
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint point = extensionRegistry.getExtensionPoint("oracle.eclipse.tools.application.common.services", TRANSLATORS_EXTENSION_POINT_ID);
        if (point != null) {
            IConfigurationElement[] elements = point.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                IConfigurationElement element = elements[i];
                String srcHdlrId = element.getAttribute("domainSourceModelTypeId");
                if (srcHdlrId.equals(this.domainSourceModelTypeId)) {
                    this.addTranslatorDescriptor(element);
                }
                ++i;
            }
        }
    }

    private void addTranslatorDescriptor(IConfigurationElement element) {
        String translator = element.getAttribute("translatorClass");
        DomainSourceModelTranslatorDescriptor d = new DomainSourceModelTranslatorDescriptor(translator, element.getContributor().getName());
        this.getTranslatorDescriptors().add(d);
    }

    private Set getTranslatorDescriptors() {
        if (this.translatorDescriptors == null) {
            this.translatorDescriptors = new HashSet();
        }
        return this.translatorDescriptors;
    }

    @Override
    public String getId() {
        return this.domainSourceModelTypeId;
    }

    @Override
    public String getBundleId() {
        return this.bundleId;
    }

    @Override
    public String getLocatorClassName() {
        return this.locatorClassName;
    }

    @Override
    public int getOrdinal() {
        return this.ordinal;
    }

    @Override
    public String getDomain() {
        return this.domain;
    }

    public IDomainSourceModelType2 getInstance() {
        return new DomainSourceModelTypeImpl();
    }

    static class DomainSourceModelTranslatorDescriptor {
        private final String _translator;
        private final String _bundleId;

        public DomainSourceModelTranslatorDescriptor(String translator, String bundleId) {
            this._translator = translator;
            this._bundleId = bundleId;
        }

        String getTranslator() {
            return this._translator;
        }

        String getBundleId() {
            return this._bundleId;
        }
    }

    class DomainSourceModelTypeImpl
    implements IDomainSourceModelType2 {
        private Set translators;
        private IMetaDataLocator2 locator;

        DomainSourceModelTypeImpl() {
        }

        @Override
        public IDomainSourceModelTypeDescriptor2 getDomainSourceModelTypeDescriptor() {
            return DomainSourceModelTypeDescriptor.this;
        }

        @Override
        public int getOrdinal() {
            return DomainSourceModelTypeDescriptor.this.ordinal;
        }

        @Override
        public IMetaDataLocator2 getLocator(IProject project) {
            if (this.locator == null) {
                this.locator = MetaDataLocatorFactory2.getInstance().getLocator(DomainSourceModelTypeDescriptor.this.locatorClassName, DomainSourceModelTypeDescriptor.this.bundleId, project);
            }
            return this.locator;
        }

        public Set getTranslators() {
            if (this.translators == null) {
                this.translators = this.createTranslatorInstances();
            }
            return this.translators;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer("DomainSourceModelTypeImpl");
            buf.append("(type = ");
            buf.append(DomainSourceModelTypeDescriptor.this.getId());
            buf.append(", domain = ");
            buf.append(DomainSourceModelTypeDescriptor.this.getDomain());
            buf.append(", locator = ");
            buf.append(this.locator != null ? this.locator.toString() : "null");
            buf.append(")");
            return buf.toString();
        }

        private Set createTranslatorInstances() {
            this.translators = new HashSet();
            if (DomainSourceModelTypeDescriptor.this.getTranslatorDescriptors().size() == 0) {
                Class<?> klass = Activator.loadClass(DomainSourceModelTypeDescriptor.STANDARD_FILE_NULL_TRANSLATOR, "oracle.eclipse.tools.application.common.services");
                try {
                    this.translators.add(klass.newInstance());
                    return this.translators;
                }
                catch (InstantiationException e) {
                    Activator.log("Error in createTranslatorInstances(STANDARD_FILE_NULL_TRANSLATOR)", e);
                }
                catch (IllegalAccessException e) {
                    Activator.log("Error in createTranslatorInstances(STANDARD_FILE_NULL_TRANSLATOR)", e);
                }
            }
            for (DomainSourceModelTranslatorDescriptor d : DomainSourceModelTypeDescriptor.this.getTranslatorDescriptors()) {
                Class<?> klass = Activator.loadClass(d.getTranslator(), d.getBundleId());
                try {
                    this.translators.add(klass.newInstance());
                }
                catch (InstantiationException e) {
                    Activator.log("Error in createTranslatorInstances", e);
                }
                catch (IllegalAccessException e) {
                    Activator.log("Error in createTranslatorInstances", e);
                }
            }
            return this.translators;
        }
    }
}

