/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.metadata.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import oracle.eclipse.tools.application.common.services.Activator;
import oracle.eclipse.tools.application.common.services.metadata.internal.DomainLoadingStrategy2;
import oracle.eclipse.tools.application.common.services.metadata.internal.IDomainLoadingStrategy2;
import oracle.eclipse.tools.application.common.services.metadata.internal.IDomainSourceModelTypeDescriptor2;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class DomainLoadingStrategyRegistry2 {
    public static final String DEFAULT_DOMAIN = "TagLibraryDomain";
    private static DomainLoadingStrategyRegistry2 INSTANCE;
    private Map<String, DomainLoadingStrategyDescriptorImpl> domainLoadingStrategyDescriptors;
    private static final String EXTENSION_POINT_ID = "domainIdentifiers";

    private DomainLoadingStrategyRegistry2() {
        this.init();
    }

    public static synchronized DomainLoadingStrategyRegistry2 getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DomainLoadingStrategyRegistry2();
        }
        return INSTANCE;
    }

    final synchronized void init() {
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint point = extensionRegistry.getExtensionPoint("oracle.eclipse.tools.application.common.services", EXTENSION_POINT_ID);
        if (point != null) {
            IConfigurationElement[] elements = point.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                IConfigurationElement element = elements[i];
                DomainLoadingStrategyDescriptorImpl dls = new DomainLoadingStrategyDescriptorImpl(element);
                this.addDomainLoadingStrategyDescriptor(dls);
                ++i;
            }
        }
    }

    protected void addDomainLoadingStrategyDescriptor(DomainLoadingStrategyDescriptorImpl strategy) {
        this.getDescriptors().put(strategy.getDomain(), strategy);
    }

    public IDomainLoadingStrategy2 getLoadingStrategy(String domain) {
        DomainLoadingStrategyDescriptorImpl strategy = this.getDescriptors().get(domain);
        if (strategy == null) {
            return this.createDefaultLoadingStrategy();
        }
        return this.createLoadingStrategy(domain);
    }

    private IDomainLoadingStrategy2 createDefaultLoadingStrategy() {
        return new DomainLoadingStrategy2(DEFAULT_DOMAIN);
    }

    private IDomainLoadingStrategy2 createLoadingStrategy(String domain) {
        return this.getDescriptors().get(domain).newInstance();
    }

    private Map<String, DomainLoadingStrategyDescriptorImpl> getDescriptors() {
        if (this.domainLoadingStrategyDescriptors == null) {
            this.domainLoadingStrategyDescriptors = new HashMap<String, DomainLoadingStrategyDescriptorImpl>();
        }
        return this.domainLoadingStrategyDescriptors;
    }

    private static class DomainLoadingStrategyDescriptorImpl
    implements IDomainSourceModelTypeDescriptor2 {
        String domain;
        String loadingStrategyClassName;
        String bundleId;
        Class strategy;
        IConfigurationElement element;

        DomainLoadingStrategyDescriptorImpl(IConfigurationElement element) {
            this.element = element;
            this.init();
        }

        private void init() {
            this.domain = this.element.getAttribute("domainId");
            this.bundleId = this.element.getContributor().getName();
            this.loadingStrategyClassName = this.element.getAttribute("domainLoadingStrategy");
        }

        @Override
        public String getDomain() {
            return this.domain;
        }

        @Override
        public String getId() {
            return null;
        }

        @Override
        public String getBundleId() {
            return this.bundleId;
        }

        @Override
        public String getLocatorClassName() {
            return null;
        }

        @Override
        public int getOrdinal() {
            return 0;
        }

        public IDomainLoadingStrategy2 newInstance() {
            try {
                Class[] parameterTypes = new Class[]{String.class};
                Object[] initargs = new Object[]{this.domain};
                Object loader = this.getLoadingStrategy().getConstructor(parameterTypes).newInstance(initargs);
                if (loader instanceof IDomainLoadingStrategy2) {
                    return (IDomainLoadingStrategy2)loader;
                }
            }
            catch (InstantiationException e) {
                Activator.log(4, "Unable to instantiate IDomainLoadingStrategy for: " + this.domain, e);
            }
            catch (IllegalAccessException e) {
                Activator.log(4, "IllegalAccessException during creation of IDomainLoadingStrategy for: " + this.domain, e);
            }
            catch (IllegalArgumentException e) {
                Activator.log(4, "IllegalArgumentException during creation of IDomainLoadingStrategy for: " + this.domain, e);
            }
            catch (SecurityException e) {
                Activator.log(4, "SecurityException during creation of IDomainLoadingStrategy for: " + this.domain, e);
            }
            catch (InvocationTargetException e) {
                Activator.log(4, "InvocationTargetException during creation of IDomainLoadingStrategy for: " + this.domain, e);
            }
            catch (NoSuchMethodException e) {
                Activator.log(4, "NoSuchMethodException during creation of IDomainLoadingStrategy for: " + this.domain, e);
            }
            return null;
        }

        private Class getLoadingStrategy() {
            if (this.strategy == null) {
                this.strategy = Activator.loadClass(this.loadingStrategyClassName, this.bundleId);
            }
            return this.strategy;
        }
    }
}

