/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.metadata.internal;

import oracle.eclipse.tools.application.common.services.metadata.Metadata2Factory;
import oracle.eclipse.tools.application.common.services.metadata.Trait2;
import oracle.eclipse.tools.application.common.services.metadata.internal.AbstractMetaDataTranslator2;
import oracle.eclipse.tools.application.common.services.metadata.internal.IMetaDataSourceModelProvider2;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jst.jsf.common.metadata.Entity;
import org.eclipse.jst.jsf.common.metadata.MetadataFactory;
import org.eclipse.jst.jsf.common.metadata.MetadataPackage;
import org.eclipse.jst.jsf.common.metadata.Model;
import org.eclipse.jst.jsf.common.metadata.Trait;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataSourceModelProvider;
import org.eclipse.jst.jsf.common.metadata.traittypes.traittypes.BooleanValue;
import org.eclipse.jst.jsf.common.metadata.traittypes.traittypes.StringValue;
import org.eclipse.jst.jsf.common.metadata.traittypes.traittypes.TraitTypesFactory;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;

public abstract class AbstractTagLibDomainContentModelMetaDataTranslator2
extends AbstractMetaDataTranslator2 {
    protected IMetaDataSourceModelProvider2 _modelProvider;
    private Model _model;

    @Override
    public Model translate(IMetaDataSourceModelProvider2 modelProvider) {
        this._modelProvider = modelProvider;
        CMDocument doc = this.getSourceModel();
        return this.doTranslate(doc);
    }

    protected Model doTranslate(CMDocument doc) {
        this.createTags(doc);
        this.createTagfileTraits(doc);
        return this.getModel();
    }

    protected void createSimpleStringEntityTraitIfNecessary(Entity entity, String key, String value) {
        if (value != null && !value.equals("")) {
            Trait t = this.internalCreateTrait(entity, key);
            StringValue val = TraitTypesFactory.eINSTANCE.createStringValue();
            val.setValue(value);
            t.setValue((EObject)val);
        }
    }

    protected void createSimpleBooleanObjectEntityTraitIfNecessary(Entity entity, String key, boolean value) {
        if (value) {
            Trait t = this.internalCreateTrait(entity, key);
            BooleanValue val = TraitTypesFactory.eINSTANCE.createBooleanValue();
            val.setTrue(value);
            t.setValue((EObject)val);
        }
    }

    protected Trait internalCreateTrait(Entity entity, String key) {
        Trait2 t = Metadata2Factory.eINSTANCE.createTrait2();
        t.setId(key);
        t.setSourceModelProvider(this._modelProvider);
        entity.getTraits().add((Object)t);
        return t;
    }

    protected void createTags(CMDocument doc) {
        for (CMElementDeclaration tag : doc.getElements()) {
            Entity entity = MetadataFactory.eINSTANCE.createEntity();
            entity.setId(this.getTagNodeName(tag));
            entity.setType("tag");
            this.getModel().getChildEntities().add((Object)entity);
            this.setTagEntityTraits(tag, entity);
        }
    }

    protected String getTagNodeName(CMElementDeclaration tag) {
        return tag.getNodeName();
    }

    protected void setTagEntityTraits(CMElementDeclaration tag, Entity entity) {
        this.createSimpleStringEntityTraitIfNecessary(entity, "display-label", this.getTagDisplayName(tag));
        this.createSimpleStringEntityTraitIfNecessary(entity, "description", this.getTagDescription(tag));
        this.createSimpleStringEntityTraitIfNecessary(entity, "small-icon", this.getTagSmallIcon(tag));
        this.createSimpleStringEntityTraitIfNecessary(entity, "large-icon", this.getTagLargeIcon(tag));
        this.createSimpleBooleanObjectEntityTraitIfNecessary(entity, "expert", this.getTagIsExpert(tag));
        this.createSimpleBooleanObjectEntityTraitIfNecessary(entity, "hidden", this.getTagIsHidden(tag));
        this.createAttributeEntities(entity, tag);
    }

    protected void createAttributeEntities(Entity tagEntity, CMElementDeclaration tag) {
        for (CMAttributeDeclaration cmAttr : tag.getAttributes()) {
            Entity attr = MetadataFactory.eINSTANCE.createEntity();
            attr.setId(cmAttr.getAttrName());
            tagEntity.getChildEntities().add((Object)attr);
            this.createAttributeTraits(attr, cmAttr);
        }
    }

    protected void createAttributeTraits(Entity attr, CMAttributeDeclaration cmAttr) {
        this.createSimpleStringEntityTraitIfNecessary(attr, "description", this.getTagAttributeDescription(cmAttr));
        this.createSimpleBooleanObjectEntityTraitIfNecessary(attr, "required", this.getTagAttributeIsRequired(cmAttr));
        this.createSimpleStringEntityTraitIfNecessary(attr, "default-value", this.getTagAttributeDefaultValue(cmAttr));
    }

    protected String getTagAttributeDescription(CMAttributeDeclaration cmAttr) {
        return null;
    }

    protected boolean getTagAttributeIsRequired(CMAttributeDeclaration cmAttr) {
        return cmAttr.getUsage() == 2;
    }

    protected String getTagAttributeDefaultValue(CMAttributeDeclaration cmAttr) {
        return null;
    }

    protected boolean getTagIsHidden(CMElementDeclaration tag) {
        return false;
    }

    protected boolean getTagIsExpert(CMElementDeclaration tag) {
        return false;
    }

    protected String getTagLargeIcon(CMElementDeclaration tag) {
        return null;
    }

    protected String getTagSmallIcon(CMElementDeclaration tag) {
        return null;
    }

    protected String getTagDescription(CMElementDeclaration tag) {
        return null;
    }

    protected String getTagDisplayName(CMElementDeclaration tag) {
        return tag.getElementName();
    }

    protected void createTagfileTraits(CMDocument doc) {
        Model model = this.getModel();
        this.createSimpleStringEntityTraitIfNecessary((Entity)model, "display-label", this.getURIDisplayLabel());
        this.createSimpleStringEntityTraitIfNecessary((Entity)model, "description", this.getURIDescription());
        this.createSimpleStringEntityTraitIfNecessary((Entity)model, "default-prefix", this.getURIDefaultPrefix());
        this.createSimpleBooleanObjectEntityTraitIfNecessary((Entity)model, "expert", this.getURIExpert());
        this.createSimpleBooleanObjectEntityTraitIfNecessary((Entity)model, "hidden", this.getURIHidden());
    }

    protected String getURIDisplayLabel() {
        return this.getModel().getId();
    }

    protected String getURIDefaultPrefix() {
        return null;
    }

    protected String getURIDescription() {
        return this.getModel().getId();
    }

    protected boolean getURIExpert() {
        return false;
    }

    protected boolean getURIHidden() {
        return false;
    }

    protected Model getModel() {
        if (this._model == null) {
            this._model = this.createTLDModel();
        }
        return this._model;
    }

    protected Model createTLDModel() {
        Model entity = this.getFactory().createModel();
        entity.setId(this.getURI());
        entity.setSourceModelProvider((IMetaDataSourceModelProvider)this._modelProvider);
        return entity;
    }

    protected abstract String getURI();

    public abstract String getVersion();

    protected MetadataFactory getFactory() {
        return (MetadataFactory)MetadataPackage.eINSTANCE.getEFactoryInstance();
    }

    protected CMDocument getSourceModel() {
        return (CMDocument)this._modelProvider.getSourceModel();
    }
}

