/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.javatypes;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class ReflectionUtil {
    public static Constructor findConstructor(ClassLoader loader, String className, String[] paramTypes) throws ClassNotFoundException, NoSuchMethodException {
        Class<?> c = loader.loadClass(className);
        Constructor<?>[] constructors = c.getConstructors();
        int i = 0;
        while (i < constructors.length) {
            Constructor<?> constructor = constructors[i];
            if (ReflectionUtil.equalsParams(constructor.getParameterTypes(), paramTypes)) {
                return constructor;
            }
            ++i;
        }
        throw new NoSuchMethodException("The constructor for the class " + className + " could not be found.");
    }

    public static Field findField(ClassLoader loader, String className, String fieldName) throws ClassNotFoundException, NoSuchFieldException {
        Class<?> c = loader.loadClass(className);
        Field field = c.getField(fieldName);
        if (field != null) {
            return field;
        }
        throw new NoSuchFieldException("The field " + fieldName + " for the class " + className + " could not be found.");
    }

    public static Method findMethod(ClassLoader loader, String className, String methodName, String[] paramTypes) throws ClassNotFoundException, NoSuchMethodException {
        Class<?> c = loader.loadClass(className);
        Method[] methods = c.getMethods();
        int i = 0;
        while (i < methods.length) {
            Method method = methods[i];
            if (methodName.equals(method.getName()) && ReflectionUtil.equalsParams(method.getParameterTypes(), paramTypes)) {
                return method;
            }
            ++i;
        }
        throw new NoSuchMethodException("The method " + methodName + " in the class " + className + " could not be found.");
    }

    public static Method findMethod(ClassLoader loader, Class cl, String methodName, String[] paramTypes) throws ClassNotFoundException, NoSuchMethodException {
        return ReflectionUtil.findMethod(loader, cl.getName(), methodName, paramTypes);
    }

    public static Object invoke(Object obj, String methodName, Class[] paramTypes, Object[] paramValues) throws Exception {
        Method method = ReflectionUtil.findDeclaredMethod(obj, methodName, paramTypes);
        if (!method.isAccessible()) {
            method.setAccessible(true);
        }
        return method.invoke(obj, paramValues);
    }

    public static Method findDeclaredMethod(Object obj, String methodName, Class[] paramTypes) throws NoSuchMethodException {
        for (Class<?> c = obj.getClass(); c != null; c = c.getSuperclass()) {
            try {
                return c.getDeclaredMethod(methodName, paramTypes);
            }
            catch (NoSuchMethodException e) {
                if (c != null) continue;
                throw e;
            }
        }
        return null;
    }

    private static boolean equalsParams(Class[] classes, String[] names) {
        if (names == null) {
            return classes.length == 0;
        }
        if (names.length != classes.length) {
            return false;
        }
        int i = 0;
        while (i < classes.length) {
            Class cl = classes[i];
            String name = names[i];
            if (!cl.getName().equals(name)) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

