/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.javatypes;

import org.eclipse.jdt.core.IJavaElementDelta;

public abstract class JavaDeltaVisitor {
    public void accept(IJavaElementDelta delta, VisitOrder visitOrder) {
        switch (visitOrder) {
            case PREORDER: {
                this.internalPreOrderAccept(delta);
                break;
            }
            case POSTORDER: {
                this.internalPostOrderAccept(delta);
            }
        }
    }

    protected boolean internalPostOrderAccept(IJavaElementDelta delta) {
        boolean shouldContinue = true;
        IJavaElementDelta[] iJavaElementDeltaArray = delta.getAffectedChildren();
        int n = iJavaElementDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElementDelta child = iJavaElementDeltaArray[n2];
            if (!(shouldContinue &= this.internalPreOrderAccept(child))) break;
            ++n2;
        }
        return shouldContinue && this.visit(delta);
    }

    protected boolean internalPreOrderAccept(IJavaElementDelta delta) {
        boolean shouldContinue = this.visit(delta);
        if (!shouldContinue) {
            return false;
        }
        IJavaElementDelta[] iJavaElementDeltaArray = delta.getAffectedChildren();
        int n = iJavaElementDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElementDelta child = iJavaElementDeltaArray[n2];
            if (!(shouldContinue &= this.internalPreOrderAccept(child))) break;
            ++n2;
        }
        return shouldContinue;
    }

    protected abstract boolean visit(IJavaElementDelta var1);

    public static enum VisitOrder {
        PREORDER,
        POSTORDER;

    }
}

