/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.documentservices;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import oracle.eclipse.tools.application.common.services.documentservices.IDocumentLocalizationContext;
import oracle.eclipse.tools.common.services.dependency.artifact.Range;
import oracle.eclipse.tools.common.services.util.SerializationUtil;

public class LocalizationRangeStore<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int LOCK_MAX_WAIT_TIME_IN_MILLIS = 60000;
    private final transient Set<RangeKeyedValue<T>> _data = new HashSet<RangeKeyedValue<T>>();
    private T _overrideConstant;
    private final transient ReadWriteLock _lock = new ReentrantReadWriteLock(true);
    private final transient CopyOnWriteArrayList<IRangeStoreListener> _listeners = new CopyOnWriteArrayList();
    private final IDocumentLocalizationContext.LocalizationChange.Type _localizationType;

    public LocalizationRangeStore(T overrideConstant, IDocumentLocalizationContext.LocalizationChange.Type localizationType) {
        this._overrideConstant = overrideConstant;
        this._localizationType = localizationType;
    }

    public void addRangeValue(Range range, Range definitionRange, T value) {
        this.acquireWriteLock();
        try {
            this._data.add(new RangeKeyedValue<T>(range, definitionRange, value));
        }
        finally {
            this.releaseWriteLock();
        }
        this.fireEvent(new RangeStoreChangeEvent(new IDocumentLocalizationContext.LocalizationChange(this._localizationType, Collections.singletonList(range), Collections.EMPTY_LIST)));
    }

    public void update(Set<RangeKeyedValue<T>> values) {
        boolean needToFireEvent = false;
        RangeStoreChangeDelta<T> delta = null;
        this.acquireWriteLock();
        try {
            delta = this.isDifferent(values);
            if (!delta.isEmpty()) {
                this._data.clear();
                this._data.addAll(values);
                needToFireEvent = true;
            }
        }
        finally {
            this.releaseWriteLock();
        }
        if (needToFireEvent) {
            this.fireEvent(new RangeStoreChangeEvent(new IDocumentLocalizationContext.LocalizationChange(this._localizationType, delta.getAddedRanges(), delta.getRemovedRanges())));
        }
    }

    private RangeStoreChangeDelta<T> isDifferent(Set<RangeKeyedValue<T>> values) {
        RangeStoreChangeDelta delta = new RangeStoreChangeDelta();
        for (RangeKeyedValue<T> keyedValue : values) {
            if (this._data.contains(keyedValue)) continue;
            delta.addAddedValue(keyedValue);
        }
        for (RangeKeyedValue<T> keyedValue : this._data) {
            if (values.contains(keyedValue)) continue;
            delta.addRemovedValue(keyedValue);
        }
        return delta;
    }

    public T getRangeValue(int offset) {
        this.acquireReadLock();
        try {
            RangeKeyedValue<T> bestPossValues = null;
            for (RangeKeyedValue<T> possValue : this._data) {
                long curBestOffset;
                if (!possValue.getRange().contains((long)offset)) continue;
                if (bestPossValues == null) {
                    bestPossValues = possValue;
                    continue;
                }
                long newOffset = possValue.getRange().getOffset();
                if ((long)offset - newOffset >= (long)offset - (curBestOffset = bestPossValues.getRange().getOffset())) continue;
                bestPossValues = possValue;
            }
            if (bestPossValues != null) {
                Object t = bestPossValues.getValue();
                return t;
            }
            return null;
        }
        finally {
            this.releaseReadLock();
        }
    }

    public Set<RangeKeyedValue<T>> getRanges() {
        return Collections.unmodifiableSet(this._data);
    }

    public T getOverrideValue() {
        return this._overrideConstant;
    }

    public void setOverrideValue(T oc) {
        this._overrideConstant = oc;
    }

    public void clear(Range range) {
        RangeStoreChangeDelta delta = new RangeStoreChangeDelta();
        this.acquireWriteLock();
        try {
            Iterator<RangeKeyedValue<T>> testRangeIt = this._data.iterator();
            while (testRangeIt.hasNext()) {
                RangeKeyedValue<T> testRange = testRangeIt.next();
                if (!range.contains(testRange.getRange().getOffset())) continue;
                testRangeIt.remove();
                delta.addRemovedValue(testRange);
            }
        }
        finally {
            this.releaseWriteLock();
        }
        this.fireEvent(new RangeStoreChangeEvent(new IDocumentLocalizationContext.LocalizationChange(this._localizationType, delta.getAddedRanges(), delta.getRemovedRanges())));
    }

    public void clear() {
        RangeStoreChangeDelta delta = new RangeStoreChangeDelta();
        this.acquireWriteLock();
        try {
            Iterator<RangeKeyedValue<T>> testRangeIt = this._data.iterator();
            while (testRangeIt.hasNext()) {
                RangeKeyedValue<T> testRange = testRangeIt.next();
                testRangeIt.remove();
                delta.addRemovedValue(testRange);
            }
        }
        finally {
            this.releaseWriteLock();
        }
        this.fireEvent(new RangeStoreChangeEvent(new IDocumentLocalizationContext.LocalizationChange(this._localizationType, delta.getAddedRanges(), delta.getRemovedRanges())));
    }

    public int size() {
        this.acquireReadLock();
        try {
            int n = this._data.size();
            return n;
        }
        finally {
            this.releaseReadLock();
        }
    }

    private void acquireReadLock() throws IllegalStateException {
        block8: {
            boolean interrupted = false;
            long endTime = System.currentTimeMillis() + 60000L;
            while (true) {
                try {
                    if (this._lock.readLock().tryLock(60000L, TimeUnit.MILLISECONDS)) {
                        return;
                    }
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    interrupted = true;
                    if (System.currentTimeMillis() < endTime) continue;
                    break block8;
                }
                break;
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        throw new IllegalStateException("Unable to acquire read lock");
    }

    private void releaseReadLock() {
        this._lock.readLock().unlock();
    }

    private void acquireWriteLock() throws IllegalStateException {
        block8: {
            boolean interrupted = false;
            long endTime = System.currentTimeMillis() + 60000L;
            while (true) {
                try {
                    if (this._lock.writeLock().tryLock(60000L, TimeUnit.MILLISECONDS)) {
                        return;
                    }
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    interrupted = true;
                    if (System.currentTimeMillis() < endTime) continue;
                    break block8;
                }
                break;
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        throw new IllegalStateException("Unable to acquire write lock");
    }

    private void releaseWriteLock() throws IllegalStateException {
        this._lock.writeLock().unlock();
    }

    public void addListener(IRangeStoreListener listener) {
        this._listeners.addIfAbsent(listener);
    }

    public void removeListener(IRangeStoreListener listener) {
        this._listeners.remove(listener);
    }

    protected final void fireEvent(RangeStoreChangeEvent event) {
        for (IRangeStoreListener listener : this._listeners) {
            listener.changeOccurred(event);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException, IllegalAccessException {
        in.defaultReadObject();
        SerializationUtil su = SerializationUtil.forInput((ObjectInputStream)in);
        su.setFinalField((Object)this, "_lock", ReadWriteLock.class, (Object)new ReentrantReadWriteLock(true));
        su.setFinalField((Object)this, "_data", HashSet.class, new HashSet());
        su.setFinalField((Object)this, "_listeners", CopyOnWriteArrayList.class, new CopyOnWriteArrayList());
        int countData = in.readInt();
        int i = 0;
        while (i < countData) {
            Object data = in.readObject();
            if (!(data instanceof RangeKeyedValue)) {
                throw new IllegalStateException("Data is of incorrect type.");
            }
            this._data.add((RangeKeyedValue)data);
            ++i;
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        this.acquireReadLock();
        try {
            int countData = this._data.size();
            out.writeInt(countData);
            for (RangeKeyedValue<T> data : this._data) {
                out.writeObject(data);
            }
        }
        finally {
            this.releaseReadLock();
        }
    }

    public static interface IRangeStoreListener {
        public void changeOccurred(RangeStoreChangeEvent var1);
    }

    public static class RangeKeyedValue<T>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final Range _range;
        private final T _value;
        private final Range _definitionRange;

        public RangeKeyedValue(Range range, Range definitionRange, T value) {
            if (range == null) {
                throw new NullPointerException("Range can't be null");
            }
            this._range = range;
            this._value = value;
            this._definitionRange = definitionRange;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other instanceof RangeKeyedValue && this._range.equals((Object)((RangeKeyedValue)other)._range)) {
                T key2 = ((RangeKeyedValue)other)._value;
                if (this._value != null && key2 != null) {
                    return this._value.equals(key2);
                }
                if (this._value == null && key2 == null) {
                    return true;
                }
            }
            return false;
        }

        public int hashCode() {
            int hashCode = this._range.hashCode();
            if (this._value != null) {
                hashCode ^= this._value.hashCode();
            }
            return hashCode;
        }

        public final Range getRange() {
            return this._range;
        }

        public final Range getDefinitionRange() {
            return this._definitionRange;
        }

        public final T getValue() {
            return this._value;
        }

        public String toString() {
            return "Range: " + this.getRange().toString() + " value: " + this._value;
        }
    }

    public static final class RangeStoreChangeDelta<T> {
        private final List<RangeKeyedValue<T>> _addedValues = new ArrayList<RangeKeyedValue<T>>();
        private final List<RangeKeyedValue<T>> _removedValues = new ArrayList<RangeKeyedValue<T>>();

        public boolean isEmpty() {
            return this._addedValues.isEmpty() && this._removedValues.isEmpty();
        }

        public final List<RangeKeyedValue<T>> getAddedValues() {
            return Collections.unmodifiableList(this._addedValues);
        }

        public final List<RangeKeyedValue<T>> getRemovedValues() {
            return Collections.unmodifiableList(this._removedValues);
        }

        private void addAddedValue(RangeKeyedValue<T> value) {
            this._addedValues.add(value);
        }

        private void addRemovedValue(RangeKeyedValue<T> value) {
            this._removedValues.add(value);
        }

        public List<Range> getAddedRanges() {
            return this.createRangeList(this._addedValues);
        }

        public List<Range> getRemovedRanges() {
            return this.createRangeList(this._removedValues);
        }

        private List<Range> createRangeList(List<RangeKeyedValue<T>> fromThis) {
            ArrayList<Range> ranges = new ArrayList<Range>();
            for (RangeKeyedValue<T> value : fromThis) {
                ranges.add(value.getRange());
            }
            return Collections.unmodifiableList(ranges);
        }
    }

    public static class RangeStoreChangeEvent {
        private final IDocumentLocalizationContext.LocalizationChange _change;

        public RangeStoreChangeEvent(IDocumentLocalizationContext.LocalizationChange change) {
            this._change = change;
        }

        public final IDocumentLocalizationContext.LocalizationChange getChange() {
            return this._change;
        }
    }
}

