/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.document.validator;

import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.application.common.services.document.ExpressionBuilder;
import oracle.eclipse.tools.application.common.services.document.XPathResolver;
import oracle.eclipse.tools.application.common.services.document.validator.AbstractValidate;
import oracle.eclipse.tools.common.services.catalogue.message.CataloguedMessage;
import oracle.eclipse.tools.common.services.catalogue.problem.ProblemCatalogueIndex;
import org.eclipse.core.resources.IFile;
import org.eclipse.jst.jsf.common.sets.AxiomaticSet;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class ValidateDependentBlock
extends AbstractValidate {
    private final List<ExpressionBuilder> _needsToBePresentBlock;
    private final ExpressionBuilder _checkForBlock;
    private final List<String> _checkForBlockVariableName;

    public ValidateDependentBlock(ExpressionBuilder needsToBePresentBlock, ExpressionBuilder checkForBlock, String checkForBlockVariableName, ProblemCatalogueIndex index) {
        this(Collections.singletonList(needsToBePresentBlock), checkForBlock, Collections.singletonList(checkForBlockVariableName), index);
    }

    public ValidateDependentBlock(List<ExpressionBuilder> needsToBePresentBlock, ExpressionBuilder checkForBlock, List<String> checkForBlockVariableName, ProblemCatalogueIndex index) {
        super(index);
        this._needsToBePresentBlock = needsToBePresentBlock;
        this._checkForBlock = checkForBlock;
        this._checkForBlockVariableName = checkForBlockVariableName;
    }

    @Override
    public boolean validate(IFile targetFile, Document document, List<CataloguedMessage> reporter) {
        int i = 0;
        for (ExpressionBuilder expr : this._needsToBePresentBlock) {
            Element element = this.getElement(document, expr);
            if (element == null) {
                return false;
            }
            String variableName = this.getVariable(element);
            if (variableName.length() > 0 || this._checkForBlockVariableName.get(i).length() == 0) {
                this._checkForBlock.putSubstitution(this._checkForBlockVariableName.get(i++), variableName);
                continue;
            }
            return false;
        }
        boolean foundProblem = false;
        String resolvedExpression = this._checkForBlock.getResolvedExpression();
        XPathResolver validationResolver = new XPathResolver(document, resolvedExpression, this._checkForBlock.getNamespaceContext());
        if (!validationResolver.exists()) {
            CataloguedMessage createMessage = this.createMessage(targetFile);
            createMessage.setLineNo(1);
            reporter.add(createMessage);
            foundProblem = true;
        }
        return foundProblem;
    }

    private Element getElement(Document document, ExpressionBuilder needsToBePresentBlock) {
        XPathResolver resolver = new XPathResolver(document, needsToBePresentBlock.getExpression(), needsToBePresentBlock.getNamespaceContext());
        AxiomaticSet axiomaticSet = resolver.getAxiomaticSet();
        if (!axiomaticSet.isEmpty()) {
            return (Element)axiomaticSet.getFirstElement();
        }
        return null;
    }

    private String getVariable(Element element) {
        String textContent = "";
        NodeList childNodes = element.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node item = childNodes.item(i);
            if (item.getNodeType() == 3) {
                textContent = String.valueOf(textContent) + ((Text)item).getNodeValue();
            }
            ++i;
        }
        return textContent.trim();
    }
}

