/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.document.validator;

import java.util.List;
import oracle.eclipse.tools.application.common.services.Activator;
import oracle.eclipse.tools.application.common.services.document.validator.Validate;
import oracle.eclipse.tools.common.services.catalogue.message.CataloguedMessage;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.w3c.dom.Document;

public class CompositeValidate
implements Validate {
    private List<Validate> _validators;

    public CompositeValidate(List<Validate> validators) {
        this._validators = validators;
    }

    @Override
    public boolean validate(final IFile targetFile, final Document document, final List<CataloguedMessage> reporter) {
        final boolean[] foundProblems = new boolean[]{false};
        for (final Validate validator : this._validators) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    foundProblems[0] = foundProblems[0] | validator.validate(targetFile, document, reporter);
                }

                public void handleException(Throwable exception) {
                    Activator.log("Validating file: " + targetFile.toString(), exception);
                }
            });
        }
        return foundProblems[0];
    }
}

