/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.document;

import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import oracle.eclipse.tools.application.common.services.document.ExpressionBuilder;
import oracle.eclipse.tools.application.common.services.document.XPathVariableResolverImpl;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XPathVariable {
    private final ExpressionBuilder _expression;
    private XPathVariableResolverImpl _resolver = null;
    private Object _defaultObject = null;
    private XPATHConstant _xpathConstant;

    public XPathVariable(ExpressionBuilder expression, XPATHConstant xpathConstant) {
        this(expression, xpathConstant, null);
    }

    public XPathVariable(ExpressionBuilder expression, XPATHConstant xpathConstant, Object defaultObject) {
        this._expression = expression;
        this._xpathConstant = xpathConstant;
        this._defaultObject = defaultObject;
    }

    public XPATHConstant getXPATHConstant() {
        return this._xpathConstant;
    }

    public XPathVariableResolverImpl getResolver() {
        return this._resolver;
    }

    public void setResolver(XPathVariableResolverImpl _resolver) {
        this._resolver = _resolver;
    }

    public Object getDefaultObject() {
        return this._defaultObject;
    }

    public boolean useDefaultObject() {
        return this._defaultObject != null;
    }

    public Object evaluate(Node document) {
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        xPath.setNamespaceContext(this._expression.getNamespaceContext());
        if (this._resolver != null) {
            this._resolver.setDocument(document);
            xPath.setXPathVariableResolver(this._resolver);
        }
        try {
            return xPath.evaluate(this._expression.getExpression(), document, this._xpathConstant.getXPathConstant());
        }
        catch (XPathExpressionException e) {
            LoggingService.logException((String)"oracle.eclipse.tools.application.common.services", (Throwable)e);
            return new Object();
        }
    }

    public static enum XPATHConstant {
        NODESET(XPathConstants.NODESET),
        NODE(XPathConstants.NODE),
        NUMBER(XPathConstants.NUMBER),
        STRING(XPathConstants.STRING),
        BOOLEAN(XPathConstants.BOOLEAN);

        private QName xPathConstant;

        private XPATHConstant(QName xPathConstant) {
            this.xPathConstant = xPathConstant;
        }

        public QName getXPathConstant() {
            return this.xPathConstant;
        }

        public boolean exists(Object value) {
            switch (this) {
                case BOOLEAN: {
                    return value instanceof Boolean;
                }
                case STRING: {
                    if (value instanceof String) {
                        return ((String)value).length() > 0;
                    }
                    return false;
                }
                case NODE: {
                    return value instanceof Node;
                }
                case NODESET: {
                    if (value instanceof NodeList) {
                        return ((NodeList)value).getLength() > 0;
                    }
                    return false;
                }
                case NUMBER: {
                    return value instanceof Number;
                }
            }
            return true;
        }
    }
}

