/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.application.common.services.document;

import oracle.eclipse.tools.application.common.services.document.MapNamespaceContext;
import oracle.eclipse.tools.application.common.services.document.XPathResolver;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Node;

public class XPathRegionResolver {
    private final XPathResolver _xPathResolver;

    public XPathRegionResolver(IDOMNode document, String xPath, String namespacePrefix, String namespace) {
        MapNamespaceContext mapNamespaceContext = null;
        if (namespacePrefix != null && namespace != null) {
            mapNamespaceContext = new MapNamespaceContext();
            mapNamespaceContext.put(namespacePrefix, namespace);
        }
        this._xPathResolver = new XPathResolver((Node)document, xPath, mapNamespaceContext);
    }

    public XPathRegionResolver(IDOMNode document, String xPath, MapNamespaceContext namespaceContext) {
        this._xPathResolver = new XPathResolver((Node)document, xPath, namespaceContext);
    }

    public IStructuredDocumentRegion evaluateParentDocumentRegion(RegionType type) {
        if (this._xPathResolver.exists()) {
            for (Node node : this._xPathResolver.getAxiomaticSet()) {
                Node parent = node.getParentNode();
                if (!(parent instanceof IDOMNode)) continue;
                return this.getRegionTypeDocumentRegion((IDOMNode)parent, type);
            }
        }
        return null;
    }

    public IStructuredDocumentRegion evaluateRegion(RegionType type) {
        if (this._xPathResolver.exists()) {
            if (this._xPathResolver.getAxiomaticSet().size() > 1) {
                return null;
            }
            return this.getRegionTypeDocumentRegion((IDOMNode)this._xPathResolver.getAxiomaticSet().getFirstElement(), type);
        }
        return null;
    }

    private IStructuredDocumentRegion getRegionTypeDocumentRegion(IDOMNode node, RegionType type) {
        if (RegionType.START.equals((Object)type)) {
            return node.getStartStructuredDocumentRegion();
        }
        if (RegionType.END.equals((Object)type)) {
            return node.getEndStructuredDocumentRegion();
        }
        return null;
    }

    public boolean exists() {
        return this._xPathResolver.exists();
    }

    public XPathResolver getXPathResolver() {
        return this._xPathResolver;
    }

    public static enum RegionType {
        START,
        END;

    }
}

